/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AtomicBackoff {
    private static final Logger log = Logger.getLogger(AtomicBackoff.class.getName());
    private final String name;
    private final AtomicLong value = new AtomicLong();

    public AtomicBackoff(String string, long l) {
        Preconditions.checkArgument((l > 0L ? 1 : 0) != 0, (Object)"value must be positive");
        this.name = string;
        this.value.set(l);
    }

    public final State getState() {
        return new State(this.value.get());
    }

    public final class State {
        private final long savedValue;
        static final /* synthetic */ boolean $assertionsDisabled;

        private State(long l) {
            this.savedValue = l;
        }

        public final long get() {
            return this.savedValue;
        }

        public final void backoff() {
            long l = Math.max(this.savedValue << 1, this.savedValue);
            if (AtomicBackoff.this.value.compareAndSet(this.savedValue, l)) {
                log.logp(Level.WARNING, "io.grpc.internal.AtomicBackoff$State", "backoff", "Increased {0} to {1}", new Object[]{AtomicBackoff.this.name, l});
            }
        }
    }
}

