/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.internal.AbstractReadableBuffer;
import io.grpc.internal.ReadableBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;

public class CompositeReadableBuffer
extends AbstractReadableBuffer {
    private int readableBytes;
    private final Queue<ReadableBuffer> buffers = new ArrayDeque<ReadableBuffer>();

    public CompositeReadableBuffer() {
    }

    public void addBuffer(ReadableBuffer readableBuffer) {
        if (!(readableBuffer instanceof CompositeReadableBuffer)) {
            this.buffers.add(readableBuffer);
            this.readableBytes += readableBuffer.readableBytes();
            return;
        }
        CompositeReadableBuffer compositeReadableBuffer = (CompositeReadableBuffer)readableBuffer;
        while (!compositeReadableBuffer.buffers.isEmpty()) {
            ReadableBuffer readableBuffer2 = compositeReadableBuffer.buffers.remove();
            this.buffers.add(readableBuffer2);
        }
        this.readableBytes += compositeReadableBuffer.readableBytes;
        compositeReadableBuffer.readableBytes = 0;
        ((AbstractReadableBuffer)compositeReadableBuffer).close();
    }

    @Override
    public int readableBytes() {
        return this.readableBytes;
    }

    @Override
    public int readUnsignedByte() {
        ReadOperation readOperation = new ReadOperation(this){

            @Override
            int readInternal(ReadableBuffer readableBuffer, int n) {
                return readableBuffer.readUnsignedByte();
            }
        };
        this.execute(readOperation, 1);
        return readOperation.value;
    }

    @Override
    public void skipBytes(int n) {
        this.execute(new ReadOperation(this){

            @Override
            public int readInternal(ReadableBuffer readableBuffer, int n) {
                readableBuffer.skipBytes(n);
                return 0;
            }
        }, n);
    }

    @Override
    public void readBytes(final byte[] byArray, final int n, int n2) {
        this.execute(new ReadOperation(this){
            int currentOffset;
            {
                this.currentOffset = n;
            }

            @Override
            public int readInternal(ReadableBuffer readableBuffer, int n2) {
                readableBuffer.readBytes(byArray, this.currentOffset, n2);
                this.currentOffset += n2;
                return 0;
            }
        }, n2);
    }

    @Override
    public void readBytes(final ByteBuffer byteBuffer) {
        this.execute(new ReadOperation(this){

            @Override
            public int readInternal(ReadableBuffer readableBuffer, int n) {
                int n2 = byteBuffer.limit();
                byteBuffer.limit(byteBuffer.position() + n);
                readableBuffer.readBytes(byteBuffer);
                byteBuffer.limit(n2);
                return 0;
            }
        }, byteBuffer.remaining());
    }

    @Override
    public void readBytes(final OutputStream outputStream, int n) throws IOException {
        ReadOperation readOperation = new ReadOperation(this){

            @Override
            public int readInternal(ReadableBuffer readableBuffer, int n) throws IOException {
                readableBuffer.readBytes(outputStream, n);
                return 0;
            }
        };
        this.execute(readOperation, n);
        if (readOperation.isError()) {
            throw readOperation.ex;
        }
    }

    @Override
    public CompositeReadableBuffer readBytes(int n) {
        this.checkReadable(n);
        this.readableBytes -= n;
        CompositeReadableBuffer compositeReadableBuffer = new CompositeReadableBuffer();
        while (n > 0) {
            ReadableBuffer readableBuffer = this.buffers.peek();
            if (readableBuffer.readableBytes() > n) {
                compositeReadableBuffer.addBuffer(readableBuffer.readBytes(n));
                n = 0;
                continue;
            }
            compositeReadableBuffer.addBuffer(this.buffers.poll());
            n -= readableBuffer.readableBytes();
        }
        return compositeReadableBuffer;
    }

    @Override
    public void close() {
        while (!this.buffers.isEmpty()) {
            this.buffers.remove().close();
        }
    }

    private void execute(ReadOperation readOperation, int n) {
        this.checkReadable(n);
        while (n > 0 && !this.buffers.isEmpty()) {
            ReadableBuffer readableBuffer = this.buffers.peek();
            int n2 = Math.min(n, readableBuffer.readableBytes());
            readOperation.read(readableBuffer, n2);
            if (readOperation.isError()) {
                return;
            }
            n -= n2;
            this.readableBytes -= n2;
            this.advanceBufferIfNecessary();
        }
        if (n > 0) {
            throw new AssertionError((Object)"Failed executing read operation");
        }
    }

    private void advanceBufferIfNecessary() {
        if (this.buffers.peek().readableBytes() == 0) {
            this.buffers.remove().close();
        }
    }

    static abstract class ReadOperation {
        int value;
        IOException ex;

        private ReadOperation() {
        }

        final void read(ReadableBuffer readableBuffer, int n) {
            try {
                this.value = this.readInternal(readableBuffer, n);
                return;
            }
            catch (IOException iOException) {
                this.ex = iOException;
                return;
            }
        }

        final boolean isError() {
            return this.ex != null;
        }

        abstract int readInternal(ReadableBuffer var1, int var2) throws IOException;
    }
}

