/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.zza;
import io.grpc.zzbu;
import io.grpc.zzbv;
import io.grpc.zzbw;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

final class DnsNameResolver
extends zzbu {
    private static final Logger logger = Logger.getLogger(DnsNameResolver.class.getName());
    private static final boolean isJndiAvailable = DnsNameResolver.jndiAvailable();
    static boolean enableJndi = false;
    private DelegateResolver delegateResolver = this.pickDelegateResolver();
    private final String authority;
    private final String host;
    private final int port;
    private final SharedResourceHolder.Resource<ScheduledExecutorService> timerServiceResource;
    private final SharedResourceHolder.Resource<ExecutorService> executorResource;
    private boolean shutdown;
    private ScheduledExecutorService timerService;
    private ExecutorService executor;
    private ScheduledFuture<?> resolutionTask;
    private boolean resolving;
    private zzbw listener;
    private final Runnable resolutionRunnable = new Runnable(){

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };
    private final Runnable resolutionRunnableOnExecutor = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DnsNameResolver dnsNameResolver = DnsNameResolver.this;
            synchronized (dnsNameResolver) {
                if (!DnsNameResolver.this.shutdown) {
                    DnsNameResolver.this.executor.execute(DnsNameResolver.this.resolutionRunnable);
                }
                return;
            }
        }
    };

    DnsNameResolver(String string, String string2, zza zza2, SharedResourceHolder.Resource<ScheduledExecutorService> resource, SharedResourceHolder.Resource<ExecutorService> resource2) {
        this.timerServiceResource = resource;
        this.executorResource = resource2;
        String string3 = String.valueOf(string2);
        URI uRI = URI.create(string3.length() != 0 ? "//".concat(string3) : new String("//"));
        this.authority = (String)Preconditions.checkNotNull((Object)uRI.getAuthority(), (String)"nameUri (%s) doesn't have an authority", (Object)uRI);
        this.host = (String)Preconditions.checkNotNull((Object)uRI.getHost(), (Object)"host");
        if (uRI.getPort() == -1) {
            Integer n = zza2.zza(zzbv.PARAMS_DEFAULT_PORT);
            if (n != null) {
                this.port = n;
                return;
            }
            throw new IllegalArgumentException(new StringBuilder(69 + String.valueOf(string2).length()).append("name '").append(string2).append("' doesn't contain a port, and default port is not set in params").toString());
        }
        this.port = uRI.getPort();
    }

    @Override
    public final String getServiceAuthority() {
        return this.authority;
    }

    @Override
    public final synchronized void start(zzbw zzbw2) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.timerService = SharedResourceHolder.get(this.timerServiceResource);
        this.executor = SharedResourceHolder.get(this.executorResource);
        this.listener = (zzbw)Preconditions.checkNotNull((Object)zzbw2, (Object)"listener");
        this.resolve();
    }

    @Override
    public final synchronized void refresh() {
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"not started");
        this.resolve();
    }

    private final void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.executor.execute(this.resolutionRunnable);
    }

    @Override
    public final synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        if (this.resolutionTask != null) {
            this.resolutionTask.cancel(false);
        }
        if (this.timerService != null) {
            this.timerService = SharedResourceHolder.release(this.timerServiceResource, this.timerService);
        }
        if (this.executor != null) {
            this.executor = SharedResourceHolder.release(this.executorResource, this.executor);
        }
    }

    final int getPort() {
        return this.port;
    }

    private final DelegateResolver pickDelegateResolver() {
        JdkResolver jdkResolver = new JdkResolver();
        if (isJndiAvailable && enableJndi) {
            return new CompositeResolver(jdkResolver, new JndiResolver());
        }
        return jdkResolver;
    }

    final void setDelegateResolver(DelegateResolver delegateResolver) {
        this.delegateResolver = delegateResolver;
    }

    static boolean jndiAvailable() {
        try {
            Class.forName("javax.naming.directory.InitialDirContext");
            Class.forName("com.sun.jndi.dns.DnsContextFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.logp(Level.FINE, "io.grpc.internal.DnsNameResolver", "jndiAvailable", "Unable to find JNDI DNS resolver, skipping", classNotFoundException);
            return false;
        }
        return true;
    }

    static /* synthetic */ ScheduledFuture access$000(DnsNameResolver dnsNameResolver) {
        return dnsNameResolver.resolutionTask;
    }

    static /* synthetic */ ScheduledFuture access$002(DnsNameResolver dnsNameResolver, ScheduledFuture scheduledFuture) {
        dnsNameResolver.resolutionTask = scheduledFuture;
        return dnsNameResolver.resolutionTask;
    }

    static /* synthetic */ zzbw access$200(DnsNameResolver dnsNameResolver) {
        return dnsNameResolver.listener;
    }

    static /* synthetic */ boolean access$302(DnsNameResolver dnsNameResolver, boolean bl) {
        dnsNameResolver.resolving = bl;
        return dnsNameResolver.resolving;
    }

    static /* synthetic */ String access$400(DnsNameResolver dnsNameResolver) {
        return dnsNameResolver.host;
    }

    static /* synthetic */ int access$500(DnsNameResolver dnsNameResolver) {
        return dnsNameResolver.port;
    }

    static /* synthetic */ DelegateResolver access$600(DnsNameResolver dnsNameResolver) {
        return dnsNameResolver.delegateResolver;
    }

    static /* synthetic */ Runnable access$700(DnsNameResolver dnsNameResolver) {
        return dnsNameResolver.resolutionRunnableOnExecutor;
    }

    static /* synthetic */ ScheduledExecutorService access$800(DnsNameResolver dnsNameResolver) {
        return dnsNameResolver.timerService;
    }

    static final class JndiResolver
    extends DelegateResolver {
        private static final String[] rrTypes = new String[]{"TXT"};
        static final /* synthetic */ boolean $assertionsDisabled;

        JndiResolver() {
        }

        @Override
        final ResolutionResults resolve(String string) throws NamingException {
            String string2 = String.valueOf(string);
            Attributes attributes = new InitialDirContext().getAttributes(string2.length() != 0 ? "dns:///".concat(string2) : new String("dns:///"), rrTypes);
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            try (NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();){
                while (namingEnumeration.hasMore()) {
                    try (NamingEnumeration<?> namingEnumeration2 = namingEnumeration.next().getAll();){
                        while (namingEnumeration2.hasMore()) {
                            String string3 = (String)namingEnumeration2.next();
                            arrayList2.add(string3);
                        }
                    }
                }
            }
            return new ResolutionResults(arrayList, arrayList2);
        }
    }

    static final class JdkResolver
    extends DelegateResolver {
        JdkResolver() {
        }

        @Override
        final ResolutionResults resolve(String string) throws Exception {
            return new ResolutionResults(Arrays.asList(InetAddress.getAllByName(string)), Collections.emptyList());
        }
    }

    static final class CompositeResolver
    extends DelegateResolver {
        private final DelegateResolver jdkResovler;
        private final DelegateResolver jndiResovler;

        CompositeResolver(DelegateResolver delegateResolver, DelegateResolver delegateResolver2) {
            this.jdkResovler = delegateResolver;
            this.jndiResovler = delegateResolver2;
        }

        @Override
        final ResolutionResults resolve(String string) throws Exception {
            List<InetAddress> list = this.jdkResovler.resolve((String)string).addresses;
            List<String> list2 = Collections.emptyList();
            try {
                list2 = this.jndiResovler.resolve((String)string).txtRecords;
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, "io.grpc.internal.DnsNameResolver$CompositeResolver", "resolve", "Failed to resolve TXT results", exception);
            }
            return new ResolutionResults(list, list2);
        }
    }

    static final class ResolutionResults {
        final List<InetAddress> addresses;
        final List<String> txtRecords;

        ResolutionResults(List<InetAddress> list, List<String> list2) {
            this.addresses = Collections.unmodifiableList((List)Preconditions.checkNotNull(list, (Object)"addresses"));
            this.txtRecords = Collections.unmodifiableList((List)Preconditions.checkNotNull(list2, (Object)"txtRecords"));
        }
    }

    static abstract class DelegateResolver {
        DelegateResolver() {
        }

        abstract ResolutionResults resolve(String var1) throws Exception;
    }
}

