/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.BackoffPolicy;
import java.util.Random;
import java.util.concurrent.TimeUnit;

final class ExponentialBackoffPolicy
implements BackoffPolicy {
    private Random random = new Random();
    private long initialBackoffNanos = TimeUnit.SECONDS.toNanos(1L);
    private long maxBackoffNanos = TimeUnit.MINUTES.toNanos(2L);
    private double multiplier = 1.6;
    private double jitter = 0.2;
    private long nextBackoffNanos = this.initialBackoffNanos;

    ExponentialBackoffPolicy() {
    }

    @Override
    public final long nextBackoffNanos() {
        long l = this.nextBackoffNanos;
        this.nextBackoffNanos = Math.min((long)((double)l * this.multiplier), this.maxBackoffNanos);
        return l + this.uniformRandom(-this.jitter * (double)l, this.jitter * (double)l);
    }

    private final long uniformRandom(double d, double d2) {
        Preconditions.checkArgument((d2 >= d ? 1 : 0) != 0);
        double d3 = d2 - d;
        return (long)(this.random.nextDouble() * d3 + d);
    }

    final ExponentialBackoffPolicy setRandom(Random random) {
        this.random = random;
        return this;
    }

    final ExponentialBackoffPolicy setInitialBackoffNanos(long l) {
        this.initialBackoffNanos = l;
        return this;
    }

    final ExponentialBackoffPolicy setMaxBackoffNanos(long l) {
        this.maxBackoffNanos = l;
        return this;
    }

    final ExponentialBackoffPolicy setMultiplier(double d) {
        this.multiplier = d;
        return this;
    }

    final ExponentialBackoffPolicy setJitter(double d) {
        this.jitter = d;
        return this;
    }

    static final class Provider
    implements BackoffPolicy.Provider {
        Provider() {
        }

        @Override
        public final BackoffPolicy get() {
            return new ExponentialBackoffPolicy();
        }
    }
}

