/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdgi;
import com.google.android.gms.internal.zzdgl;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.InternalMetadata;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.FailingClientTransport;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.SubchannelImpl;
import io.grpc.zzax;
import io.grpc.zzaz;
import io.grpc.zzbe;
import io.grpc.zzbj;
import io.grpc.zzbm;
import io.grpc.zzbp;
import io.grpc.zzcq;
import io.grpc.zzcs;
import io.grpc.zzh;
import io.grpc.zzq;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class GrpcUtil {
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final boolean IS_RESTRICTED_APPENGINE = System.getProperty("com.google.appengine.runtime.environment") != null && "1.7".equals(System.getProperty("java.specification.version"));
    public static final zzbm<Long> TIMEOUT_KEY = zzbm.zza("grpc-timeout", new TimeoutMarshaller());
    public static final zzbm<String> MESSAGE_ENCODING_KEY = zzbm.zza("grpc-encoding", zzbe.zzpar);
    public static final zzbm<byte[]> MESSAGE_ACCEPT_ENCODING_KEY = InternalMetadata.zza("grpc-accept-encoding", new AcceptEncodingMarshaller());
    public static final zzbm<String> CONTENT_TYPE_KEY = zzbm.zza("content-type", zzbe.zzpar);
    public static final zzbm<String> USER_AGENT_KEY = zzbm.zza("user-agent", zzbe.zzpar);
    public static final int DEFAULT_PORT_PLAINTEXT = 80;
    public static final int DEFAULT_PORT_SSL = 443;
    public static final String CONTENT_TYPE_GRPC = "application/grpc";
    public static final String HTTP_METHOD = "POST";
    public static final String TE_TRAILERS = "trailers";
    public static final String TIMEOUT = "grpc-timeout";
    public static final String MESSAGE_ENCODING = "grpc-encoding";
    public static final String MESSAGE_ACCEPT_ENCODING = "grpc-accept-encoding";
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x400000;
    public static final int DEFAULT_MAX_HEADER_LIST_SIZE = 8192;
    public static final Splitter ACCEPT_ENCODING_SPLITTER = Splitter.on((char)',').trimResults();
    private static final String IMPLEMENTATION_VERSION = GrpcUtil.getImplementationVersion();
    public static final long DEFAULT_KEEPALIVE_TIME_NANOS = TimeUnit.MINUTES.toNanos(1L);
    public static final long DEFAULT_KEEPALIVE_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(20L);
    public static final long KEEPALIVE_TIME_NANOS_DISABLED = Long.MAX_VALUE;
    public static final long DEFAULT_SERVER_KEEPALIVE_TIME_NANOS = TimeUnit.HOURS.toNanos(2L);
    public static final long DEFAULT_SERVER_KEEPALIVE_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(20L);
    public static final long SERVER_KEEPALIVE_TIME_NANOS_DISABLED = Long.MAX_VALUE;
    public static final SharedResourceHolder.Resource<ExecutorService> SHARED_CHANNEL_EXECUTOR = new SharedResourceHolder.Resource<ExecutorService>(){
        private static final String NAME = "grpc-default-executor";

        @Override
        public ExecutorService create() {
            return Executors.newCachedThreadPool(GrpcUtil.getThreadFactory("grpc-default-executor-%d", true));
        }

        @Override
        public void close(ExecutorService executorService) {
            executorService.shutdown();
        }

        public String toString() {
            return NAME;
        }
    };
    public static final SharedResourceHolder.Resource<ScheduledExecutorService> TIMER_SERVICE = new SharedResourceHolder.Resource<ScheduledExecutorService>(){

        @Override
        public ScheduledExecutorService create() {
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, GrpcUtil.getThreadFactory("grpc-timer-%d", true));
            try {
                scheduledExecutorService.getClass().getMethod("setRemoveOnCancelPolicy", Boolean.TYPE).invoke((Object)scheduledExecutorService, true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return scheduledExecutorService;
        }

        @Override
        public void close(ScheduledExecutorService scheduledExecutorService) {
            scheduledExecutorService.shutdown();
        }
    };
    public static final Supplier<Stopwatch> STOPWATCH_SUPPLIER = new Supplier<Stopwatch>(){

        public Stopwatch get() {
            return Stopwatch.createUnstarted();
        }
    };

    public static zzcq httpStatusToGrpcStatus(int n) {
        return GrpcUtil.httpStatusToGrpcCode(n).zzcyw().zztw(new StringBuilder(28).append("HTTP status code ").append(n).toString());
    }

    private static zzcs httpStatusToGrpcCode(int n) {
        if (n >= 100 && n < 200) {
            return zzcs.zzpda;
        }
        switch (n) {
            case 400: 
            case 431: {
                return zzcs.zzpda;
            }
            case 401: {
                return zzcs.zzpdd;
            }
            case 403: {
                return zzcs.zzpcu;
            }
            case 404: {
                return zzcs.zzpcz;
            }
            case 429: 
            case 502: 
            case 503: 
            case 504: {
                return zzcs.zzpdb;
            }
        }
        return zzcs.zzpcp;
    }

    public static boolean isGrpcContentType(String string) {
        if (string == null) {
            return false;
        }
        if (16 > string.length()) {
            return false;
        }
        if (!(string = string.toLowerCase()).startsWith(CONTENT_TYPE_GRPC)) {
            return false;
        }
        if (string.length() == 16) {
            return true;
        }
        char c = string.charAt(16);
        return c == '+' || c == ';';
    }

    public static String getGrpcUserAgent(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2);
            stringBuilder.append(' ');
        }
        stringBuilder.append("grpc-java-");
        stringBuilder.append(string);
        stringBuilder.append(IMPLEMENTATION_VERSION);
        return stringBuilder.toString();
    }

    public static URI authorityToUri(String string) {
        URI uRI;
        Preconditions.checkNotNull((Object)string, (Object)"authority");
        try {
            uRI = new URI(null, string, null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            String string2 = String.valueOf(string);
            throw new IllegalArgumentException(string2.length() != 0 ? "Invalid authority: ".concat(string2) : new String("Invalid authority: "), uRISyntaxException);
        }
        return uRI;
    }

    public static String checkAuthority(String string) {
        URI uRI = GrpcUtil.authorityToUri(string);
        Preconditions.checkArgument((uRI.getHost() != null ? 1 : 0) != 0, (String)"No host in authority '%s'", (Object)string);
        Preconditions.checkArgument((uRI.getUserInfo() == null ? 1 : 0) != 0, (String)"Userinfo must not be present on authority: '%s'", (Object)string);
        return string;
    }

    public static String authorityFromHostAndPort(String string, int n) {
        try {
            return new URI(null, null, string, n, null, null, null).getAuthority();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(string).length()).append("Invalid host or port: ").append(string).append(" ").append(n).toString(), uRISyntaxException);
        }
    }

    public static ThreadFactory getThreadFactory(String string, boolean bl) {
        ThreadFactory threadFactory = zzdgi.zzbju();
        if (IS_RESTRICTED_APPENGINE) {
            return threadFactory;
        }
        return new zzdgl().zza(threadFactory).zzca(bl).zzoe(string).zzbjw();
    }

    static ClientTransport getTransportFromPickResult(zzax zzax2, boolean bl) {
        zzaz zzaz2 = zzax2.zzcya();
        final ClientTransport clientTransport = zzaz2 != null ? ((SubchannelImpl)zzaz2).obtainActiveTransport() : null;
        if (clientTransport != null) {
            final zzq zzq2 = zzax2.zzcyb();
            if (zzq2 == null) {
                return clientTransport;
            }
            return new ClientTransport(){

                @Override
                public ClientStream newStream(zzbp<?, ?> zzbp2, zzbe zzbe2, zzh zzh2) {
                    return clientTransport.newStream(zzbp2, zzbe2, zzh2.zza(zzq2));
                }

                @Override
                public ClientStream newStream(zzbp<?, ?> zzbp2, zzbe zzbe2) {
                    return this.newStream(zzbp2, zzbe2, zzh.zzoyj);
                }

                @Override
                public void ping(ClientTransport.PingCallback pingCallback, Executor executor) {
                    clientTransport.ping(pingCallback, executor);
                }
            };
        }
        if (!zzax2.zzcxk().zzcyt() && !bl) {
            return new FailingClientTransport(zzax2.zzcxk());
        }
        return null;
    }

    private GrpcUtil() {
    }

    private static String getImplementationVersion() {
        String string = GrpcUtil.class.getPackage().getImplementationVersion();
        if (string != null) {
            String string2 = String.valueOf(string);
            if (string2.length() != 0) {
                return "/".concat(string2);
            }
            return new String("/");
        }
        return "";
    }

    static class TimeoutMarshaller
    implements zzbj<Long> {
        TimeoutMarshaller() {
        }

        @Override
        public String toAsciiString(Long l) {
            TimeUnit timeUnit = TimeUnit.NANOSECONDS;
            if (l < 0L) {
                throw new IllegalArgumentException("Timeout too small");
            }
            if (l < 100000000L) {
                String string = String.valueOf(l);
                return new StringBuilder(1 + String.valueOf(string).length()).append(string).append("n").toString();
            }
            if (l < 100000000000L) {
                long l2 = timeUnit.toMicros(l);
                return new StringBuilder(21).append(l2).append("u").toString();
            }
            if (l < 100000000000000L) {
                long l3 = timeUnit.toMillis(l);
                return new StringBuilder(21).append(l3).append("m").toString();
            }
            if (l < 100000000000000000L) {
                long l4 = timeUnit.toSeconds(l);
                return new StringBuilder(21).append(l4).append("S").toString();
            }
            if (l < 6000000000000000000L) {
                long l5 = timeUnit.toMinutes(l);
                return new StringBuilder(21).append(l5).append("M").toString();
            }
            long l6 = timeUnit.toHours(l);
            return new StringBuilder(21).append(l6).append("H").toString();
        }

        @Override
        public Long parseAsciiString(String string) {
            Preconditions.checkArgument((string.length() > 0 ? 1 : 0) != 0, (Object)"empty timeout");
            Preconditions.checkArgument((string.length() <= 9 ? 1 : 0) != 0, (Object)"bad timeout format");
            long l = Long.parseLong(string.substring(0, string.length() - 1));
            char c = string.charAt(string.length() - 1);
            switch (c) {
                case 'n': {
                    return l;
                }
                case 'u': {
                    return TimeUnit.MICROSECONDS.toNanos(l);
                }
                case 'm': {
                    return TimeUnit.MILLISECONDS.toNanos(l);
                }
                case 'S': {
                    return TimeUnit.SECONDS.toNanos(l);
                }
                case 'M': {
                    return TimeUnit.MINUTES.toNanos(l);
                }
                case 'H': {
                    return TimeUnit.HOURS.toNanos(l);
                }
            }
            throw new IllegalArgumentException(String.format("Invalid timeout unit: %s", Character.valueOf(c)));
        }
    }

    public static enum Http2Error {
        NO_ERROR(0, zzcq.zzpcj),
        PROTOCOL_ERROR(1, zzcq.zzpci),
        INTERNAL_ERROR(2, zzcq.zzpci),
        FLOW_CONTROL_ERROR(3, zzcq.zzpci),
        SETTINGS_TIMEOUT(4, zzcq.zzpci),
        STREAM_CLOSED(5, zzcq.zzpci),
        FRAME_SIZE_ERROR(6, zzcq.zzpci),
        REFUSED_STREAM(7, zzcq.zzpcj),
        CANCEL(8, zzcq.zzpbv),
        COMPRESSION_ERROR(9, zzcq.zzpci),
        CONNECT_ERROR(10, zzcq.zzpci),
        ENHANCE_YOUR_CALM(11, zzcq.zzpcd.zztw("Bandwidth exhausted")),
        INADEQUATE_SECURITY(12, zzcq.zzpcb.zztw("Permission denied as protocol is not secure enough to call")),
        HTTP_1_1_REQUIRED(13, zzcq.zzpbw);

        private static final Http2Error[] codeMap;
        private final int code;
        private final zzcq status;

        private static Http2Error[] buildHttp2CodeMap() {
            Http2Error[] http2ErrorArray = Http2Error.values();
            Http2Error[] http2ErrorArray2 = new Http2Error[(int)http2ErrorArray[http2ErrorArray.length - 1].code() + 1];
            Http2Error[] http2ErrorArray3 = http2ErrorArray;
            int n = http2ErrorArray.length;
            for (int i = 0; i < n; ++i) {
                Http2Error http2Error = http2ErrorArray3[i];
                int n2 = (int)http2Error.code();
                http2ErrorArray2[n2] = http2Error;
            }
            return http2ErrorArray2;
        }

        private Http2Error(int n2, zzcq zzcq2) {
            this.code = n2;
            String string2 = String.valueOf(this.name());
            this.status = zzcq2.zztx(string2.length() != 0 ? "HTTP/2 error code: ".concat(string2) : new String("HTTP/2 error code: "));
        }

        public final long code() {
            return this.code;
        }

        public final zzcq status() {
            return this.status;
        }

        public static Http2Error forCode(long l) {
            if (l >= (long)codeMap.length || l < 0L) {
                return null;
            }
            return codeMap[(int)l];
        }

        public static zzcq statusForCode(long l) {
            Http2Error http2Error = Http2Error.forCode(l);
            if (http2Error == null) {
                return zzcq.zzlk(INTERNAL_ERROR.status().zzcys().value()).zztw(new StringBuilder(52).append("Unrecognized HTTP/2 error code: ").append(l).toString());
            }
            return http2Error.status();
        }

        static {
            codeMap = Http2Error.buildHttp2CodeMap();
        }
    }

    static final class AcceptEncodingMarshaller
    implements InternalMetadata.TrustedAsciiMarshaller<byte[]> {
        private AcceptEncodingMarshaller() {
        }

        @Override
        public final byte[] toAsciiString(byte[] byArray) {
            return byArray;
        }

        @Override
        public final byte[] parseAsciiString(byte[] byArray) {
            return byArray;
        }
    }
}

