/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Stopwatch;
import io.grpc.internal.ClientTransport;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Http2Ping {
    private static final Logger log = Logger.getLogger(Http2Ping.class.getName());
    private final long data;
    private final Stopwatch stopwatch;
    private Map<ClientTransport.PingCallback, Executor> callbacks = new LinkedHashMap<ClientTransport.PingCallback, Executor>();
    private boolean completed;
    private Throwable failureCause;
    private long roundTripTimeNanos;

    public Http2Ping(long l, Stopwatch stopwatch) {
        this.data = l;
        this.stopwatch = stopwatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(ClientTransport.PingCallback pingCallback, Executor executor) {
        Runnable runnable;
        Http2Ping http2Ping = this;
        synchronized (http2Ping) {
            if (!this.completed) {
                this.callbacks.put(pingCallback, executor);
                return;
            }
            runnable = this.failureCause != null ? Http2Ping.asRunnable(pingCallback, this.failureCause) : Http2Ping.asRunnable(pingCallback, this.roundTripTimeNanos);
        }
        Http2Ping.doExecute(executor, runnable);
    }

    public long payload() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete() {
        Map<ClientTransport.PingCallback, Executor> map;
        long l;
        Http2Ping http2Ping = this;
        synchronized (http2Ping) {
            if (this.completed) {
                return false;
            }
            this.completed = true;
            l = this.roundTripTimeNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            map = this.callbacks;
            this.callbacks = null;
        }
        for (Map.Entry entry : map.entrySet()) {
            Http2Ping.doExecute((Executor)entry.getValue(), Http2Ping.asRunnable((ClientTransport.PingCallback)entry.getKey(), l));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable throwable) {
        Map<ClientTransport.PingCallback, Executor> map;
        Http2Ping http2Ping = this;
        synchronized (http2Ping) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.failureCause = throwable;
            map = this.callbacks;
            this.callbacks = null;
        }
        for (Map.Entry entry : map.entrySet()) {
            Http2Ping.notifyFailed((ClientTransport.PingCallback)entry.getKey(), (Executor)entry.getValue(), throwable);
        }
    }

    public static void notifyFailed(ClientTransport.PingCallback pingCallback, Executor executor, Throwable throwable) {
        Http2Ping.doExecute(executor, Http2Ping.asRunnable(pingCallback, throwable));
    }

    private static void doExecute(Executor executor, Runnable runnable) {
        try {
            executor.execute(runnable);
            return;
        }
        catch (Throwable throwable) {
            log.logp(Level.SEVERE, "io.grpc.internal.Http2Ping", "doExecute", "Failed to execute PingCallback", throwable);
            return;
        }
    }

    private static Runnable asRunnable(final ClientTransport.PingCallback pingCallback, final long l) {
        return new Runnable(){

            @Override
            public void run() {
                pingCallback.onSuccess(l);
            }
        };
    }

    private static Runnable asRunnable(final ClientTransport.PingCallback pingCallback, final Throwable throwable) {
        return new Runnable(){

            @Override
            public void run() {
                pingCallback.onFailure(throwable);
            }
        };
    }
}

