/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.CallCredentialsApplyingTransportFactory;
import io.grpc.internal.ChannelExecutor;
import io.grpc.internal.ClientCallImpl;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.DelayedClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InUseStateAggregator;
import io.grpc.internal.InternalSubchannel;
import io.grpc.internal.LogExceptionRunnable;
import io.grpc.internal.LogId;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.OobChannel;
import io.grpc.internal.SubchannelImpl;
import io.grpc.internal.WithLogId;
import io.grpc.zza;
import io.grpc.zzah;
import io.grpc.zzak;
import io.grpc.zzau;
import io.grpc.zzav;
import io.grpc.zzaw;
import io.grpc.zzay;
import io.grpc.zzaz;
import io.grpc.zzba;
import io.grpc.zzbb;
import io.grpc.zzbp;
import io.grpc.zzbu;
import io.grpc.zzbv;
import io.grpc.zzbw;
import io.grpc.zzcd;
import io.grpc.zzcq;
import io.grpc.zzh;
import io.grpc.zzi;
import io.grpc.zzj;
import io.grpc.zzl;
import io.grpc.zzm;
import io.grpc.zzv;
import io.grpc.zzw;
import io.grpc.zzx;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public final class ManagedChannelImpl
extends zzbb
implements WithLogId {
    private static final Logger log = Logger.getLogger(ManagedChannelImpl.class.getName());
    static final Pattern URI_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+.-]*:/.*");
    static final long IDLE_TIMEOUT_MILLIS_DISABLE = -1L;
    static final long SUBCHANNEL_SHUTDOWN_DELAY_SECONDS = 5L;
    static final zzcq SHUTDOWN_NOW_STATUS = zzcq.zzpcj.zztw("Channel shutdownNow invoked");
    private final String target;
    private final zzbv nameResolverFactory;
    private final zza nameResolverParams;
    private final zzav loadBalancerFactory;
    private final ClientTransportFactory transportFactory;
    private final Executor executor;
    private final ObjectPool<? extends Executor> executorPool;
    private final ObjectPool<? extends Executor> oobExecutorPool;
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final ChannelExecutor channelExecutor = new ChannelExecutor();
    private final zzah decompressorRegistry;
    private final zzv compressorRegistry;
    private final ObjectPool<ScheduledExecutorService> timerServicePool;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final long idleTimeoutMillis;
    private volatile ScheduledExecutorService scheduledExecutor;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final zzi interceptorChannel;
    private final String userAgent;
    private zzbu nameResolver;
    private zzau loadBalancer;
    private volatile zzba subchannelPicker;
    private final Set<InternalSubchannel> subchannels = new HashSet<InternalSubchannel>(16, 0.75f);
    private final Set<InternalSubchannel> oobChannels = new HashSet<InternalSubchannel>(1, 0.75f);
    private final DelayedClientTransport delayedTransport;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private boolean shutdownNowed;
    private volatile boolean terminating;
    private volatile boolean terminated;
    private final CountDownLatch terminatedLatch = new CountDownLatch(1);
    private final ManagedClientTransport.Listener delayedTransportListener = new ManagedClientTransport.Listener(){

        @Override
        public void transportShutdown(zzcq zzcq2) {
            Preconditions.checkState((boolean)ManagedChannelImpl.this.shutdown.get(), (Object)"Channel must have been shut down");
        }

        @Override
        public void transportReady() {
        }

        @Override
        public void transportInUse(boolean bl) {
            ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(ManagedChannelImpl.this.delayedTransport, bl);
        }

        @Override
        public void transportTerminated() {
            Preconditions.checkState((boolean)ManagedChannelImpl.this.shutdown.get(), (Object)"Channel must have been shut down");
            ManagedChannelImpl.this.terminating = true;
            if (ManagedChannelImpl.this.loadBalancer != null) {
                ManagedChannelImpl.this.loadBalancer.shutdown();
                ManagedChannelImpl.this.loadBalancer = null;
            }
            if (ManagedChannelImpl.this.nameResolver != null) {
                ManagedChannelImpl.this.nameResolver.shutdown();
                ManagedChannelImpl.this.nameResolver = null;
            }
            ManagedChannelImpl.this.maybeShutdownNowSubchannels();
            ManagedChannelImpl.this.maybeTerminateChannel();
        }
    };
    final InUseStateAggregator<Object> inUseStateAggregator = new InUseStateAggregator<Object>(){

        @Override
        void handleInUse() {
            ManagedChannelImpl.this.exitIdleMode();
        }

        @Override
        void handleNotInUse() {
            if (ManagedChannelImpl.this.shutdown.get()) {
                return;
            }
            ManagedChannelImpl.this.rescheduleIdleTimer();
        }
    };
    private ScheduledFuture<?> idleModeTimerFuture;
    private IdleModeTimer idleModeTimer;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        @Override
        public ClientTransport get(zzay zzay2) {
            zzba zzba2 = ManagedChannelImpl.this.subchannelPicker;
            if (ManagedChannelImpl.this.shutdown.get()) {
                return ManagedChannelImpl.this.delayedTransport;
            }
            if (zzba2 == null) {
                ManagedChannelImpl.this.channelExecutor.executeLater(new Runnable(){

                    @Override
                    public void run() {
                        ManagedChannelImpl.this.exitIdleMode();
                    }
                }).drain();
                return ManagedChannelImpl.this.delayedTransport;
            }
            ClientTransport clientTransport = GrpcUtil.getTransportFromPickResult(zzba2.pickSubchannel(zzay2), zzay2.getCallOptions().zzcxf());
            if (clientTransport != null) {
                return clientTransport;
            }
            return ManagedChannelImpl.this.delayedTransport;
        }
    };

    private final void maybeShutdownNowSubchannels() {
        if (this.shutdownNowed) {
            Iterator<InternalSubchannel> iterator = this.subchannels.iterator();
            while (iterator.hasNext()) {
                iterator.next().shutdownNow(SHUTDOWN_NOW_STATUS);
            }
            iterator = this.oobChannels.iterator();
            while (iterator.hasNext()) {
                iterator.next().shutdownNow(SHUTDOWN_NOW_STATUS);
            }
        }
    }

    final void exitIdleMode() {
        if (this.shutdown.get()) {
            return;
        }
        if (this.inUseStateAggregator.isInUse()) {
            this.cancelIdleTimer();
        } else {
            this.rescheduleIdleTimer();
        }
        if (this.loadBalancer != null) {
            return;
        }
        log.logp(Level.FINE, "io.grpc.internal.ManagedChannelImpl", "exitIdleMode", "[{0}] Exiting idle mode", this.getLogId());
        LbHelperImpl lbHelperImpl = new LbHelperImpl(this.nameResolver);
        new LbHelperImpl(this.nameResolver).lb = this.loadBalancerFactory.zza(lbHelperImpl);
        this.loadBalancer = lbHelperImpl.lb;
        NameResolverListenerImpl nameResolverListenerImpl = new NameResolverListenerImpl(lbHelperImpl);
        try {
            this.nameResolver.start(nameResolverListenerImpl);
            return;
        }
        catch (Throwable throwable) {
            nameResolverListenerImpl.onError(zzcq.zzk(throwable));
            return;
        }
    }

    private final void cancelIdleTimer() {
        if (this.idleModeTimerFuture != null) {
            this.idleModeTimerFuture.cancel(false);
            this.idleModeTimer.cancelled = true;
            this.idleModeTimerFuture = null;
            this.idleModeTimer = null;
        }
    }

    private final void rescheduleIdleTimer() {
        if (this.idleTimeoutMillis == -1L) {
            return;
        }
        this.cancelIdleTimer();
        this.idleModeTimer = new IdleModeTimer();
        this.idleModeTimerFuture = this.scheduledExecutor.schedule(new LogExceptionRunnable(new Runnable(){

            @Override
            public void run() {
                ManagedChannelImpl.this.channelExecutor.executeLater(ManagedChannelImpl.this.idleModeTimer).drain();
            }
        }), this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    ManagedChannelImpl(AbstractManagedChannelImplBuilder<?> abstractManagedChannelImplBuilder, ClientTransportFactory clientTransportFactory, BackoffPolicy.Provider provider, ObjectPool<ScheduledExecutorService> objectPool, ObjectPool<? extends Executor> objectPool2, Supplier<Stopwatch> supplier, List<zzl> list) {
        this.target = (String)Preconditions.checkNotNull((Object)abstractManagedChannelImplBuilder.target, (Object)"target");
        this.nameResolverFactory = abstractManagedChannelImplBuilder.getNameResolverFactory();
        this.nameResolverParams = (zza)Preconditions.checkNotNull((Object)abstractManagedChannelImplBuilder.getNameResolverParams(), (Object)"nameResolverParams");
        this.nameResolver = ManagedChannelImpl.getNameResolver(this.target, this.nameResolverFactory, this.nameResolverParams);
        this.loadBalancerFactory = (zzav)Preconditions.checkNotNull((Object)abstractManagedChannelImplBuilder.loadBalancerFactory, (Object)"loadBalancerFactory");
        this.executorPool = (ObjectPool)Preconditions.checkNotNull(abstractManagedChannelImplBuilder.executorPool, (Object)"executorPool");
        this.oobExecutorPool = (ObjectPool)Preconditions.checkNotNull(objectPool2, (Object)"oobExecutorPool");
        this.executor = (Executor)Preconditions.checkNotNull((Object)this.executorPool.getObject(), (Object)"executor");
        this.delayedTransport = new DelayedClientTransport(this.executor, this.channelExecutor);
        this.delayedTransport.start(this.delayedTransportListener);
        this.backoffPolicyProvider = provider;
        this.transportFactory = new CallCredentialsApplyingTransportFactory(clientTransportFactory, this.executor);
        this.interceptorChannel = zzm.zza(new RealChannel(), list);
        this.timerServicePool = (ObjectPool)Preconditions.checkNotNull(objectPool, (Object)"timerServicePool");
        this.scheduledExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)objectPool.getObject(), (Object)"timerService");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(supplier, (Object)"stopwatchSupplier");
        if (abstractManagedChannelImplBuilder.idleTimeoutMillis == -1L) {
            this.idleTimeoutMillis = abstractManagedChannelImplBuilder.idleTimeoutMillis;
        } else {
            Preconditions.checkArgument((abstractManagedChannelImplBuilder.idleTimeoutMillis >= AbstractManagedChannelImplBuilder.IDLE_MODE_MIN_TIMEOUT_MILLIS ? 1 : 0) != 0, (String)"invalid idleTimeoutMillis %s", (long)abstractManagedChannelImplBuilder.idleTimeoutMillis);
            this.idleTimeoutMillis = abstractManagedChannelImplBuilder.idleTimeoutMillis;
        }
        this.decompressorRegistry = (zzah)Preconditions.checkNotNull((Object)abstractManagedChannelImplBuilder.decompressorRegistry, (Object)"decompressorRegistry");
        this.compressorRegistry = (zzv)Preconditions.checkNotNull((Object)abstractManagedChannelImplBuilder.compressorRegistry, (Object)"compressorRegistry");
        this.userAgent = abstractManagedChannelImplBuilder.userAgent;
        log.logp(Level.FINE, "io.grpc.internal.ManagedChannelImpl", "<init>", "[{0}] Created with target {1}", new Object[]{this.getLogId(), this.target});
    }

    static zzbu getNameResolver(String string, zzbv zzbv2, zza zza2) {
        String string2;
        Object object;
        URI uRI = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            stringBuilder.append(uRISyntaxException.getMessage());
        }
        if (uRI != null && (object = zzbv2.newNameResolver(uRI, zza2)) != null) {
            return object;
        }
        if (!URI_PATTERN.matcher(string).matches()) {
            try {
                String string3 = String.valueOf(string);
                uRI = new URI(zzbv2.getDefaultScheme(), "", string3.length() != 0 ? "/".concat(string3) : new String("/"), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException);
            }
            object = zzbv2.newNameResolver(uRI, zza2);
            if (object != null) {
                return object;
            }
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = string;
        if (stringBuilder.length() > 0) {
            object = String.valueOf(stringBuilder);
            string2 = new StringBuilder(3 + String.valueOf(object).length()).append(" (").append((String)object).append(")").toString();
        } else {
            string2 = "";
        }
        objectArray[1] = string2;
        throw new IllegalArgumentException(String.format("cannot find a NameResolver for %s%s", objectArray));
    }

    @Override
    public final ManagedChannelImpl shutdown() {
        log.logp(Level.FINE, "io.grpc.internal.ManagedChannelImpl", "shutdown", "[{0}] shutdown() called", this.getLogId());
        if (!this.shutdown.compareAndSet(false, true)) {
            return this;
        }
        this.delayedTransport.shutdown();
        this.channelExecutor.executeLater(new Runnable(){

            @Override
            public void run() {
                ManagedChannelImpl.this.cancelIdleTimer();
            }
        }).drain();
        log.logp(Level.FINE, "io.grpc.internal.ManagedChannelImpl", "shutdown", "[{0}] Shutting down", this.getLogId());
        return this;
    }

    @Override
    public final ManagedChannelImpl shutdownNow() {
        log.logp(Level.FINE, "io.grpc.internal.ManagedChannelImpl", "shutdownNow", "[{0}] shutdownNow() called", this.getLogId());
        ((zzbb)this).shutdown();
        this.delayedTransport.shutdownNow(SHUTDOWN_NOW_STATUS);
        this.channelExecutor.executeLater(new Runnable(){

            @Override
            public void run() {
                if (ManagedChannelImpl.this.shutdownNowed) {
                    return;
                }
                ManagedChannelImpl.this.shutdownNowed = true;
                ManagedChannelImpl.this.maybeShutdownNowSubchannels();
            }
        }).drain();
        return this;
    }

    @Override
    public final boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public final boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.terminatedLatch.await(l, timeUnit);
    }

    @Override
    public final boolean isTerminated() {
        return this.terminated;
    }

    public final <ReqT, RespT> zzj<ReqT, RespT> newCall(zzbp<ReqT, RespT> zzbp2, zzh zzh2) {
        return this.interceptorChannel.newCall(zzbp2, zzh2);
    }

    @Override
    public final String authority() {
        return this.interceptorChannel.authority();
    }

    private final void maybeTerminateChannel() {
        if (this.terminated) {
            return;
        }
        if (this.shutdown.get() && this.subchannels.isEmpty() && this.oobChannels.isEmpty()) {
            log.logp(Level.FINE, "io.grpc.internal.ManagedChannelImpl", "maybeTerminateChannel", "[{0}] Terminated", this.getLogId());
            this.terminated = true;
            this.terminatedLatch.countDown();
            this.executorPool.returnObject(this.executor);
            this.scheduledExecutor = this.timerServicePool.returnObject(this.scheduledExecutor);
            this.transportFactory.close();
        }
    }

    @Override
    public final LogId getLogId() {
        return this.logId;
    }

    final class SubchannelImplImpl
    extends SubchannelImpl {
        InternalSubchannel subchannel;
        final Object shutdownLock = new Object();
        final zza attrs;
        boolean shutdownRequested;
        ScheduledFuture<?> delayedShutdownTask;

        SubchannelImplImpl(zza zza2) {
            this.attrs = (zza)Preconditions.checkNotNull((Object)zza2, (Object)"attrs");
        }

        @Override
        final ClientTransport obtainActiveTransport() {
            return this.subchannel.obtainActiveTransport();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void shutdown() {
            Object object = this.shutdownLock;
            synchronized (object) {
                block6: {
                    if (this.shutdownRequested) {
                        if (ManagedChannelImpl.this.terminating && this.delayedShutdownTask != null) {
                            this.delayedShutdownTask.cancel(false);
                            this.delayedShutdownTask = null;
                            break block6;
                        } else {
                            return;
                        }
                    }
                    this.shutdownRequested = true;
                }
                ScheduledExecutorService scheduledExecutorService = ManagedChannelImpl.this.scheduledExecutor;
                if (!ManagedChannelImpl.this.terminating && scheduledExecutorService != null) {
                    this.delayedShutdownTask = scheduledExecutorService.schedule(new LogExceptionRunnable(new Runnable(){

                        @Override
                        public void run() {
                            SubchannelImplImpl.this.subchannel.shutdown();
                        }
                    }), 5L, TimeUnit.SECONDS);
                    return;
                }
            }
            this.subchannel.shutdown();
        }

        @Override
        public final void requestConnection() {
            this.subchannel.obtainActiveTransport();
        }

        @Override
        public final zzak getAddresses() {
            return this.subchannel.getAddressGroup();
        }

        @Override
        public final zza getAttributes() {
            return this.attrs;
        }
    }

    class NameResolverListenerImpl
    implements zzbw {
        final zzau balancer;
        final zzaw helper;

        NameResolverListenerImpl(LbHelperImpl lbHelperImpl) {
            this.balancer = lbHelperImpl.lb;
            this.helper = lbHelperImpl;
        }

        @Deprecated
        public void onUpdate(List<zzcd> list, zza zza2) {
            ArrayList<zzak> arrayList = new ArrayList<zzak>(list.size());
            for (zzcd zzcd2 : list) {
                arrayList.add(zzcd2.zzcyp());
            }
            this.onAddresses(arrayList, zza2);
        }

        @Override
        public void onAddresses(final List<zzak> list, final zza zza2) {
            if (list.isEmpty()) {
                this.onError(zzcq.zzpcj.zztw("NameResolver returned an empty list"));
                return;
            }
            log.logp(Level.FINE, "io.grpc.internal.ManagedChannelImpl$NameResolverListenerImpl", "onAddresses", "[{0}] resolved address: {1}, config={2}", new Object[]{ManagedChannelImpl.this.getLogId(), list, zza2});
            this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    if (ManagedChannelImpl.this.terminated) {
                        return;
                    }
                    try {
                        NameResolverListenerImpl.this.balancer.zza(list, zza2);
                        return;
                    }
                    catch (Throwable throwable) {
                        String string = String.valueOf(ManagedChannelImpl.this.getLogId());
                        log.logp(Level.WARNING, "io.grpc.internal.ManagedChannelImpl$NameResolverListenerImpl$1", "run", new StringBuilder(41 + String.valueOf(string).length()).append("[").append(string).append("] Unexpected exception from LoadBalancer").toString(), throwable);
                        string = String.valueOf(throwable);
                        NameResolverListenerImpl.this.balancer.zzh(zzcq.zzpci.zzl(throwable).zztw(new StringBuilder(39 + String.valueOf(string).length()).append("Thrown from handleResolvedAddresses(): ").append(string).toString()));
                        return;
                    }
                }
            });
        }

        @Override
        public void onError(final zzcq zzcq2) {
            Preconditions.checkArgument((!zzcq2.zzcyt() ? 1 : 0) != 0, (Object)"the error status must not be OK");
            log.logp(Level.WARNING, "io.grpc.internal.ManagedChannelImpl$NameResolverListenerImpl", "onError", "[{0}] Failed to resolve name. status={1}", new Object[]{ManagedChannelImpl.this.getLogId(), zzcq2});
            ManagedChannelImpl.this.channelExecutor.executeLater(new Runnable(){

                @Override
                public void run() {
                    if (ManagedChannelImpl.this.terminated) {
                        return;
                    }
                    NameResolverListenerImpl.this.balancer.zzh(zzcq2);
                }
            }).drain();
        }
    }

    class LbHelperImpl
    extends zzaw {
        zzau lb;
        final zzbu nr;

        LbHelperImpl(zzbu zzbu2) {
            this.nr = (zzbu)Preconditions.checkNotNull((Object)zzbu2, (Object)"NameResolver");
        }

        @Override
        public SubchannelImpl createSubchannel(zzak zzak2, zza zza2) {
            InternalSubchannel internalSubchannel;
            Preconditions.checkNotNull((Object)zzak2, (Object)"addressGroup");
            Preconditions.checkNotNull((Object)zza2, (Object)"attrs");
            ScheduledExecutorService scheduledExecutorService = ManagedChannelImpl.this.scheduledExecutor;
            Preconditions.checkState((scheduledExecutorService != null ? 1 : 0) != 0, (Object)"scheduledExecutor is already cleared. Looks like you are calling this method after you've already shut down");
            final SubchannelImplImpl subchannelImplImpl = new SubchannelImplImpl(zza2);
            subchannelImplImpl.subchannel = internalSubchannel = new InternalSubchannel(zzak2, ((zzi)ManagedChannelImpl.this).authority(), ManagedChannelImpl.this.userAgent, ManagedChannelImpl.this.backoffPolicyProvider, ManagedChannelImpl.this.transportFactory, scheduledExecutorService, (Supplier<Stopwatch>)ManagedChannelImpl.this.stopwatchSupplier, ManagedChannelImpl.this.channelExecutor, new InternalSubchannel.Callback(){

                @Override
                void onTerminated(InternalSubchannel internalSubchannel) {
                    ManagedChannelImpl.this.subchannels.remove(internalSubchannel);
                    ManagedChannelImpl.this.maybeTerminateChannel();
                }

                @Override
                void onStateChange(InternalSubchannel internalSubchannel, zzx zzx2) {
                    if (zzx2.getState() == zzw.zzoyy || zzx2.getState() == zzw.zzoyz) {
                        LbHelperImpl.this.nr.refresh();
                    }
                    LbHelperImpl.this.lb.zza(subchannelImplImpl, zzx2);
                }

                @Override
                void onInUse(InternalSubchannel internalSubchannel) {
                    ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(internalSubchannel, true);
                }

                @Override
                void onNotInUse(InternalSubchannel internalSubchannel) {
                    ManagedChannelImpl.this.inUseStateAggregator.updateObjectInUse(internalSubchannel, false);
                }
            });
            log.logp(Level.FINE, "io.grpc.internal.ManagedChannelImpl$LbHelperImpl", "createSubchannel", "[{0}] {1} created for {2}", new Object[]{ManagedChannelImpl.this.getLogId(), internalSubchannel.getLogId(), zzak2});
            ((zzaw)this).runSerialized(new Runnable(){

                @Override
                public void run() {
                    if (ManagedChannelImpl.this.terminating) {
                        internalSubchannel.shutdown();
                    }
                    if (!ManagedChannelImpl.this.terminated) {
                        ManagedChannelImpl.this.subchannels.add(internalSubchannel);
                    }
                }
            });
            return subchannelImplImpl;
        }

        @Override
        public void updateSubchannelAddresses(zzaz zzaz2, zzak zzak2) {
            Preconditions.checkArgument((boolean)(zzaz2 instanceof SubchannelImplImpl), (Object)"subchannel must have been returned from createSubchannel");
            ((SubchannelImplImpl)zzaz2).subchannel.updateAddresses(zzak2);
        }

        @Override
        public zzbb createOobChannel(zzak zzak2, String string) {
            ScheduledExecutorService scheduledExecutorService = ManagedChannelImpl.this.scheduledExecutor;
            Preconditions.checkState((scheduledExecutorService != null ? 1 : 0) != 0, (Object)"scheduledExecutor is already cleared. Looks like you are calling this method after you've already shut down");
            final OobChannel oobChannel = new OobChannel(string, ManagedChannelImpl.this.oobExecutorPool, scheduledExecutorService, ManagedChannelImpl.this.channelExecutor);
            final InternalSubchannel internalSubchannel = new InternalSubchannel(zzak2, string, ManagedChannelImpl.this.userAgent, ManagedChannelImpl.this.backoffPolicyProvider, ManagedChannelImpl.this.transportFactory, scheduledExecutorService, (Supplier<Stopwatch>)ManagedChannelImpl.this.stopwatchSupplier, ManagedChannelImpl.this.channelExecutor, new InternalSubchannel.Callback(){

                @Override
                void onTerminated(InternalSubchannel internalSubchannel) {
                    ManagedChannelImpl.this.oobChannels.remove(internalSubchannel);
                    oobChannel.handleSubchannelTerminated();
                    ManagedChannelImpl.this.maybeTerminateChannel();
                }

                @Override
                void onStateChange(InternalSubchannel internalSubchannel, zzx zzx2) {
                    oobChannel.handleSubchannelStateChange(zzx2);
                }
            });
            oobChannel.setSubchannel(internalSubchannel);
            ((zzaw)this).runSerialized(new Runnable(){

                @Override
                public void run() {
                    if (ManagedChannelImpl.this.terminating) {
                        ((zzbb)oobChannel).shutdown();
                    }
                    if (!ManagedChannelImpl.this.terminated) {
                        ManagedChannelImpl.this.oobChannels.add(internalSubchannel);
                    }
                }
            });
            return oobChannel;
        }

        @Override
        public void updateOobChannelAddresses(zzbb zzbb2, zzak zzak2) {
            Preconditions.checkArgument((boolean)(zzbb2 instanceof OobChannel), (Object)"channel must have been returned from createOobChannel");
            ((OobChannel)zzbb2).updateAddresses(zzak2);
        }

        @Override
        public String getAuthority() {
            return ((zzi)ManagedChannelImpl.this).authority();
        }

        @Override
        public zzbv getNameResolverFactory() {
            return ManagedChannelImpl.this.nameResolverFactory;
        }

        @Override
        public void runSerialized(Runnable runnable) {
            ManagedChannelImpl.this.channelExecutor.executeLater(runnable).drain();
        }

        @Override
        public void updatePicker(final zzba zzba2) {
            ((zzaw)this).runSerialized(new Runnable(){

                @Override
                public void run() {
                    ManagedChannelImpl.this.subchannelPicker = zzba2;
                    ManagedChannelImpl.this.delayedTransport.reprocess(zzba2);
                }
            });
        }
    }

    class RealChannel
    extends zzi {
        private RealChannel() {
        }

        public <ReqT, RespT> zzj<ReqT, RespT> newCall(zzbp<ReqT, RespT> zzbp2, zzh zzh2) {
            Executor executor = zzh2.zzcfp();
            if (executor == null) {
                executor = ManagedChannelImpl.this.executor;
            }
            return new ClientCallImpl<ReqT, RespT>(zzbp2, executor, zzh2, ManagedChannelImpl.this.transportProvider, ManagedChannelImpl.this.scheduledExecutor).setDecompressorRegistry(ManagedChannelImpl.this.decompressorRegistry).setCompressorRegistry(ManagedChannelImpl.this.compressorRegistry);
        }

        @Override
        public String authority() {
            return (String)Preconditions.checkNotNull((Object)ManagedChannelImpl.this.nameResolver.getServiceAuthority(), (Object)"authority");
        }
    }

    class IdleModeTimer
    implements Runnable {
        boolean cancelled;

        private IdleModeTimer() {
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            log.logp(Level.FINE, "io.grpc.internal.ManagedChannelImpl$IdleModeTimer", "run", "[{0}] Entering idle mode", ManagedChannelImpl.this.getLogId());
            ManagedChannelImpl.this.nameResolver.shutdown();
            ManagedChannelImpl.this.nameResolver = ManagedChannelImpl.getNameResolver(ManagedChannelImpl.this.target, ManagedChannelImpl.this.nameResolverFactory, ManagedChannelImpl.this.nameResolverParams);
            ManagedChannelImpl.this.loadBalancer.shutdown();
            ManagedChannelImpl.this.loadBalancer = null;
            ManagedChannelImpl.this.subchannelPicker = null;
        }
    }
}

