/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.internal.AbstractReadableBuffer;
import io.grpc.internal.CompositeReadableBuffer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ReadableBuffers;
import io.grpc.internal.StatsTraceContext;
import io.grpc.zzag;
import io.grpc.zzcq;
import io.grpc.zzt;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MessageDeframer
implements Closeable {
    private static final int HEADER_LENGTH = 5;
    private static final int COMPRESSED_FLAG_MASK = 1;
    private static final int RESERVED_MASK = 254;
    private final Listener listener;
    private int maxInboundMessageSize;
    private final StatsTraceContext statsTraceCtx;
    private final String debugString;
    private zzag decompressor;
    private State state = State.HEADER;
    private int requiredLength = 5;
    private boolean compressedFlag;
    private boolean endOfStream;
    private CompositeReadableBuffer nextFrame;
    private CompositeReadableBuffer unprocessed = new CompositeReadableBuffer();
    private long pendingDeliveries;
    private boolean deliveryStalled = true;
    private boolean inDelivery = false;

    public MessageDeframer(Listener listener, zzag zzag2, int n, StatsTraceContext statsTraceContext, String string) {
        this.listener = (Listener)Preconditions.checkNotNull((Object)listener, (Object)"sink");
        this.decompressor = (zzag)Preconditions.checkNotNull((Object)zzag2, (Object)"decompressor");
        this.maxInboundMessageSize = n;
        this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceContext, (Object)"statsTraceCtx");
        this.debugString = string;
    }

    void setMaxInboundMessageSize(int n) {
        this.maxInboundMessageSize = n;
    }

    public void setDecompressor(zzag zzag2) {
        this.decompressor = (zzag)Preconditions.checkNotNull((Object)zzag2, (Object)"Can't pass an empty decompressor");
    }

    public void request(int n) {
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"numMessages must be > 0");
        if (this.isClosed()) {
            return;
        }
        this.pendingDeliveries += (long)n;
        this.deliver();
    }

    public void deframe(ReadableBuffer readableBuffer, boolean bl) {
        Preconditions.checkNotNull((Object)readableBuffer, (Object)"data");
        boolean bl2 = true;
        try {
            this.checkNotClosed();
            Preconditions.checkState((!this.endOfStream ? 1 : 0) != 0, (Object)"Past end of stream");
            this.unprocessed.addBuffer(readableBuffer);
            bl2 = false;
            this.endOfStream = bl;
            this.deliver();
            return;
        }
        catch (Throwable throwable) {
            if (bl2) {
                readableBuffer.close();
            }
            throw throwable;
        }
    }

    public boolean isStalled() {
        return this.deliveryStalled;
    }

    @Override
    public void close() {
        try {
            if (this.unprocessed != null) {
                ((AbstractReadableBuffer)this.unprocessed).close();
            }
            if (this.nextFrame != null) {
                ((AbstractReadableBuffer)this.nextFrame).close();
            }
            return;
        }
        finally {
            this.unprocessed = null;
            this.nextFrame = null;
        }
    }

    public boolean isClosed() {
        return this.unprocessed == null;
    }

    private void checkNotClosed() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"MessageDeframer is already closed");
    }

    private void deliver() {
        if (this.inDelivery) {
            return;
        }
        this.inDelivery = true;
        try {
            boolean bl;
            block8: while (this.pendingDeliveries > 0L && this.readRequiredBytes()) {
                switch (this.state) {
                    case HEADER: {
                        this.processHeader();
                        continue block8;
                    }
                    case BODY: {
                        this.processBody();
                        --this.pendingDeliveries;
                        continue block8;
                    }
                }
                String string = String.valueOf((Object)this.state);
                throw new AssertionError((Object)new StringBuilder(15 + String.valueOf(string).length()).append("Invalid state: ").append(string).toString());
            }
            boolean bl2 = bl = this.unprocessed.readableBytes() == 0;
            if (this.endOfStream && bl) {
                if (!(this.nextFrame != null && this.nextFrame.readableBytes() > 0)) {
                    this.listener.endOfStream();
                    this.deliveryStalled = false;
                    return;
                }
                throw zzcq.zzpci.zztw(String.valueOf(this.debugString).concat(": Encountered end-of-stream mid-frame")).zzcyu();
            }
            boolean bl3 = this.deliveryStalled;
            this.deliveryStalled = bl;
            if (bl && !bl3) {
                this.listener.deliveryStalled();
            }
            return;
        }
        finally {
            this.inDelivery = false;
        }
    }

    private boolean readRequiredBytes() {
        int n = 0;
        try {
            int n2;
            if (this.nextFrame == null) {
                this.nextFrame = new CompositeReadableBuffer();
            }
            while ((n2 = this.requiredLength - this.nextFrame.readableBytes()) > 0) {
                if (this.unprocessed.readableBytes() == 0) {
                    return false;
                }
                int n3 = Math.min(n2, this.unprocessed.readableBytes());
                n += n3;
                this.nextFrame.addBuffer((CompositeReadableBuffer)this.unprocessed.readBytes(n3));
            }
            return true;
        }
        finally {
            if (n > 0) {
                this.listener.bytesRead(n);
                if (this.state == State.BODY) {
                    this.statsTraceCtx.inboundWireSize(n);
                }
            }
        }
    }

    private void processHeader() {
        int n = this.nextFrame.readUnsignedByte();
        if ((n & 0xFE) != 0) {
            throw zzcq.zzpci.zztw(String.valueOf(this.debugString).concat(": Frame header malformed: reserved bits not zero")).zzcyu();
        }
        this.compressedFlag = (n & 1) != 0;
        this.requiredLength = this.nextFrame.readInt();
        if (this.requiredLength < 0 || this.requiredLength > this.maxInboundMessageSize) {
            throw zzcq.zzpcd.zztw(String.format("%s: Frame size %d exceeds maximum: %d. ", this.debugString, this.requiredLength, this.maxInboundMessageSize)).zzcyu();
        }
        this.statsTraceCtx.inboundMessage();
        this.state = State.BODY;
    }

    private void processBody() {
        InputStream inputStream = this.compressedFlag ? this.getCompressedBody() : this.getUncompressedBody();
        this.nextFrame = null;
        this.listener.messageRead(inputStream);
        this.state = State.HEADER;
        this.requiredLength = 5;
    }

    private InputStream getUncompressedBody() {
        this.statsTraceCtx.inboundUncompressedSize(this.nextFrame.readableBytes());
        return ReadableBuffers.openStream(this.nextFrame, true);
    }

    private InputStream getCompressedBody() {
        if (this.decompressor == zzt.zzoyt) {
            throw zzcq.zzpci.zztw(String.valueOf(this.debugString).concat(": Can't decode compressed frame as compression not configured.")).zzcyu();
        }
        try {
            InputStream inputStream = this.decompressor.zzm(ReadableBuffers.openStream(this.nextFrame, true));
            return new SizeEnforcingInputStream(inputStream, this.maxInboundMessageSize, this.statsTraceCtx, this.debugString);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static final class SizeEnforcingInputStream
    extends FilterInputStream {
        private final int maxMessageSize;
        private final StatsTraceContext statsTraceCtx;
        private final String debugString;
        private long maxCount;
        private long count;
        private long mark = -1L;

        SizeEnforcingInputStream(InputStream inputStream, int n, StatsTraceContext statsTraceContext, String string) {
            super(inputStream);
            this.maxMessageSize = n;
            this.statsTraceCtx = statsTraceContext;
            this.debugString = string;
        }

        @Override
        public final int read() throws IOException {
            int n = this.in.read();
            if (n != -1) {
                ++this.count;
            }
            this.verifySize();
            this.reportCount();
            return n;
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 != -1) {
                this.count += (long)n3;
            }
            this.verifySize();
            this.reportCount();
            return n3;
        }

        @Override
        public final long skip(long l) throws IOException {
            long l2 = this.in.skip(l);
            this.count += l2;
            this.verifySize();
            this.reportCount();
            return l2;
        }

        @Override
        public final synchronized void mark(int n) {
            this.in.mark(n);
            this.mark = this.count;
        }

        @Override
        public final synchronized void reset() throws IOException {
            if (!this.in.markSupported()) {
                throw new IOException("Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException("Mark not set");
            }
            this.in.reset();
            this.count = this.mark;
        }

        private final void reportCount() {
            if (this.count > this.maxCount) {
                this.statsTraceCtx.inboundUncompressedSize(this.count - this.maxCount);
                this.maxCount = this.count;
            }
        }

        private final void verifySize() {
            if (this.count > (long)this.maxMessageSize) {
                throw zzcq.zzpcd.zztw(String.format("%s: Compressed frame exceeds maximum frame size: %d. Bytes read: %d. ", this.debugString, this.maxMessageSize, this.count)).zzcyu();
            }
        }
    }

    static enum State {
        HEADER,
        BODY;


        private State() {
        }
    }

    public static interface Listener {
        public void bytesRead(int var1);

        public void messageRead(InputStream var1);

        public void deliveryStalled();

        public void endOfStream();
    }
}

