/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdgi;
import com.google.common.base.Preconditions;
import io.grpc.internal.ContextRunnable;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalHandlerRegistry;
import io.grpc.internal.InternalServer;
import io.grpc.internal.LogId;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SerializeReentrantCallsDirectExecutor;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.WithLogId;
import io.grpc.zza;
import io.grpc.zzab;
import io.grpc.zzag;
import io.grpc.zzah;
import io.grpc.zzap;
import io.grpc.zzbe;
import io.grpc.zzch;
import io.grpc.zzcl;
import io.grpc.zzcm;
import io.grpc.zzcp;
import io.grpc.zzcq;
import io.grpc.zzv;
import io.grpc.zzy;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ServerImpl
extends zzch
implements WithLogId {
    private static final ServerStreamListener NOOP_LISTENER = new NoopListener();
    private final LogId logId = LogId.allocate(this.getClass().getName());
    private final ObjectPool<? extends Executor> executorPool;
    private Executor executor;
    private final InternalHandlerRegistry registry;
    private final zzap fallbackRegistry;
    private final List<zzcp> transportFilters;
    private boolean started;
    private boolean shutdown;
    private zzcq shutdownNowStatus;
    private boolean serverShutdownCallbackInvoked;
    private boolean terminated;
    private final InternalServer transportServer;
    private final Object lock = new Object();
    private boolean transportServerTerminated;
    private final Collection<ServerTransport> transports = new HashSet<ServerTransport>();
    private final ObjectPool<ScheduledExecutorService> timeoutServicePool;
    private ScheduledExecutorService timeoutService;
    private final zzy rootContext;
    private final zzah decompressorRegistry;
    private final zzv compressorRegistry;

    ServerImpl(ObjectPool<? extends Executor> objectPool, ObjectPool<ScheduledExecutorService> objectPool2, InternalHandlerRegistry internalHandlerRegistry, zzap zzap2, InternalServer internalServer, zzy zzy2, zzah zzah2, zzv zzv2, List<zzcp> list) {
        this.executorPool = (ObjectPool)Preconditions.checkNotNull(objectPool, (Object)"executorPool");
        this.timeoutServicePool = (ObjectPool)Preconditions.checkNotNull(objectPool2, (Object)"timeoutServicePool");
        this.registry = (InternalHandlerRegistry)Preconditions.checkNotNull((Object)internalHandlerRegistry, (Object)"registry");
        this.fallbackRegistry = (zzap)Preconditions.checkNotNull((Object)zzap2, (Object)"fallbackRegistry");
        this.transportServer = (InternalServer)Preconditions.checkNotNull((Object)internalServer, (Object)"transportServer");
        this.rootContext = ((zzy)Preconditions.checkNotNull((Object)zzy2, (Object)"rootContext")).zzcxo();
        this.decompressorRegistry = zzah2;
        this.compressorRegistry = zzv2;
        this.transportFilters = Collections.unmodifiableList(new ArrayList<zzcp>(list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ServerImpl start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"Already started");
            Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"Shutting down");
            this.transportServer.start(new ServerListenerImpl());
            this.timeoutService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)this.timeoutServicePool.getObject(), (Object)"timeoutService");
            this.executor = (Executor)Preconditions.checkNotNull((Object)this.executorPool.getObject(), (Object)"executor");
            this.started = true;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getPort() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((boolean)this.started, (Object)"Not started");
            Preconditions.checkState((!this.terminated ? 1 : 0) != 0, (Object)"Already terminated");
            return this.transportServer.getPort();
        }
    }

    @Override
    public final List<zzcm> getServices() {
        List<zzcm> list = this.fallbackRegistry.getServices();
        if (list.isEmpty()) {
            return this.registry.getServices();
        }
        List<zzcm> list2 = this.registry.getServices();
        int n = list2.size() + list.size();
        ArrayList<zzcm> arrayList = new ArrayList<zzcm>(n);
        arrayList.addAll(list2);
        arrayList.addAll(list);
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public final List<zzcm> getImmutableServices() {
        return this.registry.getServices();
    }

    @Override
    public final List<zzcm> getMutableServices() {
        return Collections.unmodifiableList(this.fallbackRegistry.getServices());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ServerImpl shutdown() {
        boolean bl;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return this;
            }
            this.shutdown = true;
            bl = this.started;
            if (!bl) {
                this.transportServerTerminated = true;
                this.checkForTermination();
            }
        }
        if (bl) {
            this.transportServer.shutdown();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ServerImpl shutdownNow() {
        boolean bl;
        ArrayList<ServerTransport> arrayList;
        ((zzch)this).shutdown();
        zzcq zzcq2 = zzcq.zzpcj.zztw("Server shutdownNow invoked");
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownNowStatus != null) {
                return this;
            }
            this.shutdownNowStatus = zzcq2;
            arrayList = new ArrayList<ServerTransport>(this.transports);
            bl = this.serverShutdownCallbackInvoked;
        }
        if (bl) {
            ArrayList<ServerTransport> arrayList2 = arrayList;
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                ServerTransport serverTransport = arrayList2.get(i);
                serverTransport.shutdownNow(zzcq2);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isShutdown() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            long l2 = timeUnit.toNanos(l);
            long l3 = System.nanoTime() + l2;
            while (!this.terminated && (l2 = l3 - System.nanoTime()) > 0L) {
                TimeUnit.NANOSECONDS.timedWait(this.lock, l2);
            }
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void awaitTermination() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.terminated) {
                this.lock.wait();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isTerminated() {
        Object object = this.lock;
        synchronized (object) {
            return this.terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void transportClosed(ServerTransport serverTransport) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.transports.remove(serverTransport)) {
                throw new AssertionError((Object)"Transport already removed");
            }
            this.checkForTermination();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkForTermination() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown && this.transports.isEmpty() && this.transportServerTerminated) {
                if (this.terminated) {
                    throw new AssertionError((Object)"Server already terminated");
                }
                this.terminated = true;
                if (this.timeoutService != null) {
                    this.timeoutService = this.timeoutServicePool.returnObject(this.timeoutService);
                }
                if (this.executor != null) {
                    this.executor = this.executorPool.returnObject(this.executor);
                }
                this.lock.notifyAll();
            }
            return;
        }
    }

    @Override
    public final LogId getLogId() {
        return this.logId;
    }

    static /* synthetic */ zzv access$1800(ServerImpl serverImpl) {
        return serverImpl.compressorRegistry;
    }

    static class ContextCloser
    implements Runnable {
        private final zzy.zza context;
        private final Throwable cause;

        ContextCloser(zzy.zza zza2, Throwable throwable) {
            this.context = zza2;
            this.cause = throwable;
        }

        @Override
        public void run() {
            this.context.zzj(this.cause);
        }
    }

    static class JumpToApplicationThreadServerStreamListener
    implements ServerStreamListener {
        private final Executor callExecutor;
        private final Executor cancelExecutor;
        private final zzy.zza context;
        private final ServerStream stream;
        private ServerStreamListener listener;

        public JumpToApplicationThreadServerStreamListener(Executor executor, Executor executor2, ServerStream serverStream, zzy.zza zza2) {
            this.callExecutor = executor;
            this.cancelExecutor = executor2;
            this.stream = serverStream;
            this.context = zza2;
        }

        private ServerStreamListener getListener() {
            if (this.listener == null) {
                throw new IllegalStateException("listener unset");
            }
            return this.listener;
        }

        void setListener(ServerStreamListener serverStreamListener) {
            Preconditions.checkNotNull((Object)serverStreamListener, (Object)"listener must not be null");
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Listener already set");
            this.listener = serverStreamListener;
        }

        private void internalClose(zzcq zzcq2, zzbe zzbe2) {
            this.stream.close(zzcq2, zzbe2);
        }

        @Override
        public void messageRead(final InputStream inputStream) {
            this.callExecutor.execute(new ContextRunnable(this.context){

                @Override
                public void runInContext() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().messageRead(inputStream);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(zzcq.zzk(runtimeException), new zzbe());
                        throw runtimeException;
                    }
                    catch (Error error) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(zzcq.zzk(error), new zzbe());
                        throw error;
                    }
                }
            });
        }

        @Override
        public void halfClosed() {
            this.callExecutor.execute(new ContextRunnable(this.context){

                @Override
                public void runInContext() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().halfClosed();
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(zzcq.zzk(runtimeException), new zzbe());
                        throw runtimeException;
                    }
                    catch (Error error) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(zzcq.zzk(error), new zzbe());
                        throw error;
                    }
                }
            });
        }

        @Override
        public void closed(final zzcq zzcq2) {
            if (!zzcq2.zzcyt()) {
                this.cancelExecutor.execute(new ContextCloser(this.context, zzcq2.getCause()));
            }
            this.callExecutor.execute(new ContextRunnable(this.context){

                @Override
                public void runInContext() {
                    JumpToApplicationThreadServerStreamListener.this.getListener().closed(zzcq2);
                }
            });
        }

        @Override
        public void onReady() {
            this.callExecutor.execute(new ContextRunnable(this.context){

                @Override
                public void runInContext() {
                    try {
                        JumpToApplicationThreadServerStreamListener.this.getListener().onReady();
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(zzcq.zzk(runtimeException), new zzbe());
                        throw runtimeException;
                    }
                    catch (Error error) {
                        JumpToApplicationThreadServerStreamListener.this.internalClose(zzcq.zzk(error), new zzbe());
                        throw error;
                    }
                }
            });
        }
    }

    static class NoopListener
    implements ServerStreamListener {
        private NoopListener() {
        }

        @Override
        public void messageRead(InputStream inputStream) {
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public void halfClosed() {
        }

        @Override
        public void closed(zzcq zzcq2) {
        }

        @Override
        public void onReady() {
        }
    }

    class ServerTransportListenerImpl
    implements ServerTransportListener {
        private final ServerTransport transport;
        private zza attributes;

        public ServerTransportListenerImpl(ServerTransport serverTransport) {
            this.transport = serverTransport;
        }

        @Override
        public zza transportReady(zza zza2) {
            for (zzcp zzcp2 : ServerImpl.this.transportFilters) {
                zza2 = (zza)Preconditions.checkNotNull((Object)zza2, (String)"Filter %s returned null", (Object)zzcp2);
            }
            this.attributes = zza2;
            return zza2;
        }

        @Override
        public void transportTerminated() {
            Iterator iterator = ServerImpl.this.transportFilters.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            ServerImpl.this.transportClosed(this.transport);
        }

        @Override
        public void streamCreated(final ServerStream serverStream, final String string, zzbe zzbe2) {
            Object object;
            Object object2;
            if (zzbe2.zza(GrpcUtil.MESSAGE_ENCODING_KEY)) {
                object2 = zzbe2.zzb(GrpcUtil.MESSAGE_ENCODING_KEY);
                object = ServerImpl.this.decompressorRegistry.zzts((String)object2);
                if (object == null) {
                    serverStream.close(zzcq.zzpch.zztw(String.format("Can't find decompressor for %s", object2)), new zzbe());
                    return;
                }
                serverStream.setDecompressor((zzag)object);
            }
            object2 = (StatsTraceContext)Preconditions.checkNotNull((Object)serverStream.statsTraceContext(), (Object)"statsTraceCtx not present from stream");
            object = this.createContext(serverStream, zzbe2, (StatsTraceContext)object2);
            Executor executor = ServerImpl.this.executor == zzdgi.zzbjt() ? new SerializeReentrantCallsDirectExecutor() : new SerializingExecutor(ServerImpl.this.executor);
            JumpToApplicationThreadServerStreamListener jumpToApplicationThreadServerStreamListener = new JumpToApplicationThreadServerStreamListener(executor, ServerImpl.this.executor, serverStream, (zzy.zza)object);
            serverStream.setListener(jumpToApplicationThreadServerStreamListener);
            executor.execute(new ContextRunnable((zzy)object, (zzy.zza)object, zzbe2, (StatsTraceContext)object2, jumpToApplicationThreadServerStreamListener){
                final /* synthetic */ zzy.zza val$context;
                final /* synthetic */ zzbe val$headers;
                final /* synthetic */ StatsTraceContext val$statsTraceCtx;
                final /* synthetic */ JumpToApplicationThreadServerStreamListener val$jumpListener;
                {
                    this.val$context = zza2;
                    this.val$headers = zzbe2;
                    this.val$statsTraceCtx = statsTraceContext;
                    this.val$jumpListener = jumpToApplicationThreadServerStreamListener;
                    super(zzy2);
                }

                @Override
                public void runInContext() {
                    ServerStreamListener serverStreamListener = NOOP_LISTENER;
                    try {
                        zzcl<?, ?> zzcl2 = ServerImpl.this.registry.lookupMethod(string);
                        if (zzcl2 == null) {
                            zzcl2 = ServerImpl.this.fallbackRegistry.lookupMethod(string, serverStream.getAuthority());
                        }
                        if (zzcl2 == null) {
                            String string2 = String.valueOf(string);
                            zzcq zzcq2 = zzcq.zzpch.zztw(string2.length() != 0 ? "Method not found: ".concat(string2) : new String("Method not found: "));
                            serverStream.close(zzcq2, new zzbe());
                            this.val$context.zzj(null);
                            return;
                        }
                        serverStreamListener = ServerTransportListenerImpl.this.startCall(serverStream, string, zzcl2, this.val$headers, this.val$context, this.val$statsTraceCtx);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        serverStream.close(zzcq.zzk(runtimeException), new zzbe());
                        this.val$context.zzj(null);
                        throw runtimeException;
                    }
                    catch (Error error) {
                        serverStream.close(zzcq.zzk(error), new zzbe());
                        this.val$context.zzj(null);
                        throw error;
                    }
                    finally {
                        this.val$jumpListener.setListener(serverStreamListener);
                    }
                }
            });
        }

        private zzy.zza createContext(final ServerStream serverStream, zzbe zzbe2, StatsTraceContext statsTraceContext) {
            Long l = zzbe2.zzb(GrpcUtil.TIMEOUT_KEY);
            zzy zzy2 = statsTraceContext.serverFilterContext(ServerImpl.this.rootContext);
            if (l == null) {
                return zzy2.zzcxn();
            }
            zzy.zza zza2 = zzy2.zza(l, TimeUnit.NANOSECONDS, ServerImpl.this.timeoutService);
            zza2.zza(new zzy.zzb(this){

                @Override
                public void cancelled(zzy zzy2) {
                    zzcq zzcq2 = zzab.zzd(zzy2);
                    if (zzcq.zzpby.zzcys().equals((Object)zzcq2.zzcys())) {
                        serverStream.cancel(zzcq2);
                    }
                }
            }, zzdgi.zzbjt());
            return zza2;
        }

        private <ReqT, RespT> ServerStreamListener startCall(ServerStream serverStream, String string, zzcl<ReqT, RespT> zzcl2, zzbe zzbe2, zzy.zza zza2, StatsTraceContext statsTraceContext) {
            throw new NoSuchMethodError();
        }
    }

    class ServerListenerImpl
    implements ServerListener {
        private ServerListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServerTransportListener transportCreated(ServerTransport serverTransport) {
            Object object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.transports.add(serverTransport);
            }
            return new ServerTransportListenerImpl(serverTransport);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serverShutdown() {
            zzcq zzcq2;
            ArrayList arrayList;
            Object object = ServerImpl.this.lock;
            synchronized (object) {
                arrayList = new ArrayList(ServerImpl.this.transports);
                zzcq2 = ServerImpl.this.shutdownNowStatus;
                ServerImpl.this.serverShutdownCallbackInvoked = true;
            }
            ArrayList arrayList2 = arrayList;
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList2.get(i);
                ServerTransport serverTransport = (ServerTransport)e;
                if (zzcq2 == null) {
                    serverTransport.shutdown();
                    continue;
                }
                serverTransport.shutdownNow(zzcq2);
            }
            object = ServerImpl.this.lock;
            synchronized (object) {
                ServerImpl.this.transportServerTerminated = true;
                ServerImpl.this.checkForTermination();
                return;
            }
        }
    }
}

