/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.zzbe;
import io.grpc.zzcj;
import io.grpc.zzcn;
import io.grpc.zzco;
import io.grpc.zzcq;
import io.grpc.zzcx;
import io.grpc.zzh;
import io.grpc.zzp;
import io.grpc.zzq;
import io.grpc.zzy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class StatsTraceContext {
    public static final StatsTraceContext NOOP = new StatsTraceContext(new zzcx[0]);
    private final zzcx[] tracers;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public static StatsTraceContext newClientContext(zzh zzh2, zzbe zzbe2) {
        List<zzq> list = zzh2.zzcxe();
        if (list.isEmpty()) {
            return NOOP;
        }
        zzcx[] zzcxArray = new zzcx[list.size()];
        for (int i = 0; i < zzcxArray.length; ++i) {
            zzcxArray[i] = list.get(i).newClientStreamTracer(zzbe2);
        }
        return new StatsTraceContext(zzcxArray);
    }

    public static StatsTraceContext newServerContext(List<zzco> list, String string, zzbe zzbe2) {
        if (list.isEmpty()) {
            return NOOP;
        }
        zzcx[] zzcxArray = new zzcx[list.size()];
        for (int i = 0; i < zzcxArray.length; ++i) {
            zzcxArray[i] = list.get(i).newServerStreamTracer(string, zzbe2);
        }
        return new StatsTraceContext(zzcxArray);
    }

    StatsTraceContext(zzcx[] zzcxArray) {
        this.tracers = zzcxArray;
    }

    public final List<zzcx> getTracersForTest() {
        return new ArrayList<zzcx>(Arrays.asList(this.tracers));
    }

    public final void clientOutboundHeaders() {
        zzcx[] zzcxArray = this.tracers;
        int n = this.tracers.length;
        for (int i = 0; i < n; ++i) {
            ((zzp)zzcxArray[i]).outboundHeaders();
        }
    }

    public final void clientInboundHeaders() {
        zzcx[] zzcxArray = this.tracers;
        int n = this.tracers.length;
        for (int i = 0; i < n; ++i) {
            ((zzp)zzcxArray[i]).inboundHeaders();
        }
    }

    public final <ReqT, RespT> zzy serverFilterContext(zzy zzy2) {
        zzy zzy3 = (zzy)Preconditions.checkNotNull((Object)zzy2, (Object)"context");
        zzcx[] zzcxArray = this.tracers;
        int n = this.tracers.length;
        for (int i = 0; i < n; ++i) {
            zzcx zzcx2 = zzcxArray[i];
            zzy3 = ((zzcn)zzcx2).filterContext(zzy3);
            Preconditions.checkNotNull((Object)zzy3, (String)"%s returns null context", (Object)zzcx2);
        }
        return zzy3;
    }

    public final void serverCallStarted(zzcj<?, ?> zzcj2) {
        zzcx[] zzcxArray = this.tracers;
        int n = this.tracers.length;
        for (int i = 0; i < n; ++i) {
            ((zzcn)zzcxArray[i]).serverCallStarted(zzcj2);
        }
    }

    public final void streamClosed(zzcq zzcq2) {
        if (this.closed.compareAndSet(false, true)) {
            zzcx[] zzcxArray = this.tracers;
            int n = this.tracers.length;
            for (int i = 0; i < n; ++i) {
                zzcxArray[i].streamClosed(zzcq2);
            }
        }
    }

    public final void outboundMessage() {
        zzcx[] zzcxArray = this.tracers;
        int n = this.tracers.length;
        for (int i = 0; i < n; ++i) {
            zzcxArray[i].outboundMessage();
        }
    }

    public final void inboundMessage() {
        zzcx[] zzcxArray = this.tracers;
        int n = this.tracers.length;
        for (int i = 0; i < n; ++i) {
            zzcxArray[i].inboundMessage();
        }
    }

    public final void outboundUncompressedSize(long l) {
        zzcx[] zzcxArray = this.tracers;
        int n = this.tracers.length;
        for (int i = 0; i < n; ++i) {
            zzcxArray[i].outboundUncompressedSize(l);
        }
    }

    public final void outboundWireSize(long l) {
        zzcx[] zzcxArray = this.tracers;
        int n = this.tracers.length;
        for (int i = 0; i < n; ++i) {
            zzcxArray[i].outboundWireSize(l);
        }
    }

    public final void inboundUncompressedSize(long l) {
        zzcx[] zzcxArray = this.tracers;
        int n = this.tracers.length;
        for (int i = 0; i < n; ++i) {
            zzcxArray[i].inboundUncompressedSize(l);
        }
    }

    public final void inboundWireSize(long l) {
        zzcx[] zzcxArray = this.tracers;
        int n = this.tracers.length;
        for (int i = 0; i < n; ++i) {
            zzcxArray[i].inboundWireSize(l);
        }
    }
}

