/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.android.gms.internal.zzdfp;
import com.google.common.base.Charsets;
import io.grpc.InternalMetadata;
import io.grpc.zzbe;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TransportFrameUtil {
    private static final Logger logger = Logger.getLogger(TransportFrameUtil.class.getName());
    private static final byte[] binaryHeaderSuffixBytes = "-bin".getBytes(Charsets.US_ASCII);

    public static byte[][] toHttp2Headers(zzbe zzbe2) {
        byte[][] byArray = InternalMetadata.zza(zzbe2);
        if (byArray == null) {
            return new byte[0][];
        }
        int n = 0;
        for (int i = 0; i < byArray.length; i += 2) {
            byte[] byArray2 = byArray[i];
            byte[] byArray3 = byArray[i + 1];
            if (TransportFrameUtil.endsWith(byArray2, binaryHeaderSuffixBytes)) {
                byArray[n] = byArray2;
                byArray[n + 1] = zzdfp.zzbjp().zzj(byArray3).getBytes(Charsets.US_ASCII);
                n += 2;
                continue;
            }
            if (TransportFrameUtil.isSpecCompliantAscii(byArray3)) {
                byArray[n] = byArray2;
                byArray[n + 1] = byArray3;
                n += 2;
                continue;
            }
            String string = new String(byArray2, Charsets.US_ASCII);
            String string2 = Arrays.toString(byArray3);
            logger.logp(Level.WARNING, "io.grpc.internal.TransportFrameUtil", "toHttp2Headers", new StringBuilder(55 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Metadata key=").append(string).append(", value=").append(string2).append(" contains invalid ASCII characters").toString());
        }
        if (n == byArray.length) {
            return byArray;
        }
        return (byte[][])Arrays.copyOfRange(byArray, 0, n);
    }

    public static byte[][] toRawSerializedHeaders(byte[][] byArray) {
        for (int i = 0; i < byArray.length; i += 2) {
            byte[] byArray2 = byArray[i];
            byte[] byArray3 = byArray[i + 1];
            byArray[i] = byArray2;
            if (!TransportFrameUtil.endsWith(byArray2, binaryHeaderSuffixBytes)) continue;
            byArray[i + 1] = zzdfp.zzbjp().zza(new String(byArray3, Charsets.US_ASCII));
        }
        return byArray;
    }

    private static boolean endsWith(byte[] byArray, byte[] byArray2) {
        int n = byArray.length - byArray2.length;
        if (n < 0) {
            return false;
        }
        for (int i = n; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i - n]) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecCompliantAscii(byte[] byArray) {
        byte[] byArray2 = byArray;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte by = byArray2[i];
            if (by >= 32 && by <= 126) continue;
            return false;
        }
        return true;
    }

    private TransportFrameUtil() {
    }
}

