/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.android.gms.internal.zzezx;
import com.google.common.base.Preconditions;
import com.squareup.okhttp.CipherSuite;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.TlsVersion;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.okhttp.zzo;
import io.grpc.okhttp.zzq;
import io.grpc.okhttp.zzs;
import io.grpc.zza;
import io.grpc.zzbc;
import io.grpc.zzbv;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public final class zzp
extends AbstractManagedChannelImplBuilder<zzp> {
    private static ConnectionSpec zzpef = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384}).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).supportsTlsExtensions(true).build();
    private static final long zzpeg = TimeUnit.DAYS.toNanos(1000L);
    private static final SharedResourceHolder.Resource<ExecutorService> zzpeh = new zzq();
    private SSLSocketFactory sslSocketFactory;
    private ConnectionSpec zzpei = zzpef;
    private zzo zzpej = zzo.zzpec;
    private long zzpek = Long.MAX_VALUE;
    private long zzpel = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;

    public static zzp zzty(String string) {
        return new zzp(string);
    }

    protected zzp(String string, int n) {
        this(GrpcUtil.authorityFromHostAndPort(string, n));
    }

    private zzp(String string) {
        super(string);
    }

    @Override
    protected final ClientTransportFactory buildTransportFactory() {
        boolean bl = this.zzpek != Long.MAX_VALUE;
        return new zzs(null, this.zzcyz(), this.zzpei, this.maxInboundMessageSize(), bl, this.zzpek, this.zzpel, false, null);
    }

    @Override
    protected final zza getNameResolverParams() {
        int n;
        switch (this.zzpej) {
            case zzped: {
                n = 80;
                break;
            }
            case zzpec: {
                n = 443;
                break;
            }
            default: {
                String string = String.valueOf((Object)this.zzpej);
                throw new AssertionError((Object)new StringBuilder(12 + String.valueOf(string).length()).append(string).append(" not handled").toString());
            }
        }
        return zza.zzcwy().zza(zzbv.PARAMS_DEFAULT_PORT, n).zzcwz();
    }

    private final SSLSocketFactory zzcyz() {
        switch (this.zzpej) {
            case zzpec: {
                try {
                    if (this.sslSocketFactory == null) {
                        SSLContext sSLContext;
                        if (GrpcUtil.IS_RESTRICTED_APPENGINE) {
                            sSLContext = SSLContext.getInstance("TLS", zzezx.zzdag().getProvider());
                            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                            trustManagerFactory.init((KeyStore)null);
                            sSLContext.init(null, trustManagerFactory.getTrustManagers(), SecureRandom.getInstance("SHA1PRNG", zzezx.zzdag().getProvider()));
                        } else {
                            sSLContext = SSLContext.getInstance("Default", zzezx.zzdag().getProvider());
                        }
                        this.sslSocketFactory = sSLContext.getSocketFactory();
                    }
                    return this.sslSocketFactory;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new RuntimeException("TLS Provider failure", generalSecurityException);
                }
            }
            case zzped: {
                return null;
            }
        }
        String string = String.valueOf((Object)this.zzpej);
        throw new RuntimeException(new StringBuilder(26 + String.valueOf(string).length()).append("Unknown negotiation type: ").append(string).toString());
    }

    @Override
    public final /* synthetic */ zzbc usePlaintext(boolean bl) {
        zzp zzp2 = this;
        if (!bl) {
            throw new IllegalArgumentException("Plaintext negotiation not currently supported");
        }
        zzo zzo2 = zzo.zzped;
        zzp2.zzpej = (zzo)((Object)Preconditions.checkNotNull((Object)((Object)zzo2), (Object)"type"));
        return zzp2;
    }

    static /* synthetic */ SharedResourceHolder.Resource zzcza() {
        return zzpeh;
    }
}

