/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.NonNull;
import com.google.android.gms.internal.zzelc;
import com.google.android.gms.internal.zzele;
import com.google.android.gms.internal.zzelf;
import com.google.android.gms.internal.zzelg;
import com.google.android.gms.internal.zzetx;
import com.google.android.gms.internal.zzetz;
import com.google.android.gms.internal.zzeuj;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.firestore.FirebaseFirestoreException;

public final class zzeld
extends zzelc {
    private static final String TAG = zzeld.class.getSimpleName();
    private final FirebaseApp zzmfl;
    private final FirebaseApp.zzb zznee;
    private zzetx<zzelg> zznef;
    private zzelg zzneg;
    private int zzneh;

    public zzeld(FirebaseApp firebaseApp) {
        this.zzmfl = firebaseApp;
        this.zzneg = zzelg.zznek;
        this.zznee = new zzele(this, firebaseApp);
        this.zzneg = zzeld.zze(firebaseApp);
        this.zzneh = 0;
        firebaseApp.zza(this.zznee);
    }

    @Override
    public final synchronized Task<String> getToken(boolean bl) {
        Task task = this.zzmfl.getToken(false);
        int n = this.zzneh;
        return task.continueWith((Continuation)new zzelf(this, n));
    }

    @Override
    public final synchronized void zza(@NonNull zzetx<zzelg> zzetx2) {
        this.zznef = zzetx2;
        zzetx2.zzcd(this.zzneg);
    }

    private static zzelg zze(FirebaseApp firebaseApp) {
        try {
            String string = firebaseApp.getUid();
            if (string != null) {
                return new zzelg(string);
            }
            return zzelg.zznek;
        }
        catch (FirebaseApiNotAvailableException firebaseApiNotAvailableException) {
            zzetz.zzf(TAG, "Firebase Auth not available, falling back to unauthenticated usage.", new Object[0]);
            return zzelg.zznek;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ String zza(int n, Task task) throws Exception {
        zzeld zzeld2 = this;
        synchronized (zzeld2) {
            if (n != this.zzneh) {
                throw new FirebaseFirestoreException("getToken aborted due to user change", FirebaseFirestoreException.Code.ABORTED);
            }
            if (!task.isSuccessful()) {
                Exception exception = task.getException();
                if (exception instanceof FirebaseApiNotAvailableException) {
                    zzetz.zzf(TAG, "Firebase Auth is not available, getToken is returning no token.", new Object[0]);
                    return null;
                }
                throw exception;
            }
            return ((GetTokenResult)task.getResult()).getToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zza(FirebaseApp firebaseApp, zzeuj zzeuj2) {
        zzeld zzeld2 = this;
        synchronized (zzeld2) {
            zzelg zzelg2 = zzeld.zze(firebaseApp);
            if (!this.zzneg.equals(zzelg2)) {
                this.zzneg = zzelg2;
                ++this.zzneh;
                if (this.zznef != null) {
                    this.zznef.zzcd(this.zzneg);
                }
            }
            return;
        }
    }
}

