/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzdyw;
import com.google.android.gms.internal.zzeme;
import com.google.android.gms.internal.zzena;
import com.google.android.gms.internal.zzenf;
import com.google.android.gms.internal.zzeod;
import com.google.android.gms.internal.zzepq;
import com.google.android.gms.internal.zzepv;
import com.google.android.gms.internal.zzeqc;
import com.google.android.gms.internal.zzeqe;
import com.google.android.gms.internal.zzeqk;
import com.google.android.gms.internal.zzeql;
import com.google.android.gms.internal.zzetc;
import com.google.android.gms.internal.zzete;
import com.google.android.gms.internal.zzeud;
import com.google.android.gms.internal.zzfdh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class zzenz
implements zzeod {
    private final List<zzeql> zznjt = new ArrayList<zzeql>();
    private zzdyw<zzena> zznju = new zzdyw(Collections.emptyList(), zzena.zznio);
    private int zznjv = 1;
    private int zznjw = -1;
    private zzfdh zznjx = zzetc.zznrs;
    private zzenf zznja;

    zzenz() {
    }

    @Override
    public final void start() {
        if (this.zznjt.isEmpty()) {
            this.zznjv = 1;
            this.zznjw = -1;
        }
        zzete.zzc(this.zznjw < this.zznjv, "highestAcknowledgedBatchId must be less than the nextBatchId", new Object[0]);
    }

    @Override
    public final int zzcby() {
        return this.zznjw;
    }

    @Override
    public final void zza(zzeql zzeql2, zzfdh zzfdh2) {
        int n = zzeql2.zzcbw();
        zzete.zzc(n > this.zznjw, "Mutation batchIds must be acknowledged in order", new Object[0]);
        int n2 = this.zzl(n, "acknowledged");
        zzeql zzeql3 = this.zznjt.get(n2);
        zzete.zzc(n == zzeql3.zzcbw(), "Queue ordering failure: expected batch %d, got batch %d", n, zzeql3.zzcbw());
        zzete.zzc(!zzeql3.zzcdl(), "Can't acknowledge a previously removed batch", new Object[0]);
        this.zznjw = n;
        this.zznjx = (zzfdh)zzbq.checkNotNull((Object)zzfdh2);
    }

    @Override
    public final zzfdh zzcbq() {
        return this.zznjx;
    }

    @Override
    public final void zzac(zzfdh zzfdh2) {
        this.zznjx = (zzfdh)zzbq.checkNotNull((Object)zzfdh2);
    }

    @Override
    public final zzeql zzb(zzeqe zzeqe2, List<zzeqk> list) {
        zzete.zzc(!list.isEmpty(), "Mutation batches should not be empty", new Object[0]);
        int n = this.zznjv++;
        int n2 = this.zznjt.size();
        if (n2 > 0) {
            zzete.zzc(this.zznjt.get(n2 - 1).zzcbw() < n, "Mutation batchIds must be monotonically increasing order", new Object[0]);
        }
        zzeql zzeql2 = new zzeql(n, zzeqe2, list);
        this.zznjt.add(zzeql2);
        for (zzeqk zzeqk2 : list) {
            this.zznju = this.zznju.zzbl((Object)new zzena(zzeqk2.zzbzr(), n));
        }
        return zzeql2;
    }

    @Override
    public final zzeql zzgs(int n) {
        int n2 = this.zzgw(n);
        if (n2 < 0 || n2 >= this.zznjt.size()) {
            return null;
        }
        zzeql zzeql2 = this.zznjt.get(n2);
        zzete.zzc(zzeql2.zzcbw() == n, "If found batch must match", new Object[0]);
        if (zzeql2.zzcdl()) {
            return null;
        }
        return zzeql2;
    }

    @Override
    public final zzeql zzgt(int n) {
        int n2;
        int n3 = this.zznjt.size();
        int n4 = this.zzgw(n = Math.max(n + 1, this.zznjw));
        int n5 = n2 = n4 < 0 ? 0 : n4;
        while (n2 < n3) {
            zzeql zzeql2 = this.zznjt.get(n2);
            if (!zzeql2.zzcdl()) {
                return zzeql2;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public final List<zzeql> zzcbz() {
        return this.zzgv(this.zznjt.size());
    }

    @Override
    public final List<zzeql> zzgu(int n) {
        int n2 = this.zznjt.size();
        int n3 = this.zzgw(n);
        n3 = n3 < 0 ? 0 : (n3 >= n2 ? n2 : ++n3);
        return this.zzgv(n3);
    }

    @Override
    public final List<zzeql> zzf(zzepv zzepv2) {
        zzena zzena2;
        zzena zzena3 = new zzena(zzepv2, 0);
        ArrayList<zzeql> arrayList = new ArrayList<zzeql>();
        Iterator iterator = this.zznju.zzbf((Object)zzena3);
        while (iterator.hasNext() && zzepv2.equals((zzena2 = (zzena)iterator.next()).zzbzr())) {
            zzeql zzeql2 = this.zzgs(zzena2.getId());
            zzete.zzc(zzeql2 != null, "Batches in the index must exist in the main table", new Object[0]);
            arrayList.add(zzeql2);
        }
        return arrayList;
    }

    @Override
    public final List<zzeql> zzh(zzeme zzeme2) {
        Object object;
        Object object2;
        zzeqc zzeqc2 = zzeme2.zzcan();
        int n = zzeqc2.length() + 1;
        zzeqc zzeqc3 = zzeqc2;
        if (!zzepv.zzc(zzeqc3)) {
            zzeqc3 = (zzeqc)zzeqc3.zzqe("");
        }
        zzena zzena2 = new zzena(zzepv.zzb(zzeqc3), 0);
        zzdyw zzdyw2 = new zzdyw(Collections.emptyList(), zzeud.comparator());
        Iterator iterator = this.zznju.zzbf((Object)zzena2);
        while (iterator.hasNext() && zzeqc2.zzd(object2 = ((zzena)(object = (zzena)iterator.next())).zzbzr().zzcan())) {
            if (((zzepq)object2).length() != n) continue;
            zzdyw2 = zzdyw2.zzbl((Object)((zzena)object).getId());
        }
        object = new ArrayList();
        for (Integer n2 : zzdyw2) {
            zzeql zzeql2 = this.zzgs(n2);
            if (zzeql2 == null) continue;
            object.add(zzeql2);
        }
        return object;
    }

    @Override
    public final void zzbe(List<zzeql> list) {
        int n = list.size();
        zzete.zzc(n > 0, "Should not remove mutations when none exist.", new Object[0]);
        int n2 = list.get(0).zzcbw();
        int n3 = this.zznjt.size();
        int n4 = this.zzl(n2, "removed");
        zzete.zzc(this.zznjt.get(n4).zzcbw() == n2, "Removed batches must exist in the queue", new Object[0]);
        int n5 = 1;
        int n6 = n4 + 1;
        while (n5 < n && n6 < n3) {
            zzeql zzeql2 = this.zznjt.get(n6);
            if (zzeql2.zzcdl()) {
                ++n6;
                continue;
            }
            zzete.zzc(zzeql2.zzcbw() == list.get(n5).zzcbw(), "Removed batches must be contiguous in the queue", new Object[0]);
            ++n5;
            ++n6;
        }
        if (n4 == 0) {
            while (n6 < n3 && this.zznjt.get(n6).zzcdl()) {
                ++n6;
            }
            this.zznjt.subList(n4, n6).clear();
        } else {
            for (int i = n4; i < n6; ++i) {
                this.zznjt.set(i, this.zznjt.get(i).zzcdm());
            }
        }
        zzdyw zzdyw2 = this.zznju;
        for (zzeql zzeql3 : list) {
            int n7 = zzeql3.zzcbw();
            Iterator<zzeqk> iterator = zzeql3.zzcdn().iterator();
            while (iterator.hasNext()) {
                zzepv zzepv2 = iterator.next().zzbzr();
                if (this.zznja != null) {
                    this.zznja.zzc(zzepv2);
                }
                zzena zzena2 = new zzena(zzepv2, n7);
                zzdyw2 = zzdyw2.zzbk((Object)zzena2);
            }
        }
        this.zznju = zzdyw2;
    }

    @Override
    public final void zzcca() {
        if (this.zznjt.isEmpty()) {
            zzete.zzc(this.zznju.isEmpty(), "Document leak -- detected dangling mutation references when queue is empty.", new Object[0]);
        }
    }

    @Override
    public final void zza(zzenf zzenf2) {
        this.zznja = zzenf2;
    }

    @Override
    public final boolean zzd(zzepv zzepv2) {
        zzena zzena2 = new zzena(zzepv2, 0);
        Iterator iterator = this.zznju.zzbf((Object)zzena2);
        if (!iterator.hasNext()) {
            return false;
        }
        return ((zzena)iterator.next()).zzbzr().equals(zzepv2);
    }

    private final List<zzeql> zzgv(int n) {
        ArrayList<zzeql> arrayList = new ArrayList<zzeql>(n);
        for (int i = 0; i < n; ++i) {
            zzeql zzeql2 = this.zznjt.get(i);
            if (zzeql2.zzcdl()) continue;
            arrayList.add(zzeql2);
        }
        return arrayList;
    }

    private final int zzgw(int n) {
        if (this.zznjt.isEmpty()) {
            return 0;
        }
        int n2 = this.zznjt.get(0).zzcbw();
        return n - n2;
    }

    private final int zzl(int n, String string) {
        int n2 = this.zzgw(n);
        zzete.zzc(n2 >= 0 && n2 < this.zznjt.size(), "Batches must exist to be %s", string);
        return n2;
    }
}

