/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.internal.zzelg;
import com.google.android.gms.internal.zzeni;
import com.google.android.gms.internal.zzeod;
import com.google.android.gms.internal.zzeof;
import com.google.android.gms.internal.zzeog;
import com.google.android.gms.internal.zzeol;
import com.google.android.gms.internal.zzeon;
import com.google.android.gms.internal.zzepa;
import com.google.android.gms.internal.zzepb;
import com.google.android.gms.internal.zzepd;
import com.google.android.gms.internal.zzepl;
import com.google.android.gms.internal.zzepr;
import com.google.android.gms.internal.zzete;
import com.google.android.gms.internal.zzetz;
import com.google.android.gms.internal.zzeuc;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public final class zzeoy
extends zzeof {
    private final zzepa zznku;
    private final zzeni zznkr;
    private SQLiteDatabase zznkv;
    private boolean started;

    @VisibleForTesting
    private static String zza(String string, zzepr zzepr2) {
        try {
            String string2 = URLEncoder.encode(string, "utf-8");
            String string3 = URLEncoder.encode(zzepr2.getProjectId(), "utf-8");
            String string4 = URLEncoder.encode(zzepr2.zzccp(), "utf-8");
            return new StringBuilder(12 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("firestore.").append(string2).append(".").append(string3).append(".").append(string4).toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public zzeoy(Context context, String string, zzepr zzepr2, zzeni zzeni2) {
        String string2 = zzeoy.zza(string, zzepr2);
        this.zznku = new zzepa(context, string2);
        this.zznkr = zzeni2;
    }

    @Override
    public final void start() {
        zzete.zzc(!this.started, "SQLitePersistence double-started!", new Object[0]);
        this.started = true;
        try {
            this.zznkv = this.zznku.getWritableDatabase();
            return;
        }
        catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
            throw new RuntimeException("Failed to gain exclusive lock to the Firestore client's offline persistence. This generally means you are using Firestore from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing Firestore in your Application class. If you are intentionally using Firestore from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.", sQLiteDatabaseLockedException);
        }
    }

    @Override
    final zzeod zzd(zzelg zzelg2) {
        return new zzeon(this, this.zznkr, zzelg2);
    }

    @Override
    final zzeog zzccb() {
        return new zzepd(this, this.zznkr);
    }

    @Override
    final zzeol zzccc() {
        return new zzepl(this, this.zznkr);
    }

    @Override
    final void zzb(String string, Runnable runnable) {
        try {
            zzetz.zzf(TAG, "Starting transaction: %s", string);
            this.zznkv.beginTransaction();
            runnable.run();
            this.zznkv.setTransactionSuccessful();
            return;
        }
        finally {
            this.zznkv.endTransaction();
        }
    }

    @Override
    final <T> T zza(String string, zzeuc<T> zzeuc2) {
        try {
            zzetz.zzf(TAG, "Starting transaction: %s", string);
            this.zznkv.beginTransaction();
            T t = zzeuc2.get();
            this.zznkv.setTransactionSuccessful();
            T t2 = t;
            return t2;
        }
        finally {
            this.zznkv.endTransaction();
        }
    }

    final void zzk(String string, Object ... objectArray) {
        this.zznkv.execSQL(string, objectArray);
    }

    final SQLiteStatement zzqc(String string) {
        return this.zznkv.compileStatement(string);
    }

    static int zza(SQLiteStatement sQLiteStatement, Object ... objectArray) {
        sQLiteStatement.clearBindings();
        zzeoy.zza((SQLiteProgram)sQLiteStatement, objectArray);
        return sQLiteStatement.executeUpdateDelete();
    }

    final zzepb zzqd(String string) {
        return new zzepb(this, string, null);
    }

    private static void zza(SQLiteProgram sQLiteProgram, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) {
                sQLiteProgram.bindNull(i + 1);
                continue;
            }
            if (object instanceof String) {
                sQLiteProgram.bindString(i + 1, (String)object);
                continue;
            }
            if (object instanceof Integer) {
                sQLiteProgram.bindLong(i + 1, (long)((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                sQLiteProgram.bindLong(i + 1, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                sQLiteProgram.bindDouble(i + 1, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof byte[]) {
                sQLiteProgram.bindBlob(i + 1, (byte[])object);
                continue;
            }
            throw zzete.zzl("Unknown argument %s of type %s", object, object.getClass());
        }
    }

    static /* synthetic */ SQLiteDatabase zza(zzeoy zzeoy2) {
        return zzeoy2.zznkv;
    }

    static /* synthetic */ void zza(zzeoy zzeoy2, SQLiteProgram sQLiteProgram, Object[] objectArray) {
        zzeoy.zza(sQLiteProgram, objectArray);
    }
}

