/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.internal.zzete;
import com.google.android.gms.internal.zzetg;
import com.google.android.gms.internal.zzeth;
import com.google.android.gms.internal.zzeti;
import com.google.android.gms.internal.zzetj;
import com.google.android.gms.internal.zzetk;
import com.google.android.gms.internal.zzetz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class zzetf {
    private final Thread thread;
    private final ScheduledThreadPoolExecutor zznab;

    public static <TResult> Task<TResult> zza(Executor executor, Callable<Task<TResult>> callable) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        executor.execute(new zzetg(callable, executor, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    public zzetf() {
        zza zza2 = new zza(this, null);
        this.thread = Executors.defaultThreadFactory().newThread(zza2);
        this.thread.setName("FirestoreWorker");
        this.thread.setDaemon(true);
        this.thread.setUncaughtExceptionHandler(new zzeth(this));
        this.zznab = new zzetk(this, 1, zza2);
        this.zznab.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public final Executor zzcgq() {
        return this.zznab;
    }

    public final void zzcgr() {
        Thread thread = Thread.currentThread();
        if (this.thread != thread) {
            zzete.zzl("We are running on the wrong thread. Expected to be on the AsyncQueue thread %s/%d but was %s/%d", this.thread.getName(), this.thread.getId(), thread.getName(), thread.getId());
        }
    }

    public final void zzp(Runnable runnable) {
        try {
            this.zznab.execute(runnable);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            zzetz.zze(zzetf.class.getSimpleName(), "Refused to enqueue task after panic", new Object[0]);
            return;
        }
    }

    public final void zzk(Throwable throwable) {
        this.zznab.shutdownNow();
        new Handler(Looper.getMainLooper()).post((Runnable)new zzeti(throwable));
    }

    public final ScheduledFuture<?> zza(Runnable runnable, long l) {
        return this.zznab.schedule(runnable, l, TimeUnit.MILLISECONDS);
    }

    final /* synthetic */ void zzb(Thread thread, Throwable throwable) {
        this.zzk(throwable);
    }

    final class zza
    implements Runnable,
    ThreadFactory {
        private final CountDownLatch zznsa = new CountDownLatch(1);
        private Runnable zznsb;
        private /* synthetic */ zzetf zznrz;

        private zza(zzetf zzetf2) {
            this.zznrz = zzetf2;
        }

        @Override
        public final void run() {
            try {
                this.zznsa.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            this.zznsb.run();
        }

        @Override
        public final Thread newThread(@NonNull Runnable runnable) {
            zzete.zzc(this.zznsb == null, "Only one thread may be created in an AsyncQueue.", new Object[0]);
            this.zznsb = runnable;
            this.zznsa.countDown();
            return this.zznrz.thread;
        }

        /* synthetic */ zza(zzetf zzetf2, zzetj zzetj2) {
            this(zzetf2);
        }
    }
}

