/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfit;
import com.google.android.gms.internal.zzfiv;
import com.google.android.gms.internal.zzfix;
import com.google.android.gms.internal.zzfjx;
import io.grpc.internal.zzbu;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

public class zzfiu {
    public static final Logger logger = Logger.getLogger(zzfiu.class.getName());
    private static final String[] zzqlx = new String[]{"com.google.android.gms.org.conscrypt.OpenSSLProvider", "com.android.org.conscrypt.OpenSSLProvider", "org.conscrypt.OpenSSLProvider", "org.apache.harmony.xnet.provider.jsse.OpenSSLProvider"};
    private static final zzfiu zzqly = zzfiu.zzdek();
    private final Provider zzqlz;

    public static zzfiu zzdej() {
        return zzqly;
    }

    public zzfiu(Provider provider) {
        this.zzqlz = provider;
    }

    public final Provider getProvider() {
        return this.zzqlz;
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, String string, List<zzfiv> list) {
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    private static zzfiu zzdek() {
        Provider provider;
        Provider provider2;
        block13: {
            if (zzbu.zzpwo) {
                provider2 = zzfiu.zzdel();
            } else {
                String[] stringArray = zzqlx;
                int n = zzqlx.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    for (Provider provider3 : Security.getProviders()) {
                        if (!string.equals(provider3.getClass().getName())) continue;
                        logger.logp(Level.FINE, "io.grpc.okhttp.internal.Platform", "getAndroidSecurityProvider", "Found registered provider {0}", string);
                        provider2 = provider3;
                        break block13;
                    }
                }
                logger.logp(Level.WARNING, "io.grpc.okhttp.internal.Platform", "getAndroidSecurityProvider", "Unable to find Conscrypt");
                provider2 = provider = null;
            }
        }
        if (provider2 != null) {
            zzfit<Socket> zzfit2 = new zzfit<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            zzfit<Socket> zzfit3 = new zzfit<Socket>(null, "setHostname", String.class);
            Method method = null;
            Method method2 = null;
            zzfit<Socket> zzfit4 = new zzfit<Socket>(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
            zzfit<Socket> zzfit5 = new zzfit<Socket>(null, "setAlpnProtocols", byte[].class);
            try {
                Class<?> clazz = Class.forName("android.net.TrafficStats");
                method = clazz.getMethod("tagSocket", Socket.class);
                method2 = clazz.getMethod("untagSocket", Socket.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            return new zza(zzfit2, zzfit3, method, method2, zzfit4, zzfit5, provider);
        }
        try {
            provider = SSLContext.getDefault().getProvider();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        try {
            String string = "org.eclipse.jetty.alpn.ALPN";
            Class<?> clazz = Class.forName("org.eclipse.jetty.alpn.ALPN");
            Class<?> clazz2 = Class.forName(String.valueOf(string).concat("$Provider"));
            Class<?> clazz3 = Class.forName(String.valueOf(string).concat("$ClientProvider"));
            Class<?> clazz4 = Class.forName(String.valueOf(string).concat("$ServerProvider"));
            Method method = clazz.getMethod("put", SSLSocket.class, clazz2);
            Method method3 = clazz.getMethod("get", SSLSocket.class);
            Method method4 = clazz.getMethod("remove", SSLSocket.class);
            return new zzb(method, method3, method4, clazz3, clazz4, provider);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return new zzfiu(provider);
    }

    private static Provider zzdel() {
        try {
            return (Provider)Class.forName("org.conscrypt.OpenSSLProvider").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to load conscrypt security provider", throwable);
        }
    }

    public static byte[] concatLengthPrefixed(List<zzfiv> list) {
        zzfjx zzfjx2 = new zzfjx();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            zzfiv zzfiv2 = list.get(i);
            if (zzfiv2 == zzfiv.zzqml) continue;
            zzfjx2.zzng(zzfiv2.toString().length());
            zzfjx2.zzuc(zzfiv2.toString());
        }
        return zzfjx2.zzdfc();
    }

    static final class zzc
    implements InvocationHandler {
        private final List<String> protocols;
        private boolean unsupported;
        private String selected;

        public zzc(List<String> list) {
            this.protocols = list;
        }

        @Override
        public final Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            Class<?> clazz = method.getReturnType();
            if (objectArray == null) {
                objectArray = zzfix.EMPTY_STRING_ARRAY;
            }
            if (string.equals("supports") && Boolean.TYPE == clazz) {
                return true;
            }
            if (string.equals("unsupported") && Void.TYPE == clazz) {
                this.unsupported = true;
                return null;
            }
            if (string.equals("protocols") && objectArray.length == 0) {
                return this.protocols;
            }
            if ((string.equals("selectProtocol") || string.equals("select")) && String.class == clazz && objectArray.length == 1 && objectArray[0] instanceof List) {
                List list = (List)objectArray[0];
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (!this.protocols.contains(list.get(i))) continue;
                    this.selected = (String)list.get(i);
                    return this.selected;
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((string.equals("protocolSelected") || string.equals("selected")) && objectArray.length == 1) {
                this.selected = (String)objectArray[0];
                return null;
            }
            return method.invoke((Object)this, objectArray);
        }
    }

    static final class zzb
    extends zzfiu {
        private final Method zzqmg;
        private final Method zzqmh;
        private final Method zzqmi;
        private final Class<?> zzqmj;
        private final Class<?> zzqmk;

        public zzb(Method method, Method method2, Method method3, Class<?> clazz, Class<?> clazz2, Provider provider) {
            super(provider);
            this.zzqmg = method;
            this.zzqmh = method2;
            this.zzqmi = method3;
            this.zzqmj = clazz;
            this.zzqmk = clazz2;
        }

        @Override
        public final void configureTlsExtensions(SSLSocket sSLSocket, String string, List<zzfiv> list) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                zzfiv zzfiv2 = list.get(i);
                if (zzfiv2 == zzfiv.zzqml) continue;
                arrayList.add(zzfiv2.toString());
            }
            try {
                Object object = Proxy.newProxyInstance(zzfiu.class.getClassLoader(), new Class[]{this.zzqmj, this.zzqmk}, (InvocationHandler)new zzc(arrayList));
                this.zzqmg.invoke(null, sSLSocket, object);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError((Object)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        @Override
        public final void afterHandshake(SSLSocket sSLSocket) {
            try {
                this.zzqmi.invoke(null, sSLSocket);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                return;
            }
        }

        @Override
        public final String getSelectedProtocol(SSLSocket sSLSocket) {
            try {
                zzc zzc2 = (zzc)Proxy.getInvocationHandler(this.zzqmh.invoke(null, sSLSocket));
                if (!zzc2.unsupported && zzc2.selected == null) {
                    logger.logp(Level.INFO, "io.grpc.okhttp.internal.Platform$JdkWithJettyBootPlatform", "getSelectedProtocol", "ALPN callback dropped: SPDY and HTTP/2 are disabled. Is alpn-boot on the boot class path?");
                    return null;
                }
                if (zzc2.unsupported) {
                    return null;
                }
                return zzc2.selected;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new AssertionError();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
    }

    static final class zza
    extends zzfiu {
        private final zzfit<Socket> zzqma;
        private final zzfit<Socket> zzqmb;
        private final Method zzqmc;
        private final Method zzqmd;
        private final zzfit<Socket> zzqme;
        private final zzfit<Socket> zzqmf;

        public zza(zzfit<Socket> zzfit2, zzfit<Socket> zzfit3, Method method, Method method2, zzfit<Socket> zzfit4, zzfit<Socket> zzfit5, Provider provider) {
            super(provider);
            this.zzqma = zzfit2;
            this.zzqmb = zzfit3;
            this.zzqmc = method;
            this.zzqmd = method2;
            this.zzqme = zzfit4;
            this.zzqmf = zzfit5;
        }

        @Override
        public final void configureTlsExtensions(SSLSocket sSLSocket, String string, List<zzfiv> list) {
            if (string != null) {
                this.zzqma.invokeOptionalWithoutCheckedException(sSLSocket, true);
                this.zzqmb.invokeOptionalWithoutCheckedException(sSLSocket, string);
            }
            if (this.zzqmf.isSupported(sSLSocket)) {
                Object[] objectArray = new Object[]{zza.concatLengthPrefixed(list)};
                this.zzqmf.invokeWithoutCheckedException(sSLSocket, objectArray);
            }
        }

        @Override
        public final String getSelectedProtocol(SSLSocket sSLSocket) {
            if (!this.zzqme.isSupported(sSLSocket)) {
                return null;
            }
            byte[] byArray = (byte[])this.zzqme.invokeWithoutCheckedException(sSLSocket, new Object[0]);
            if (byArray != null) {
                return new String(byArray, zzfix.UTF_8);
            }
            return null;
        }
    }
}

