/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfjc;
import com.google.android.gms.internal.zzfje;
import com.google.android.gms.internal.zzfjl;
import com.google.android.gms.internal.zzfjz;
import com.google.android.gms.internal.zzfka;
import com.google.android.gms.internal.zzfkd;
import com.google.android.gms.internal.zzfkn;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class zzfjf {
    private final List<zzfjc> zzqnz = new ArrayList<zzfjc>();
    private final zzfjz source;
    private int headerTableSizeSetting = 4096;
    private int maxDynamicTableByteCount = 4096;
    private zzfjc[] zzqoa = new zzfjc[8];
    private int nextHeaderIndex = this.zzqoa.length - 1;
    private int headerCount = 0;
    private int dynamicTableByteCount = 0;

    zzfjf(int n, zzfkn zzfkn2) {
        this.source = zzfkd.zzb(zzfkn2);
    }

    final void zzmy(int n) {
        this.headerTableSizeSetting = n;
        this.maxDynamicTableByteCount = n;
        this.zzden();
    }

    private final void zzden() {
        if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
            if (this.maxDynamicTableByteCount == 0) {
                this.zzdeo();
                return;
            }
            this.zzmz(this.dynamicTableByteCount - this.maxDynamicTableByteCount);
        }
    }

    private final void zzdeo() {
        this.zzqnz.clear();
        Arrays.fill(this.zzqoa, null);
        this.nextHeaderIndex = this.zzqoa.length - 1;
        this.headerCount = 0;
        this.dynamicTableByteCount = 0;
    }

    private final int zzmz(int n) {
        int n2 = 0;
        if (n > 0) {
            for (int i = this.zzqoa.length - 1; i >= this.nextHeaderIndex && n > 0; --i) {
                n -= this.zzqoa[i].hpackSize;
                this.dynamicTableByteCount -= this.zzqoa[i].hpackSize;
                --this.headerCount;
                ++n2;
            }
            System.arraycopy(this.zzqoa, this.nextHeaderIndex + 1, this.zzqoa, this.nextHeaderIndex + 1 + n2, this.headerCount);
            this.nextHeaderIndex += n2;
        }
        return n2;
    }

    final void readHeaders() throws IOException {
        while (!this.source.zzdfa()) {
            zzfka zzfka2;
            Object object;
            zzfjf zzfjf2;
            int n;
            int n2 = this.source.readByte() & 0xFF;
            if (n2 == 128) {
                throw new IOException("index == 0");
            }
            if ((n2 & 0x80) == 128) {
                n = this.readInt(n2, 127);
                int n3 = n - 1;
                zzfjf2 = this;
                if (zzfjf.zznc(n3)) {
                    object = zzfje.zzdem()[n3];
                    zzfjf2.zzqnz.add((zzfjc)object);
                    continue;
                }
                int n4 = zzfjf2.zzna(n3 - zzfje.zzdem().length);
                if (n4 < 0 || n4 > zzfjf2.zzqoa.length - 1) {
                    int n5 = n3 + 1;
                    throw new IOException(new StringBuilder(34).append("Header index too large ").append(n5).toString());
                }
                zzfjf2.zzqnz.add(zzfjf2.zzqoa[n4]);
                continue;
            }
            if (n2 == 64) {
                zzfjf2 = this;
                zzfka zzfka3 = zzfje.zza(zzfjf2.readByteString());
                object = zzfjf2.readByteString();
                zzfjf2.zza(-1, new zzfjc(zzfka3, (zzfka)object));
                continue;
            }
            if ((n2 & 0x40) == 64) {
                n = this.readInt(n2, 63);
                int n6 = n - 1;
                zzfjf2 = this;
                object = zzfjf2.zznb(n6);
                zzfka2 = zzfjf2.readByteString();
                zzfjf2.zza(-1, new zzfjc((zzfka)object, zzfka2));
                continue;
            }
            if ((n2 & 0x20) == 32) {
                this.maxDynamicTableByteCount = this.readInt(n2, 31);
                if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                    n = this.maxDynamicTableByteCount;
                    throw new IOException(new StringBuilder(45).append("Invalid dynamic table size update ").append(n).toString());
                }
                this.zzden();
                continue;
            }
            if (n2 == 16 || n2 == 0) {
                zzfjf2 = this;
                zzfka zzfka4 = zzfje.zza(zzfjf2.readByteString());
                object = zzfjf2.readByteString();
                zzfjf2.zzqnz.add(new zzfjc(zzfka4, (zzfka)object));
                continue;
            }
            n = this.readInt(n2, 15);
            int n7 = n - 1;
            zzfjf2 = this;
            object = zzfjf2.zznb(n7);
            zzfka2 = zzfjf2.readByteString();
            zzfjf2.zzqnz.add(new zzfjc((zzfka)object, zzfka2));
        }
    }

    public final List<zzfjc> getAndResetHeaderList() {
        ArrayList<zzfjc> arrayList = new ArrayList<zzfjc>(this.zzqnz);
        this.zzqnz.clear();
        return arrayList;
    }

    private final int zzna(int n) {
        return this.nextHeaderIndex + 1 + n;
    }

    private final zzfka zznb(int n) {
        if (zzfjf.zznc(n)) {
            return zzfje.zzdem()[n].name;
        }
        return this.zzqoa[this.zzna((int)(n - zzfje.zzdem().length))].name;
    }

    private static boolean zznc(int n) {
        return n >= 0 && n <= zzfje.zzdem().length - 1;
    }

    private final void zza(int n, zzfjc zzfjc2) {
        this.zzqnz.add(zzfjc2);
        int n2 = zzfjc2.hpackSize;
        if (n2 > this.maxDynamicTableByteCount) {
            this.zzdeo();
            return;
        }
        int n3 = this.dynamicTableByteCount + n2 - this.maxDynamicTableByteCount;
        this.zzmz(n3);
        if (this.headerCount + 1 > this.zzqoa.length) {
            zzfjc[] zzfjcArray = new zzfjc[this.zzqoa.length << 1];
            System.arraycopy(this.zzqoa, 0, zzfjcArray, this.zzqoa.length, this.zzqoa.length);
            this.nextHeaderIndex = this.zzqoa.length - 1;
            this.zzqoa = zzfjcArray;
        }
        n = this.nextHeaderIndex--;
        this.zzqoa[n] = zzfjc2;
        ++this.headerCount;
        this.dynamicTableByteCount += n2;
    }

    private final int zzdep() throws IOException {
        return this.source.readByte() & 0xFF;
    }

    private final int readInt(int n, int n2) throws IOException {
        int n3;
        int n4 = n & n2;
        if (n4 < n2) {
            return n4;
        }
        int n5 = n2;
        int n6 = 0;
        while (((n3 = this.zzdep()) & 0x80) != 0) {
            n5 += (n3 & 0x7F) << n6;
            n6 += 7;
        }
        return n5 += n3 << n6;
    }

    private final zzfka readByteString() throws IOException {
        int n = this.zzdep();
        boolean bl = (n & 0x80) == 128;
        int n2 = this.readInt(n, 127);
        if (bl) {
            return zzfka.zzbp(zzfjl.zzder().decode(this.source.zzdu(n2)));
        }
        return this.source.zzdq(n2);
    }
}

