/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfiy;
import com.google.android.gms.internal.zzfiz;
import com.google.android.gms.internal.zzfja;
import com.google.android.gms.internal.zzfjc;
import com.google.android.gms.internal.zzfjd;
import com.google.android.gms.internal.zzfjf;
import com.google.android.gms.internal.zzfjh;
import com.google.android.gms.internal.zzfji;
import com.google.android.gms.internal.zzfjn;
import com.google.android.gms.internal.zzfjz;
import com.google.android.gms.internal.zzfka;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

final class zzfjj
implements zzfiz {
    private final zzfjz source;
    private final zzfji zzqoc;
    private final boolean client;
    private zzfjf zzqod;

    zzfjj(zzfjz zzfjz2, int n, boolean bl) {
        this.source = zzfjz2;
        this.client = true;
        this.zzqoc = new zzfji(this.source);
        this.zzqod = new zzfjf(4096, this.zzqoc);
    }

    @Override
    public final boolean zza(zzfja zzfja2) throws IOException {
        try {
            this.source.zzdo(9L);
        }
        catch (IOException iOException) {
            return false;
        }
        int n = zzfjh.zza(this.source);
        if (n < 0 || n > 16384) {
            throw zzfjh.zzm("FRAME_SIZE_ERROR: %s", new Object[]{n});
        }
        byte by = this.source.readByte();
        byte by2 = this.source.readByte();
        int n2 = this.source.readInt() & Integer.MAX_VALUE;
        if (zzfjh.zzdan().isLoggable(Level.FINE)) {
            zzfjh.zzdan().logp(Level.FINE, "io.grpc.okhttp.internal.framed.Http2$Reader", "nextFrame", zzfjh.zza.zza(true, n2, n, by, by2));
        }
        switch (by) {
            case 0: {
                int n3 = n2;
                byte by3 = by2;
                int n4 = n;
                zzfja zzfja3 = zzfja2;
                zzfjj zzfjj2 = this;
                boolean bl = (by3 & 1) != 0;
                if ((by3 & 0x20) != 0) {
                    throw zzfjh.zzm("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
                }
                short s = (by3 & 8) != 0 ? (short)(zzfjj2.source.readByte() & 0xFF) : (short)0;
                n4 = zzfjh.zza(n4, by3, s);
                zzfja3.data(bl, n3, zzfjj2.source, n4);
                zzfjj2.source.zzdv(s);
                break;
            }
            case 1: {
                short s;
                int n5 = n2;
                byte by4 = by2;
                int n6 = n;
                zzfja zzfja4 = zzfja2;
                zzfjj zzfjj3 = this;
                if (n5 == 0) {
                    throw zzfjh.zzm("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
                }
                boolean bl = (by4 & 1) != 0;
                short s2 = s = (by4 & 8) != 0 ? (short)(zzfjj3.source.readByte() & 0xFF) : (short)0;
                if ((by4 & 0x20) != 0) {
                    zzfjj3.zza(zzfja4, n5);
                    n6 -= 5;
                }
                n6 = zzfjh.zza(n6, by4, s);
                List<zzfjc> list = zzfjj3.zza(n6, s, by4, n5);
                zzfja4.zza(false, bl, n5, -1, list, zzfjd.zzqnw);
                break;
            }
            case 2: {
                int n7 = n2;
                int n8 = n;
                zzfja zzfja5 = zzfja2;
                zzfjj zzfjj4 = this;
                if (n8 != 5) {
                    throw zzfjh.zzm("TYPE_PRIORITY length: %d != 5", new Object[]{n8});
                }
                if (n7 == 0) {
                    throw zzfjh.zzm("TYPE_PRIORITY streamId == 0", new Object[0]);
                }
                zzfjj4.zza(zzfja5, n7);
                break;
            }
            case 3: {
                int n9 = n2;
                int n10 = n;
                zzfja zzfja6 = zzfja2;
                zzfjj zzfjj5 = this;
                if (n10 != 4) {
                    throw zzfjh.zzm("TYPE_RST_STREAM length: %d != 4", new Object[]{n10});
                }
                if (n9 == 0) {
                    throw zzfjh.zzm("TYPE_RST_STREAM streamId == 0", new Object[0]);
                }
                int n11 = zzfjj5.source.readInt();
                zzfiy zzfiy2 = zzfiy.zzmx(n11);
                if (zzfiy2 == null) {
                    throw zzfjh.zzm("TYPE_RST_STREAM unexpected error code: %d", new Object[]{n11});
                }
                zzfja6.zza(n9, zzfiy2);
                break;
            }
            case 4: {
                int n12 = n2;
                byte by5 = by2;
                int n13 = n;
                zzfja zzfja7 = zzfja2;
                zzfjj zzfjj6 = this;
                if (n12 != 0) {
                    throw zzfjh.zzm("TYPE_SETTINGS streamId != 0", new Object[0]);
                }
                if ((by5 & 1) != 0) {
                    if (n13 == 0) break;
                    throw zzfjh.zzm("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
                }
                if (n13 % 6 != 0) {
                    throw zzfjh.zzm("TYPE_SETTINGS length %% 6 != 0: %s", new Object[]{n13});
                }
                zzfjn zzfjn2 = new zzfjn();
                block21: for (int i = 0; i < n13; i += 6) {
                    int n14 = zzfjj6.source.readShort();
                    int n15 = zzfjj6.source.readInt();
                    switch (n14) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (n15 == 0 || n15 == 1) break;
                            throw zzfjh.zzm("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                        }
                        case 3: {
                            n14 = 4;
                            break;
                        }
                        case 4: {
                            n14 = 7;
                            if (n15 >= 0) break;
                            throw zzfjh.zzm("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                        }
                        case 5: {
                            if (n15 >= 16384 && n15 <= 0xFFFFFF) break;
                            throw zzfjh.zzm("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", new Object[]{n15});
                        }
                        case 6: {
                            break;
                        }
                        default: {
                            continue block21;
                        }
                    }
                    zzfjn2.zzk(n14, 0, n15);
                }
                zzfja7.zza(false, zzfjn2);
                if (zzfjn2.getHeaderTableSize() < 0) break;
                zzfjj6.zzqod.zzmy(zzfjn2.getHeaderTableSize());
                break;
            }
            case 5: {
                int n16 = n2;
                byte by6 = by2;
                int n17 = n;
                zzfja zzfja8 = zzfja2;
                zzfjj zzfjj7 = this;
                if (n16 == 0) {
                    throw zzfjh.zzm("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
                }
                short s = (by6 & 8) != 0 ? (short)(zzfjj7.source.readByte() & 0xFF) : (short)0;
                int n18 = zzfjj7.source.readInt() & Integer.MAX_VALUE;
                n17 -= 4;
                n17 = zzfjh.zza(n17, by6, s);
                List<zzfjc> list = zzfjj7.zza(n17, s, by6, n16);
                zzfja8.pushPromise(n16, n18, list);
                break;
            }
            case 6: {
                int n19 = n2;
                byte by7 = by2;
                int n20 = n;
                zzfja zzfja9 = zzfja2;
                zzfjj zzfjj8 = this;
                if (n20 != 8) {
                    throw zzfjh.zzm("TYPE_PING length != 8: %s", new Object[]{n20});
                }
                if (n19 != 0) {
                    throw zzfjh.zzm("TYPE_PING streamId != 0", new Object[0]);
                }
                int n21 = zzfjj8.source.readInt();
                int n22 = zzfjj8.source.readInt();
                boolean bl = (by7 & 1) != 0;
                zzfja9.ping(bl, n21, n22);
                break;
            }
            case 7: {
                int n23 = n2;
                int n24 = n;
                zzfja zzfja10 = zzfja2;
                zzfjj zzfjj9 = this;
                if (n24 < 8) {
                    throw zzfjh.zzm("TYPE_GOAWAY length < 8: %s", new Object[]{n24});
                }
                if (n23 != 0) {
                    throw zzfjh.zzm("TYPE_GOAWAY streamId != 0", new Object[0]);
                }
                int n25 = zzfjj9.source.readInt();
                int n26 = zzfjj9.source.readInt();
                int n27 = n24 - 8;
                zzfiy zzfiy3 = zzfiy.zzmx(n26);
                if (zzfiy3 == null) {
                    throw zzfjh.zzm("TYPE_GOAWAY unexpected error code: %d", new Object[]{n26});
                }
                zzfka zzfka2 = zzfka.zzqpj;
                if (n27 > 0) {
                    zzfka2 = zzfjj9.source.zzdq(n27);
                }
                zzfja10.zza(n25, zzfiy3, zzfka2);
                break;
            }
            case 8: {
                int n28 = n2;
                int n29 = n;
                zzfja zzfja11 = zzfja2;
                zzfjj zzfjj10 = this;
                if (n29 != 4) {
                    throw zzfjh.zzm("TYPE_WINDOW_UPDATE length !=4: %s", new Object[]{n29});
                }
                long l = (long)zzfjj10.source.readInt() & Integer.MAX_VALUE;
                if (l == 0L) {
                    throw zzfjh.zzm("windowSizeIncrement was 0", new Object[]{l});
                }
                zzfja11.windowUpdate(n28, l);
                break;
            }
            default: {
                this.source.zzdv(n);
            }
        }
        return true;
    }

    private final List<zzfjc> zza(int n, short s, byte by, int n2) throws IOException {
        this.zzqoc.length = this.zzqoc.left = n;
        this.zzqoc.padding = s;
        this.zzqoc.flags = by;
        this.zzqoc.streamId = n2;
        this.zzqod.readHeaders();
        return this.zzqod.getAndResetHeaderList();
    }

    private final void zza(zzfja zzfja2, int n) throws IOException {
        this.source.readInt();
        this.source.readByte();
    }

    @Override
    public final void close() throws IOException {
        this.source.close();
    }
}

