/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzfjy;
import com.google.android.gms.internal.zzfjz;
import com.google.android.gms.internal.zzfka;
import com.google.android.gms.internal.zzfkj;
import com.google.android.gms.internal.zzfkk;
import com.google.android.gms.internal.zzfkl;
import com.google.android.gms.internal.zzfkq;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;

public final class zzfjx
implements zzfjy,
zzfjz,
Cloneable {
    private static final byte[] zzqpg = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    zzfkj zzqph;
    long zzbx;

    public final long size() {
        return this.zzbx;
    }

    @Override
    public final zzfjx zzddv() {
        return this;
    }

    @Override
    public final boolean zzdfa() {
        return this.zzbx == 0L;
    }

    @Override
    public final void zzdo(long l) throws EOFException {
        if (this.zzbx < l) {
            throw new EOFException();
        }
    }

    private final zzfjx zza(zzfjx zzfjx2, long l, long l2) {
        zzfkq.checkOffsetAndCount(this.zzbx, 0L, l2);
        if (l2 == 0L) {
            return this;
        }
        zzfjx2.zzbx += l2;
        zzfkj zzfkj2 = this.zzqph;
        while (l >= (long)(zzfkj2.limit - zzfkj2.pos)) {
            l -= (long)(zzfkj2.limit - zzfkj2.pos);
            zzfkj2 = zzfkj2.zzqpt;
        }
        while (l2 > 0L) {
            zzfkj zzfkj3 = new zzfkj(zzfkj2);
            zzfkj3.pos = (int)((long)zzfkj3.pos + l);
            zzfkj3.limit = Math.min(zzfkj3.pos + (int)l2, zzfkj3.limit);
            if (zzfjx2.zzqph == null) {
                zzfkj3.zzqpt = zzfkj3.zzqpu = zzfkj3;
                zzfjx2.zzqph = zzfkj3.zzqpu;
            } else {
                zzfjx2.zzqph.zzqpu.zza(zzfkj3);
            }
            l2 -= (long)(zzfkj3.limit - zzfkj3.pos);
            l = 0L;
            zzfkj2 = zzfkj2.zzqpt;
        }
        return this;
    }

    @Override
    public final byte readByte() {
        if (this.zzbx == 0L) {
            throw new IllegalStateException("size == 0");
        }
        zzfkj zzfkj2 = this.zzqph;
        int n = zzfkj2.pos;
        int n2 = zzfkj2.limit;
        byte by = zzfkj2.data[n++];
        --this.zzbx;
        if (n == n2) {
            this.zzqph = zzfkj2.zzdfh();
            zzfkk.zzb(zzfkj2);
        } else {
            zzfkj2.pos = n;
        }
        return by;
    }

    public final byte zzdp(long l) {
        zzfkq.checkOffsetAndCount(this.zzbx, l, 1L);
        zzfkj zzfkj2 = this.zzqph;
        int n;
        while (l >= (long)(n = zzfkj2.limit - zzfkj2.pos)) {
            l -= (long)n;
            zzfkj2 = zzfkj2.zzqpt;
        }
        return zzfkj2.data[zzfkj2.pos + (int)l];
    }

    @Override
    public final short readShort() {
        if (this.zzbx < 2L) {
            throw new IllegalStateException("size < 2: " + this.zzbx);
        }
        zzfkj zzfkj2 = this.zzqph;
        int n = zzfkj2.limit;
        int n2 = zzfkj2.pos;
        if (n - n2 < 2) {
            return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
        }
        byte[] byArray = zzfkj2.data;
        int n3 = (zzfkj2.data[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.zzbx -= 2L;
        if (n2 == n) {
            this.zzqph = zzfkj2.zzdfh();
            zzfkk.zzb(zzfkj2);
        } else {
            zzfkj2.pos = n2;
        }
        return (short)n3;
    }

    @Override
    public final int readInt() {
        if (this.zzbx < 4L) {
            throw new IllegalStateException("size < 4: " + this.zzbx);
        }
        zzfkj zzfkj2 = this.zzqph;
        int n = zzfkj2.limit;
        int n2 = zzfkj2.pos;
        if (n - n2 < 4) {
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        byte[] byArray = zzfkj2.data;
        int n3 = (zzfkj2.data[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.zzbx -= 4L;
        if (n2 == n) {
            this.zzqph = zzfkj2.zzdfh();
            zzfkk.zzb(zzfkj2);
        } else {
            zzfkj2.pos = n2;
        }
        return n3;
    }

    public final zzfka readByteString() {
        return new zzfka(this.zzdfc());
    }

    @Override
    public final zzfka zzdq(long l) throws EOFException {
        return new zzfka(this.zzdu(l));
    }

    public final String zzdfb() {
        try {
            return this.zza(this.zzbx, zzfkq.UTF_8);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    private final String zzdr(long l) throws EOFException {
        return this.zza(l, zzfkq.UTF_8);
    }

    private final String zza(long l, Charset charset) throws EOFException {
        zzfkq.checkOffsetAndCount(this.zzbx, 0L, l);
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l);
        }
        if (l == 0L) {
            return "";
        }
        zzfkj zzfkj2 = this.zzqph;
        if ((long)zzfkj2.pos + l > (long)zzfkj2.limit) {
            return new String(this.zzdu(l), charset);
        }
        String string = new String(zzfkj2.data, zzfkj2.pos, (int)l, charset);
        zzfkj2.pos = (int)((long)zzfkj2.pos + l);
        this.zzbx -= l;
        if (zzfkj2.pos == zzfkj2.limit) {
            this.zzqph = zzfkj2.zzdfh();
            zzfkk.zzb(zzfkj2);
        }
        return string;
    }

    public final String zzds(long l) throws EOFException {
        if (Long.MAX_VALUE < 0L) {
            throw new IllegalArgumentException("limit < 0: " + Long.MAX_VALUE);
        }
        long l2 = Long.MAX_VALUE == Long.MAX_VALUE ? Long.MAX_VALUE : Long.MIN_VALUE;
        long l3 = this.zza((byte)10, 0L, l2);
        if (l3 != -1L) {
            return this.zzdt(l3);
        }
        if (l2 < this.zzbx && this.zzdp(l2 - 1L) == 13 && this.zzdp(l2) == 10) {
            return this.zzdt(l2);
        }
        zzfjx zzfjx2 = new zzfjx();
        this.zza(zzfjx2, 0L, Math.min(32L, this.zzbx));
        throw new EOFException("\\n not found: limit=" + Math.min(this.zzbx, Long.MAX_VALUE) + " content=" + zzfjx2.readByteString().zzdfe() + '\u2026');
    }

    private final String zzdt(long l) throws EOFException {
        if (l > 0L && this.zzdp(l - 1L) == 13) {
            String string = this.zzdr(l - 1L);
            this.zzdv(2L);
            return string;
        }
        String string = this.zzdr(l);
        this.zzdv(1L);
        return string;
    }

    public final byte[] zzdfc() {
        try {
            return this.zzdu(this.zzbx);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public final byte[] zzdu(long l) throws EOFException {
        zzfkq.checkOffsetAndCount(this.zzbx, 0L, l);
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l);
        }
        byte[] byArray = new byte[(int)l];
        this.readFully(byArray);
        return byArray;
    }

    private final void readFully(byte[] byArray) throws EOFException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            n = this.read(byArray, i, byArray.length - i);
            if (n != -1) continue;
            throw new EOFException();
        }
    }

    public final int read(byte[] byArray, int n, int n2) {
        zzfkq.checkOffsetAndCount(byArray.length, n, n2);
        zzfkj zzfkj2 = this.zzqph;
        if (zzfkj2 == null) {
            return -1;
        }
        int n3 = Math.min(n2, zzfkj2.limit - zzfkj2.pos);
        System.arraycopy(zzfkj2.data, zzfkj2.pos, byArray, n, n3);
        zzfkj2.pos += n3;
        this.zzbx -= (long)n3;
        if (zzfkj2.pos == zzfkj2.limit) {
            this.zzqph = zzfkj2.zzdfh();
            zzfkk.zzb(zzfkj2);
        }
        return n3;
    }

    public final void clear() {
        try {
            this.zzdv(this.zzbx);
            return;
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public final void zzdv(long l) throws EOFException {
        while (l > 0L) {
            if (this.zzqph == null) {
                throw new EOFException();
            }
            int n = (int)Math.min(l, (long)(this.zzqph.limit - this.zzqph.pos));
            this.zzbx -= (long)n;
            l -= (long)n;
            this.zzqph.pos += n;
            if (this.zzqph.pos != this.zzqph.limit) continue;
            zzfkj zzfkj2 = this.zzqph;
            this.zzqph = zzfkj2.zzdfh();
            zzfkk.zzb(zzfkj2);
        }
    }

    public final zzfjx zzb(zzfka zzfka2) {
        if (zzfka2 == null) {
            throw new IllegalArgumentException("byteString == null");
        }
        zzfka2.zza(this);
        return this;
    }

    public final zzfjx zzr(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("source == null");
        }
        zzfkq.checkOffsetAndCount(byArray.length, n, n2);
        int n3 = n + n2;
        while (n < n3) {
            zzfkj zzfkj2 = this.zznd(1);
            int n4 = Math.min(n3 - n, 8192 - zzfkj2.limit);
            System.arraycopy(byArray, n, zzfkj2.data, zzfkj2.limit, n4);
            n += n4;
            zzfkj2.limit += n4;
        }
        this.zzbx += (long)n2;
        return this;
    }

    final zzfkj zznd(int n) {
        if (n <= 0 || n > 8192) {
            throw new IllegalArgumentException();
        }
        if (this.zzqph == null) {
            this.zzqph.zzqpt = this.zzqph.zzqpu = (this.zzqph = zzfkk.zzdfi());
            return this.zzqph.zzqpu;
        }
        zzfkj zzfkj2 = this.zzqph.zzqpu;
        if (zzfkj2.limit + n > 8192 || !zzfkj2.zzqps) {
            zzfkj2 = zzfkj2.zza(zzfkk.zzdfi());
        }
        return zzfkj2;
    }

    @Override
    public final void write(zzfjx zzfjx2, long l) {
        if (zzfjx2 == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (zzfjx2 == this) {
            throw new IllegalArgumentException("source == this");
        }
        zzfkq.checkOffsetAndCount(zzfjx2.zzbx, 0L, l);
        while (l > 0L) {
            zzfkj zzfkj2;
            int n;
            zzfkj zzfkj3;
            if (l < (long)(zzfjx2.zzqph.limit - zzfjx2.zzqph.pos)) {
                zzfkj zzfkj4;
                zzfkj3 = this.zzqph != null ? this.zzqph.zzqpu : null;
                if (zzfkj3 != null && zzfkj3.zzqps && l + (long)zzfkj3.limit - (long)(zzfkj3.zzqpr ? 0 : zzfkj3.pos) <= 8192L) {
                    zzfjx2.zzqph.zza(zzfkj3, (int)l);
                    zzfjx2.zzbx -= l;
                    this.zzbx += l;
                    return;
                }
                n = (int)l;
                zzfkj2 = zzfjx2.zzqph;
                if (n <= 0 || n > zzfkj2.limit - zzfkj2.pos) {
                    throw new IllegalArgumentException();
                }
                if (n >= 1024) {
                    zzfkj4 = new zzfkj(zzfkj2);
                } else {
                    zzfkj4 = zzfkk.zzdfi();
                    System.arraycopy(zzfkj2.data, zzfkj2.pos, zzfkj4.data, 0, n);
                }
                zzfkj4.limit = zzfkj4.pos + n;
                zzfkj2.pos += n;
                zzfkj2.zzqpu.zza(zzfkj4);
                zzfjx2.zzqph = zzfkj4;
            }
            zzfkj3 = zzfjx2.zzqph;
            long l2 = zzfkj3.limit - zzfkj3.pos;
            zzfjx2.zzqph = zzfkj3.zzdfh();
            if (this.zzqph == null) {
                this.zzqph.zzqpt = this.zzqph.zzqpu = (this.zzqph = zzfkj3);
            } else {
                int n2;
                zzfkj2 = this.zzqph.zzqpu.zza(zzfkj3);
                if (zzfkj2.zzqpu == zzfkj2) {
                    throw new IllegalStateException();
                }
                if (zzfkj2.zzqpu.zzqps && (n = zzfkj2.limit - zzfkj2.pos) <= (n2 = 8192 - zzfkj2.zzqpu.limit + (zzfkj2.zzqpu.zzqpr ? 0 : zzfkj2.zzqpu.pos))) {
                    zzfkj2.zza(zzfkj2.zzqpu, n);
                    zzfkj2.zzdfh();
                    zzfkk.zzb(zzfkj2);
                }
            }
            zzfjx2.zzbx -= l2;
            this.zzbx += l2;
            l -= l2;
        }
    }

    @Override
    public final long read(zzfjx zzfjx2, long l) {
        if (zzfjx2 == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        if (this.zzbx == 0L) {
            return -1L;
        }
        if (l > this.zzbx) {
            l = this.zzbx;
        }
        zzfjx2.write(this, l);
        return l;
    }

    private final long zza(byte by, long l, long l2) {
        long l3;
        if (0L < 0L || l2 < 0L) {
            throw new IllegalArgumentException(String.format("size=%s fromIndex=%s toIndex=%s", this.zzbx, 0L, l2));
        }
        if (l2 > this.zzbx) {
            l2 = this.zzbx;
        }
        if (0L == l2) {
            return -1L;
        }
        zzfkj zzfkj2 = this.zzqph;
        if (zzfkj2 == null) {
            return -1L;
        }
        if (this.zzbx < 0L) {
            for (l3 = this.zzbx; l3 > 0L; l3 -= (long)(zzfkj2.limit - zzfkj2.pos)) {
                zzfkj2 = zzfkj2.zzqpu;
            }
        } else {
            long l4;
            l3 = 0L;
            while ((l4 = l3 + (long)(zzfkj2.limit - zzfkj2.pos)) < 0L) {
                zzfkj2 = zzfkj2.zzqpt;
                l3 = l4;
            }
        }
        while (l3 < l2) {
            byte[] byArray = zzfkj2.data;
            int n = (int)Math.min((long)zzfkj2.limit, (long)zzfkj2.pos + l2 - l3);
            for (int i = (int)((long)zzfkj2.pos + l - l3); i < n; ++i) {
                if (byArray[i] != 10) continue;
                return (long)(i - zzfkj2.pos) + l3;
            }
            l = l3 += (long)(zzfkj2.limit - zzfkj2.pos);
            zzfkj2 = zzfkj2.zzqpt;
        }
        return -1L;
    }

    @Override
    public final void flush() {
    }

    @Override
    public final void close() {
    }

    public final boolean equals(Object object) {
        long l;
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfjx)) {
            return false;
        }
        zzfjx zzfjx2 = (zzfjx)object;
        if (this.zzbx != zzfjx2.zzbx) {
            return false;
        }
        if (this.zzbx == 0L) {
            return true;
        }
        zzfkj zzfkj2 = this.zzqph;
        zzfkj zzfkj3 = zzfjx2.zzqph;
        int n = zzfkj2.pos;
        int n2 = zzfkj3.pos;
        for (long i = 0L; i < this.zzbx; i += l) {
            l = Math.min(zzfkj2.limit - n, zzfkj3.limit - n2);
            int n3 = 0;
            while ((long)n3 < l) {
                if (zzfkj2.data[n++] != zzfkj3.data[n2++]) {
                    return false;
                }
                ++n3;
            }
            if (n == zzfkj2.limit) {
                zzfkj2 = zzfkj2.zzqpt;
                n = zzfkj2.pos;
            }
            if (n2 != zzfkj3.limit) continue;
            zzfkj3 = zzfkj3.zzqpt;
            n2 = zzfkj3.pos;
        }
        return true;
    }

    public final int hashCode() {
        zzfkj zzfkj2 = this.zzqph;
        if (zzfkj2 == null) {
            return 0;
        }
        int n = 1;
        do {
            int n2 = zzfkj2.limit;
            for (int i = zzfkj2.pos; i < n2; ++i) {
                n = n * 31 + zzfkj2.data[i];
            }
        } while ((zzfkj2 = zzfkj2.zzqpt) != this.zzqph);
        return n;
    }

    public final String toString() {
        zzfjx zzfjx2 = this;
        if (zzfjx2.zzbx > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size > Integer.MAX_VALUE: " + zzfjx2.zzbx);
        }
        int n = (int)zzfjx2.zzbx;
        zzfjx zzfjx3 = zzfjx2;
        return (n == 0 ? zzfka.zzqpj : new zzfkl(zzfjx3, n)).toString();
    }

    public final /* synthetic */ Object clone() throws CloneNotSupportedException {
        zzfjx zzfjx2 = this;
        zzfjx zzfjx3 = new zzfjx();
        if (zzfjx2.zzbx == 0L) {
            return zzfjx3;
        }
        zzfjx3.zzqph.zzqpt = zzfjx3.zzqph.zzqpu = (zzfjx3.zzqph = new zzfkj(zzfjx2.zzqph));
        zzfkj zzfkj2 = zzfjx2.zzqph.zzqpt;
        while (zzfkj2 != zzfjx2.zzqph) {
            zzfjx3.zzqph.zzqpu.zza(new zzfkj(zzfkj2));
            zzfkj2 = zzfkj2.zzqpt;
        }
        zzfjx3.zzbx = zzfjx2.zzbx;
        return zzfjx3;
    }

    @Override
    public final /* synthetic */ zzfjy zzne(int n) throws IOException {
        int n2 = n;
        zzfjx zzfjx2 = this;
        zzfkj zzfkj2 = zzfjx2.zznd(4);
        byte[] byArray = zzfkj2.data;
        int n3 = zzfkj2.limit;
        byArray[n3++] = n2 >> 24;
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        zzfkj2.limit = n3;
        zzfjx2.zzbx += 4L;
        return zzfjx2;
    }

    @Override
    public final /* synthetic */ zzfjy zznf(int n) throws IOException {
        int n2 = n;
        zzfjx zzfjx2 = this;
        zzfkj zzfkj2 = zzfjx2.zznd(2);
        byte[] byArray = zzfkj2.data;
        int n3 = zzfkj2.limit;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        zzfkj2.limit = n3;
        zzfjx2.zzbx += 2L;
        return zzfjx2;
    }

    @Override
    public final /* synthetic */ zzfjy zzng(int n) throws IOException {
        int n2 = n;
        zzfjx zzfjx2 = this;
        zzfkj zzfkj2 = zzfjx2.zznd(1);
        zzfkj2.data[zzfkj2.limit++] = (byte)n2;
        ++zzfjx2.zzbx;
        return zzfjx2;
    }

    @Override
    public final /* synthetic */ zzfjy zzuc(String string) throws IOException {
        String string2 = string;
        int n = string2.length();
        String string3 = string2;
        zzfjx zzfjx2 = this;
        if (string3 == null) {
            throw new IllegalArgumentException("string == null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + n + " < 0");
        }
        if (n > string3.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + n + " > " + string3.length());
        }
        int n2 = 0;
        while (n2 < n) {
            char c;
            zzfkj zzfkj2;
            zzfjx zzfjx3;
            int n3;
            int n4;
            char c2 = string3.charAt(n2);
            if (c2 < '\u0080') {
                zzfkj zzfkj3 = zzfjx2.zznd(1);
                byte[] byArray = zzfkj3.data;
                int n5 = zzfkj3.limit - n2;
                int n6 = Math.min(n, 8192 - n5);
                byArray[n5 + n2++] = (byte)c2;
                while (n2 < n6 && (c2 = string3.charAt(n2)) < '\u0080') {
                    byArray[n5 + n2++] = (byte)c2;
                }
                int n7 = n2 + n5 - zzfkj3.limit;
                zzfkj3.limit += n7;
                zzfjx2.zzbx += (long)n7;
                continue;
            }
            if (c2 < '\u0800') {
                n3 = n4 = c2 >> 6 | 0xC0;
                zzfjx3 = zzfjx2;
                zzfkj2 = zzfjx3.zznd(1);
                zzfkj2.data[zzfkj2.limit++] = (byte)n3;
                ++zzfjx3.zzbx;
                n3 = n4 = c2 & 0x3F | 0x80;
                zzfjx3 = zzfjx2;
                zzfkj2 = zzfjx3.zznd(1);
                zzfkj2.data[zzfkj2.limit++] = (byte)n3;
                ++zzfjx3.zzbx;
                ++n2;
                continue;
            }
            if (c2 < '\ud800' || c2 > '\udfff') {
                n3 = n4 = c2 >> 12 | 0xE0;
                zzfjx3 = zzfjx2;
                zzfkj2 = zzfjx3.zznd(1);
                zzfkj2.data[zzfkj2.limit++] = (byte)n3;
                ++zzfjx3.zzbx;
                n3 = n4 = c2 >> 6 & 0x3F | 0x80;
                zzfjx3 = zzfjx2;
                zzfkj2 = zzfjx3.zznd(1);
                zzfkj2.data[zzfkj2.limit++] = (byte)n3;
                ++zzfjx3.zzbx;
                n3 = n4 = c2 & 0x3F | 0x80;
                zzfjx3 = zzfjx2;
                zzfkj2 = zzfjx3.zznd(1);
                zzfkj2.data[zzfkj2.limit++] = (byte)n3;
                ++zzfjx3.zzbx;
                ++n2;
                continue;
            }
            char c3 = c = n2 + 1 < n ? string3.charAt(n2 + 1) : (char)'\u0000';
            if (c2 > '\udbff' || c < '\udc00' || c > '\udfff') {
                zzfjx3 = zzfjx2;
                zzfkj2 = zzfjx3.zznd(1);
                zzfkj2.data[zzfkj2.limit++] = 63;
                ++zzfjx3.zzbx;
                ++n2;
                continue;
            }
            int n8 = 65536 + ((c2 & 0xFFFF27FF) << 10 | c & 0xFFFF23FF);
            n3 = n4 = n8 >> 18 | 0xF0;
            zzfjx3 = zzfjx2;
            zzfkj2 = zzfjx3.zznd(1);
            zzfkj2.data[zzfkj2.limit++] = (byte)n3;
            ++zzfjx3.zzbx;
            n3 = n4 = n8 >> 12 & 0x3F | 0x80;
            zzfjx3 = zzfjx2;
            zzfkj2 = zzfjx3.zznd(1);
            zzfkj2.data[zzfkj2.limit++] = (byte)n3;
            ++zzfjx3.zzbx;
            n3 = n4 = n8 >> 6 & 0x3F | 0x80;
            zzfjx3 = zzfjx2;
            zzfkj2 = zzfjx3.zznd(1);
            zzfkj2.data[zzfkj2.limit++] = (byte)n3;
            ++zzfjx3.zzbx;
            n3 = n4 = n8 & 0x3F | 0x80;
            zzfjx3 = zzfjx2;
            zzfkj2 = zzfjx3.zznd(1);
            zzfkj2.data[zzfkj2.limit++] = (byte)n3;
            ++zzfjx3.zzbx;
            n2 += 2;
        }
        return zzfjx2;
    }

    @Override
    public final /* synthetic */ zzfjy zzbo(byte[] byArray) throws IOException {
        byte[] byArray2 = byArray;
        zzfjx zzfjx2 = this;
        if (byArray2 == null) {
            throw new IllegalArgumentException("source == null");
        }
        return zzfjx2.zzr(byArray2, 0, byArray2.length);
    }
}

