/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzeud;
import com.google.android.gms.internal.zzfdh;

public class Blob
implements Comparable<Blob> {
    private final zzfdh zznbk;

    private Blob(zzfdh zzfdh2) {
        this.zznbk = zzfdh2;
    }

    @Keep
    @NonNull
    public static Blob fromBytes(@NonNull byte[] byArray) {
        zzbq.checkNotNull((Object)byArray, (Object)"Provided bytes array must not be null.");
        return new Blob(zzfdh.zzay((byte[])byArray));
    }

    @NonNull
    public static Blob zzab(@NonNull zzfdh zzfdh2) {
        zzbq.checkNotNull((Object)zzfdh2, (Object)"Provided ByteString must not be null.");
        return new Blob(zzfdh2);
    }

    @Keep
    @NonNull
    public byte[] toBytes() {
        return this.zznbk.toByteArray();
    }

    @NonNull
    public String toString() {
        String string = zzeud.zzag(this.zznbk);
        return new StringBuilder(15 + String.valueOf(string).length()).append("Blob { bytes=").append(string).append(" }").toString();
    }

    @NonNull
    public zzfdh toByteString() {
        return this.zznbk;
    }

    @NonNull
    public boolean equals(@Nullable Object object) {
        return object instanceof Blob && this.zznbk.equals((Object)((Blob)object).zznbk);
    }

    public int hashCode() {
        return this.zznbk.hashCode();
    }

    @Override
    public int compareTo(@NonNull Blob blob) {
        int n = Math.min(this.zznbk.size(), blob.zznbk.size());
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.zznbk.zzkd(i) & 0xFF;
            if (n3 < (n2 = blob.zznbk.zzkd(i) & 0xFF)) {
                return -1;
            }
            if (n3 <= n2) continue;
            return 1;
        }
        return zzeud.zzw(this.zznbk.size(), blob.zznbk.size());
    }
}

