/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.android.gms.internal.zzelj;
import com.google.android.gms.internal.zzelk;
import com.google.android.gms.internal.zzemy;
import com.google.android.gms.internal.zzeps;
import com.google.android.gms.internal.zzepx;
import com.google.android.gms.internal.zzete;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import java.util.ArrayList;
import java.util.List;

public class DocumentChange {
    private final Type zznbm;
    private final DocumentSnapshot zznbn;
    private final int zznbo;
    private final int zznbp;

    private DocumentChange(DocumentSnapshot documentSnapshot, Type type, int n, int n2) {
        this.zznbm = type;
        this.zznbn = documentSnapshot;
        this.zznbo = n;
        this.zznbp = n2;
    }

    @NonNull
    public Type getType() {
        return this.zznbm;
    }

    @NonNull
    public DocumentSnapshot getDocument() {
        return this.zznbn;
    }

    public int getOldIndex() {
        return this.zznbo;
    }

    public int getNewIndex() {
        return this.zznbp;
    }

    static List<DocumentChange> zza(FirebaseFirestore firebaseFirestore, zzemy zzemy2) {
        ArrayList<DocumentChange> arrayList = new ArrayList<DocumentChange>();
        if (zzemy2.zzcbl().isEmpty()) {
            int n = 0;
            zzeps zzeps2 = null;
            for (zzelj zzelj2 : zzemy2.zzbxi()) {
                zzeps zzeps3 = zzelj2.zzbzs();
                DocumentSnapshot documentSnapshot = DocumentSnapshot.zza(firebaseFirestore, zzeps3, zzemy2.isFromCache());
                zzete.zzc(zzelj2.zzcah() == zzelk.zzneq, "Invalid added event for first snapshot", new Object[0]);
                zzete.zzc(zzeps2 == null || zzemy2.zzcax().comparator().compare(zzeps2, zzeps3) < 0, "Got added events in wrong order", new Object[0]);
                arrayList.add(new DocumentChange(documentSnapshot, Type.ADDED, -1, n++));
                zzeps2 = zzeps3;
            }
        } else {
            zzepx zzepx2 = zzemy2.zzcbl();
            for (zzelj zzelj3 : zzemy2.zzbxi()) {
                int n;
                int n2;
                Type type;
                zzeps zzeps4 = zzelj3.zzbzs();
                DocumentSnapshot documentSnapshot = DocumentSnapshot.zza(firebaseFirestore, zzeps4, zzemy2.isFromCache());
                zzelj zzelj4 = zzelj3;
                switch (zzelj4.zzcah()) {
                    case zzneq: {
                        type = Type.ADDED;
                        break;
                    }
                    case zznes: 
                    case zzner: {
                        type = Type.MODIFIED;
                        break;
                    }
                    case zznep: {
                        type = Type.REMOVED;
                        break;
                    }
                    default: {
                        String string = String.valueOf((Object)zzelj4.zzcah());
                        throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Unknown view change type: ").append(string).toString());
                    }
                }
                Type type2 = type;
                if (type != Type.ADDED) {
                    n2 = zzepx2.zzl(zzeps4.zzbzr());
                    zzete.zzc(n2 >= 0, "Index for document not found", new Object[0]);
                    zzepx2 = zzepx2.zzm(zzeps4.zzbzr());
                } else {
                    n2 = -1;
                }
                if (type2 != Type.REMOVED) {
                    n = (zzepx2 = zzepx2.zzc(zzeps4)).zzl(zzeps4.zzbzr());
                    zzete.zzc(n >= 0, "Index for document not found", new Object[0]);
                } else {
                    n = -1;
                }
                arrayList.add(new DocumentChange(documentSnapshot, type2, n2, n));
            }
        }
        return arrayList;
    }

    public static enum Type {
        ADDED,
        MODIFIED,
        REMOVED;

    }
}

