/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzepr;
import com.google.android.gms.internal.zzeps;
import com.google.android.gms.internal.zzepv;
import com.google.android.gms.internal.zzeqs;
import com.google.android.gms.internal.zzeqw;
import com.google.android.gms.internal.zzerb;
import com.google.android.gms.internal.zzerc;
import com.google.android.gms.internal.zzetm;
import com.google.android.gms.internal.zzetz;
import com.google.firebase.firestore.Blob;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.GeoPoint;
import com.google.firebase.firestore.SnapshotMetadata;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DocumentSnapshot {
    private final FirebaseFirestore zznbu;
    private final zzepv zznbt;
    private final zzeps zznby;
    private final SnapshotMetadata zznbz;

    private DocumentSnapshot(FirebaseFirestore firebaseFirestore, zzepv zzepv2, zzeps zzeps2, boolean bl) {
        this.zznbu = (FirebaseFirestore)zzbq.checkNotNull((Object)firebaseFirestore);
        this.zznbt = (zzepv)zzbq.checkNotNull((Object)zzepv2);
        this.zznby = zzeps2;
        boolean bl2 = this.zznby != null && this.zznby.zzccs();
        this.zznbz = new SnapshotMetadata(bl2, bl);
    }

    static DocumentSnapshot zza(FirebaseFirestore firebaseFirestore, zzeps zzeps2, boolean bl) {
        return new DocumentSnapshot(firebaseFirestore, zzeps2.zzbzr(), zzeps2, bl);
    }

    static DocumentSnapshot zza(FirebaseFirestore firebaseFirestore, zzepv zzepv2, boolean bl) {
        return new DocumentSnapshot(firebaseFirestore, zzepv2, null, bl);
    }

    @NonNull
    public String getId() {
        return this.zznbt.zzcan().zzccn();
    }

    @NonNull
    public SnapshotMetadata getMetadata() {
        return this.zznbz;
    }

    public boolean exists() {
        return this.zznby != null;
    }

    final zzeps zzbzs() {
        return this.zznby;
    }

    private final zzeps zzbzt() {
        if (this.zznby == null) {
            throw new IllegalStateException("This document doesn't exist. Use DocumentSnapshot.exists() to check whether the document exists before accessing its fields.");
        }
        return this.zznby;
    }

    @NonNull
    public Map<String, Object> getData() {
        zzeps zzeps2 = this.zzbzt();
        return this.zza(zzeps2.zzccr());
    }

    @NonNull
    public <T> T toObject(@NonNull Class<T> clazz) {
        zzbq.checkNotNull(clazz, (Object)"Provided POJO type must not be null.");
        return zzetm.zza(this.getData(), clazz);
    }

    public boolean contains(@NonNull String string) {
        return this.contains(FieldPath.zzpv(string));
    }

    public boolean contains(@NonNull FieldPath fieldPath) {
        zzbq.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        return this.zzbzt().zzb(fieldPath.zzbzu()) != null;
    }

    public Object get(@NonNull String string) {
        return this.get(FieldPath.zzpv(string));
    }

    public Object get(@NonNull FieldPath fieldPath) {
        zzbq.checkNotNull((Object)fieldPath, (Object)"Provided field path must not be null.");
        zzeqw zzeqw2 = this.zzbzt().zzb(fieldPath.zzbzu());
        if (zzeqw2 == null) {
            return null;
        }
        return this.zza(zzeqw2);
    }

    public Boolean getBoolean(@NonNull String string) {
        return this.zzd(string, Boolean.class);
    }

    public Double getDouble(@NonNull String string) {
        Number number = this.zzd(string, Number.class);
        if (number != null) {
            return number.doubleValue();
        }
        return null;
    }

    public String getString(@NonNull String string) {
        return this.zzd(string, String.class);
    }

    public Long getLong(@NonNull String string) {
        Number number = this.zzd(string, Number.class);
        if (number != null) {
            return number.longValue();
        }
        return null;
    }

    public Date getDate(@NonNull String string) {
        return this.zzd(string, Date.class);
    }

    public Blob getBlob(@NonNull String string) {
        return this.zzd(string, Blob.class);
    }

    public GeoPoint getGeoPoint(@NonNull String string) {
        return this.zzd(string, GeoPoint.class);
    }

    public DocumentReference getDocumentReference(@NonNull String string) {
        return this.zzd(string, DocumentReference.class);
    }

    @NonNull
    public DocumentReference getReference() {
        return new DocumentReference(this.zznbt, this.zznbu);
    }

    private final <T> T zzd(String string, Class<T> clazz) {
        zzbq.checkNotNull((Object)string, (Object)"Provided field must not be null.");
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        if (!clazz.isInstance(object)) {
            String string2 = clazz.getName();
            throw new RuntimeException(new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Field '").append(string).append("' is not a ").append(string2).toString());
        }
        return clazz.cast(object);
    }

    private final Object zza(zzeqw zzeqw2) {
        if (zzeqw2 instanceof zzerb) {
            return this.zza((zzerb)zzeqw2);
        }
        if (zzeqw2 instanceof zzeqs) {
            zzeqs zzeqs2 = (zzeqs)zzeqw2;
            DocumentSnapshot documentSnapshot = this;
            ArrayList<Object> arrayList = new ArrayList<Object>(zzeqs2.zzceb().size());
            for (zzeqw zzeqw3 : zzeqs2.zzceb()) {
                arrayList.add(documentSnapshot.zza(zzeqw3));
            }
            return arrayList;
        }
        if (zzeqw2 instanceof zzerc) {
            zzepr zzepr2;
            zzepv zzepv2 = (zzepv)((zzeqw)((zzerc)zzeqw2)).value();
            zzepr zzepr3 = ((zzerc)zzeqw2).zzbzx();
            if (!zzepr3.equals(zzepr2 = this.zznbu.zzbzx())) {
                zzetz.zze("DocumentSnapshot", String.format("Document %s contains a document reference within a different database (%s/%s) which is not supported. It will be treated as a reference in the current database (%s/%s) instead.", zzepv2.zzcan(), zzepr3.getProjectId(), zzepr3.zzccp(), zzepr2.getProjectId(), zzepr2.zzccp()), new Object[0]);
            }
            return new DocumentReference(zzepv2, this.zznbu);
        }
        return zzeqw2.value();
    }

    private final Map<String, Object> zza(zzerb zzerb2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : zzerb2.zzceg()) {
            hashMap.put((String)entry.getKey(), this.zza((zzeqw)entry.getValue()));
        }
        return hashMap;
    }
}

