/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzelc;
import com.google.android.gms.internal.zzeld;
import com.google.android.gms.internal.zzeli;
import com.google.android.gms.internal.zzelq;
import com.google.android.gms.internal.zzemq;
import com.google.android.gms.internal.zzepr;
import com.google.android.gms.internal.zzeqc;
import com.google.android.gms.internal.zzetf;
import com.google.android.gms.internal.zzetz;
import com.google.android.gms.internal.zzeub;
import com.google.android.gms.security.ProviderInstaller;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.WriteBatch;
import com.google.firebase.firestore.zze;
import com.google.firebase.firestore.zzk;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class FirebaseFirestore {
    private static final Map<String, FirebaseFirestore> zzncf = new HashMap<String, FirebaseFirestore>();
    private final Context zzaif;
    private final zzepr zzncg;
    private final String zzmni;
    private final zzelc zznch;
    private final zzetf zznci;
    private final FirebaseApp zzmgj;
    private FirebaseFirestoreSettings zzncj;
    private zzelq zznck;
    private zzk zzncl;

    @NonNull
    public static FirebaseFirestore getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new IllegalStateException("You must call FirebaseApp.initializeApp first.");
        }
        return FirebaseFirestore.zze(firebaseApp, "(default)");
    }

    @NonNull
    public static FirebaseFirestore getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseFirestore.zze(firebaseApp, "(default)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static FirebaseFirestore zze(@NonNull FirebaseApp firebaseApp, @NonNull String string) {
        zzbq.checkNotNull((Object)firebaseApp, (Object)"Provided FirebaseApp must not be null.");
        zzbq.checkNotNull((Object)string, (Object)"Provided database must not be null.");
        Object object = firebaseApp.getName();
        String string2 = new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append("|").append(string).toString();
        object = zzncf;
        synchronized (object) {
            FirebaseFirestore firebaseFirestore = zzncf.get(string2);
            if (firebaseFirestore == null) {
                String string3 = firebaseApp.getOptions().getProjectId();
                if (string3 == null) {
                    throw new IllegalArgumentException("FirebaseOptions.getProjectId() cannot be null");
                }
                zzepr zzepr2 = zzepr.zzbk(string3, string);
                zzetf zzetf2 = new zzetf();
                zzeld zzeld2 = new zzeld(firebaseApp);
                try {
                    ProviderInstaller.installIfNeeded((Context)firebaseApp.getApplicationContext());
                }
                catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException throwable) {
                    zzetz.zze("Firestore", "Failed to update ssl context", new Object[0]);
                }
                String string4 = firebaseApp.getName();
                firebaseFirestore = new FirebaseFirestore(firebaseApp.getApplicationContext(), zzepr2, string4, zzeld2, zzetf2, firebaseApp);
                zzncf.put(string2, firebaseFirestore);
            }
            return firebaseFirestore;
        }
    }

    private FirebaseFirestore(Context context, zzepr zzepr2, String string, zzelc zzelc2, zzetf zzetf2, @Nullable FirebaseApp firebaseApp) {
        this.zzaif = (Context)zzbq.checkNotNull((Object)context);
        this.zzncg = (zzepr)zzbq.checkNotNull((Object)((zzepr)zzbq.checkNotNull((Object)zzepr2)));
        this.zzncl = new zzk(zzepr2);
        this.zzmni = (String)zzbq.checkNotNull((Object)string);
        this.zznch = (zzelc)zzbq.checkNotNull((Object)zzelc2);
        this.zznci = (zzetf)zzbq.checkNotNull((Object)zzetf2);
        this.zzmgj = firebaseApp;
        this.zzncj = new FirebaseFirestoreSettings.Builder().build();
    }

    @NonNull
    public FirebaseFirestoreSettings getFirestoreSettings() {
        return this.zzncj;
    }

    public void setFirestoreSettings(@NonNull FirebaseFirestoreSettings firebaseFirestoreSettings) {
        zzbq.checkNotNull((Object)firebaseFirestoreSettings, (Object)"Provided settings must not be null.");
        if (this.zznck != null && !this.zzncj.equals(firebaseFirestoreSettings)) {
            throw new IllegalStateException("FirebaseFirestore has already been started and its settings can no longer be changed. You can only call setFirestoreSettings() before calling any other methods on a FirebaseFirestore object.");
        }
        this.zzncj = firebaseFirestoreSettings;
    }

    private final void zzbzv() {
        if (this.zznck == null) {
            zzeli zzeli2 = new zzeli(this.zzncg, this.zzmni, this.zzncj.getHost(), this.zzncj.isSslEnabled());
            this.zznck = new zzelq(this.zzaif, zzeli2, this.zzncj.isPersistenceEnabled(), this.zznch, this.zznci);
        }
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zzmgj;
    }

    @NonNull
    public CollectionReference collection(@NonNull String string) {
        zzbq.checkNotNull((Object)string, (Object)"Provided collection path must not be null.");
        this.zzbzv();
        return new CollectionReference(zzeqc.zzqi(string), this);
    }

    @NonNull
    public DocumentReference document(@NonNull String string) {
        zzbq.checkNotNull((Object)string, (Object)"Provided document path must not be null.");
        this.zzbzv();
        return DocumentReference.zza(zzeqc.zzqi(string), this);
    }

    @NonNull
    public <TResult> Task<TResult> runTransaction(@NonNull Transaction.Function<TResult> function) {
        zzbq.checkNotNull(function, (Object)"Provided transaction update function must not be null.");
        Executor executor = zzemq.zzcbf();
        Transaction.Function<TResult> function2 = function;
        FirebaseFirestore firebaseFirestore = this;
        firebaseFirestore.zzbzv();
        zze zze2 = new zze(firebaseFirestore, executor, function2);
        return firebaseFirestore.zznck.zza(zze2, 5);
    }

    @NonNull
    public WriteBatch batch() {
        this.zzbzv();
        return new WriteBatch(this);
    }

    public static void setLoggingEnabled(boolean bl) {
        if (bl) {
            zzetz.zzhs(zzeub.zznte);
            return;
        }
        zzetz.zzhs(zzeub.zzntf);
    }

    final zzelq zzbzw() {
        return this.zznck;
    }

    final zzepr zzbzx() {
        return this.zzncg;
    }

    final zzk zzbzy() {
        return this.zzncl;
    }

    final void zza(DocumentReference documentReference) {
        zzbq.checkNotNull((Object)documentReference, (Object)"Provided DocumentReference must not be null.");
        if (documentReference.getFirestore() != this) {
            throw new IllegalArgumentException("Provided document reference is from a different Firestore instance.");
        }
    }
}

