/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzemy;
import com.google.android.gms.internal.zzeps;
import com.google.firebase.firestore.DocumentChange;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.Query;
import com.google.firebase.firestore.SnapshotMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class QuerySnapshot
implements Iterable<DocumentSnapshot> {
    private final Query zznda;
    private final zzemy zzndb;
    private final FirebaseFirestore zznbu;
    private List<DocumentChange> zzndc;
    private SnapshotMetadata zznbz;

    QuerySnapshot(Query query, zzemy zzemy2, FirebaseFirestore firebaseFirestore) {
        this.zznda = (Query)zzbq.checkNotNull((Object)query);
        this.zzndb = (zzemy)zzbq.checkNotNull((Object)zzemy2);
        this.zznbu = (FirebaseFirestore)zzbq.checkNotNull((Object)firebaseFirestore);
        this.zznbz = new SnapshotMetadata(zzemy2.hasPendingWrites(), zzemy2.isFromCache());
    }

    @NonNull
    public Query getQuery() {
        return this.zznda;
    }

    @NonNull
    public SnapshotMetadata getMetadata() {
        return this.zznbz;
    }

    @NonNull
    public List<DocumentChange> getDocumentChanges() {
        if (this.zzndc == null) {
            this.zzndc = Collections.unmodifiableList(DocumentChange.zza(this.zznbu, this.zzndb));
        }
        return this.zzndc;
    }

    @NonNull
    public List<DocumentSnapshot> getDocuments() {
        ArrayList<DocumentSnapshot> arrayList = new ArrayList<DocumentSnapshot>(this.zzndb.zzcbk().size());
        for (zzeps zzeps2 : this.zzndb.zzcbk()) {
            arrayList.add(this.zza(zzeps2));
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.zzndb.zzcbk().isEmpty();
    }

    public int size() {
        return this.zzndb.zzcbk().size();
    }

    @Override
    @NonNull
    public Iterator<DocumentSnapshot> iterator() {
        return new zza(this, this.zzndb.zzcbk().iterator());
    }

    @NonNull
    public <T> List<T> toObjects(@NonNull Class<T> clazz) {
        zzbq.checkNotNull(clazz, (Object)"Provided POJO type must not be null.");
        ArrayList<T> arrayList = new ArrayList<T>();
        for (DocumentSnapshot documentSnapshot : this) {
            arrayList.add(documentSnapshot.toObject(clazz));
        }
        return arrayList;
    }

    private final DocumentSnapshot zza(zzeps zzeps2) {
        return DocumentSnapshot.zza(this.zznbu, zzeps2, this.zzndb.isFromCache());
    }

    final class zza
    implements Iterator<DocumentSnapshot> {
        private final Iterator<zzeps> zzndd;
        private /* synthetic */ QuerySnapshot zznde;

        zza(QuerySnapshot querySnapshot, Iterator<zzeps> iterator) {
            this.zznde = querySnapshot;
            this.zzndd = iterator;
        }

        @Override
        public final boolean hasNext() {
            return this.zzndd.hasNext();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("QuerySnapshot does not support remove().");
        }

        @Override
        public final /* synthetic */ Object next() {
            zza zza2 = this;
            return zza2.zznde.zza(zza2.zzndd.next());
        }
    }
}

