/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.security.ProviderInstaller;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestoreSettings;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.firestore.UserDataConverter;
import com.google.firebase.firestore.WriteBatch;
import com.google.firebase.firestore.a.zza;
import com.google.firebase.firestore.a.zzb;
import com.google.firebase.firestore.b.zzaf;
import com.google.firebase.firestore.b.zzf;
import com.google.firebase.firestore.d.zzl;
import com.google.firebase.firestore.g.zzq;
import com.google.firebase.firestore.zze;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class FirebaseFirestore {
    private final Context zza;
    private final com.google.firebase.firestore.d.zzb zzb;
    private final String zzc;
    private final zza zzd;
    private final com.google.firebase.firestore.g.zza zze;
    private final FirebaseApp zzf;
    private FirebaseFirestoreSettings zzg;
    private zzf zzh;
    private UserDataConverter zzi;

    @NonNull
    public static FirebaseFirestore getInstance() {
        FirebaseApp firebaseApp = FirebaseApp.getInstance();
        if (firebaseApp == null) {
            throw new IllegalStateException("You must call FirebaseApp.initializeApp first.");
        }
        return FirebaseFirestore.zza(firebaseApp, "(default)");
    }

    @NonNull
    public static FirebaseFirestore getInstance(@NonNull FirebaseApp app) {
        return FirebaseFirestore.zza(app, "(default)");
    }

    @NonNull
    private static FirebaseFirestore zza(@NonNull FirebaseApp object, @NonNull String string) {
        Preconditions.checkNotNull((Object)object, (Object)"Provided FirebaseApp must not be null.");
        object = (zze)object.get(zze.class);
        Preconditions.checkNotNull((Object)object, (Object)"Firestore component is not present.");
        return ((zze)object).zza(string);
    }

    @NonNull
    static FirebaseFirestore zza(@NonNull FirebaseApp firebaseApp, @NonNull Context context, @NonNull String object) {
        Object object2 = firebaseApp.getOptions().getProjectId();
        if (object2 == null) {
            throw new IllegalArgumentException("FirebaseOptions.getProjectId() cannot be null");
        }
        object = com.google.firebase.firestore.d.zzb.zza((String)object2, (String)object);
        object2 = new com.google.firebase.firestore.g.zza();
        zzb zzb2 = new zzb(firebaseApp);
        ((com.google.firebase.firestore.g.zza)object2).zza(new Runnable(context){
            private /* synthetic */ Context zza;
            {
                this.zza = context;
            }

            @Override
            public final void run() {
                try {
                    ProviderInstaller.installIfNeeded((Context)this.zza);
                    return;
                }
                catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException throwable) {
                    zzq.zza("Firestore", "Failed to update ssl context", new Object[0]);
                    return;
                }
            }
        });
        String string = firebaseApp.getName();
        return new FirebaseFirestore(context, (com.google.firebase.firestore.d.zzb)object, string, zzb2, (com.google.firebase.firestore.g.zza)object2, firebaseApp);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    private FirebaseFirestore(Context context, com.google.firebase.firestore.d.zzb databaseId, String persistenceKey, zza credentialsProvider, com.google.firebase.firestore.g.zza asyncQueue, @Nullable FirebaseApp firebaseApp) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zza = (Context)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = (com.google.firebase.firestore.d.zzb)Preconditions.checkNotNull((Object)((com.google.firebase.firestore.d.zzb)Preconditions.checkNotNull((Object)databaseId)));
        this.zzi = new UserDataConverter((com.google.firebase.firestore.d.zzb)var2_2);
        this.zzc = (String)Preconditions.checkNotNull((Object)var3_3);
        this.zzd = (zza)Preconditions.checkNotNull((Object)credentialsProvider);
        this.zze = (com.google.firebase.firestore.g.zza)Preconditions.checkNotNull((Object)asyncQueue);
        this.zzf = firebaseApp;
        this.zzg = new FirebaseFirestoreSettings.Builder().build();
    }

    @NonNull
    public FirebaseFirestoreSettings getFirestoreSettings() {
        return this.zzg;
    }

    /*
     * WARNING - void declaration
     */
    public void setFirestoreSettings(@NonNull FirebaseFirestoreSettings settings) {
        void var1_1;
        Preconditions.checkNotNull((Object)settings, (Object)"Provided settings must not be null.");
        if (this.zzh != null && !this.zzg.equals(settings)) {
            throw new IllegalStateException("FirebaseFirestore has already been started and its settings can no longer be changed. You can only call setFirestoreSettings() before calling any other methods on a FirebaseFirestore object.");
        }
        this.zzg = var1_1;
    }

    private void zzd() {
        if (this.zzh == null) {
            if (!this.zzg.areTimestampsInSnapshotsEnabled()) {
                zzq.zza("Firestore", "The behavior for java.util.Date objects stored in Firestore is going to change AND YOUR APP MAY BREAK.\nTo hide this warning and ensure your app does not break, you need to add the following code to your app before calling any other Cloud Firestore methods:\n\nFirebaseFirestore firestore = FirebaseFirestore.getInstance();\nFirebaseFirestoreSettings settings = new FirebaseFirestoreSettings.Builder()\n    .setTimestampsInSnapshotsEnabled(true)\n    .build();\nfirestore.setFirestoreSettings(settings);\n\nWith this change, timestamps stored in Cloud Firestore will be read back as com.google.firebase.Timestamp objects instead of as system java.util.Date objects. So you will also need to update code expecting a java.util.Date to instead expect a Timestamp. For example:\n\n// Old:\njava.util.Date date = snapshot.getDate(\"created_at\");\n// New:\nTimestamp timestamp = snapshot.getTimestamp(\"created_at\");\njava.util.Date date = timestamp.toDate();\n\nPlease audit all existing usages of java.util.Date when you enable the new behavior. In a future release, the behavior will be changed to the new behavior, so if you do not follow these steps, YOUR APP MAY BREAK.", new Object[0]);
            }
            com.google.a.a.a.a.zza zza2 = new com.google.a.a.a.a.zza(this.zzb, this.zzc, this.zzg.getHost(), this.zzg.isSslEnabled());
            this.zzh = new zzf(this.zza, zza2, this.zzg.isPersistenceEnabled(), this.zzd, this.zze);
        }
    }

    @NonNull
    public FirebaseApp getApp() {
        return this.zzf;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CollectionReference collection(@NonNull String collectionPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)collectionPath, (Object)"Provided collection path must not be null.");
        this.zzd();
        return new CollectionReference(zzl.zzb((String)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public DocumentReference document(@NonNull String documentPath) {
        void var1_1;
        Preconditions.checkNotNull((Object)documentPath, (Object)"Provided document path must not be null.");
        this.zzd();
        return DocumentReference.forPath(zzl.zzb((String)var1_1), this);
    }

    @NonNull
    public <TResult> Task<TResult> runTransaction(@NonNull Transaction.Function<TResult> updateFunction) {
        FirebaseFirestore firebaseFirestore;
        Preconditions.checkNotNull(updateFunction, (Object)"Provided transaction update function must not be null.");
        Executor executor = zzaf.zzb();
        Function function = firebaseFirestore;
        firebaseFirestore = this;
        firebaseFirestore.zzd();
        function = new Function<zzaf, Task<TResult>>(executor, (Transaction.Function)function){
            private /* synthetic */ Executor zzc;
            final /* synthetic */ Transaction.Function zza;
            {
                this.zzc = executor;
                this.zza = function;
            }

            public final /* synthetic */ Object apply(Object object) {
                zzaf zzaf2 = (zzaf)object;
                object = this;
                return Tasks.call((Executor)object.zzc, (Callable)new Callable<TResult>(object, zzaf2){
                    private /* synthetic */ zzaf zza;
                    private /* synthetic */ 2 zzb;
                    {
                        this.zzb = var1_1;
                        this.zza = zzaf2;
                    }

                    @Override
                    public final TResult call() throws Exception {
                        return this.zzb.zza.apply(new Transaction(this.zza, this.zzb.FirebaseFirestore.this));
                    }
                });
            }
        };
        return firebaseFirestore.zzh.zza(function, 5);
    }

    @NonNull
    public WriteBatch batch() {
        this.zzd();
        return new WriteBatch(this);
    }

    public Task<Void> enableNetwork() {
        this.zzd();
        return this.zzh.zzb();
    }

    public Task<Void> disableNetwork() {
        this.zzd();
        return this.zzh.zza();
    }

    public static void setLoggingEnabled(boolean loggingEnabled) {
        if (loggingEnabled) {
            zzq.zza(zzq.zza.zza);
            return;
        }
        zzq.zza(zzq.zza.zzb);
    }

    final zzf zza() {
        return this.zzh;
    }

    final com.google.firebase.firestore.d.zzb zzb() {
        return this.zzb;
    }

    final UserDataConverter zzc() {
        return this.zzi;
    }

    final void zza(DocumentReference documentReference) {
        Preconditions.checkNotNull((Object)documentReference, (Object)"Provided DocumentReference must not be null.");
        if (documentReference.getFirestore() != this) {
            throw new IllegalArgumentException("Provided document reference is from a different Firestore instance.");
        }
    }
}

