/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.a.a.a.a.zza;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.UserDataConverter;
import com.google.firebase.firestore.b.zzaf;
import com.google.firebase.firestore.d.zzc;
import com.google.firebase.firestore.d.zzk;
import com.google.firebase.firestore.g.zzj;
import com.google.firebase.firestore.g.zzs;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class Transaction {
    private final zzaf zza;
    private final FirebaseFirestore zzb;

    /*
     * WARNING - void declaration
     */
    Transaction(zzaf transaction, FirebaseFirestore firestore) {
        void var2_2;
        void var1_1;
        this.zza = (zzaf)Preconditions.checkNotNull((Object)var1_1);
        this.zzb = (FirebaseFirestore)Preconditions.checkNotNull((Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data) {
        void var2_2;
        void var1_1;
        return this.set((DocumentReference)var1_1, (Map<String, Object>)var2_2, SetOptions.zza);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data, @NonNull SetOptions options) {
        void var1_1;
        UserDataConverter.ParsedDocumentData parsedDocumentData;
        void var3_3;
        this.zzb.zza(documentRef);
        Preconditions.checkNotNull(data, (Object)"Provided data must not be null.");
        Preconditions.checkNotNull((Object)options, (Object)"Provided options must not be null.");
        parsedDocumentData = options.isMerge() ? this.zzb.zzc().parseMergeData(data, var3_3.getFieldMask()) : this.zzb.zzc().parseSetData((Map<String, Object>)((Object)parsedDocumentData));
        this.zza.zza(var1_1.zza(), parsedDocumentData);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Object pojo) {
        void var2_2;
        void var1_1;
        return this.set((DocumentReference)var1_1, this.zzb.zzc().convertPOJO(var2_2), SetOptions.zza);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Transaction set(@NonNull DocumentReference documentRef, @NonNull Object pojo, @NonNull SetOptions options) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.set((DocumentReference)var1_1, this.zzb.zzc().convertPOJO(var2_2), (SetOptions)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull Map<String, Object> data) {
        void var1_1;
        UserDataConverter.ParsedUpdateData parsedUpdateData;
        parsedUpdateData = this.zzb.zzc().parseUpdateData((Map<String, Object>)((Object)parsedUpdateData));
        return this.zza((DocumentReference)var1_1, parsedUpdateData);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        void var1_1;
        void var3_3;
        UserDataConverter.ParsedUpdateData parsedUpdateData;
        parsedUpdateData = this.zzb.zzc().parseUpdateData(zzs.zza(1, parsedUpdateData, var3_3, moreFieldsAndValues));
        return this.zza((DocumentReference)var1_1, parsedUpdateData);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Transaction update(@NonNull DocumentReference documentRef, @NonNull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        void var1_1;
        void var3_3;
        UserDataConverter.ParsedUpdateData parsedUpdateData;
        parsedUpdateData = this.zzb.zzc().parseUpdateData(zzs.zza(1, parsedUpdateData, var3_3, moreFieldsAndValues));
        return this.zza((DocumentReference)var1_1, parsedUpdateData);
    }

    private Transaction zza(@NonNull DocumentReference documentReference, @NonNull UserDataConverter.ParsedUpdateData parsedUpdateData) {
        this.zzb.zza(documentReference);
        this.zza.zza(documentReference.zza(), parsedUpdateData);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Transaction delete(@NonNull DocumentReference documentRef) {
        void var1_1;
        this.zzb.zza(documentRef);
        this.zza.zza(var1_1.zza());
        return this;
    }

    @NonNull
    public DocumentSnapshot get(@NonNull DocumentReference documentRef) throws FirebaseFirestoreException {
        Object object;
        this.zzb.zza(documentRef);
        try {
            void var2_3 = object;
            object = this;
            return (DocumentSnapshot)Tasks.await((Task)((Transaction)object).zza.zza(Collections.singletonList(var2_3.zza())).continueWith(zzj.zzb, (Continuation)new com.google.firebase.firestore.zzj((Transaction)object)));
        }
        catch (ExecutionException executionException) {
            object = executionException;
            if (executionException.getCause() instanceof FirebaseFirestoreException) {
                throw (FirebaseFirestoreException)((Object)((Throwable)object).getCause());
            }
            throw new RuntimeException(((Throwable)object).getCause());
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    final /* synthetic */ DocumentSnapshot zza(Task object) throws Exception {
        if (!object.isSuccessful()) {
            throw object.getException();
        }
        if ((object = (List)object.getResult()).size() != 1) {
            throw com.google.a.a.a.a.zza.zza("Mismatch in docs returned from document lookup.", new Object[0]);
        }
        if ((object = (com.google.firebase.firestore.d.zzj)object.get(0)) instanceof zzk) {
            return DocumentSnapshot.zza(this.zzb, ((com.google.firebase.firestore.d.zzj)object).zzd(), false);
        }
        return DocumentSnapshot.zza(this.zzb, (zzc)object, false);
    }

    public static interface Function<TResult> {
        @Nullable
        public TResult apply(@NonNull Transaction var1) throws FirebaseFirestoreException;
    }
}

