/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.c;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteProgram;
import android.database.sqlite.SQLiteStatement;
import android.support.annotation.VisibleForTesting;
import com.google.common.base.Function;
import com.google.firebase.firestore.a.zze;
import com.google.firebase.firestore.c.zzaa;
import com.google.firebase.firestore.c.zzab;
import com.google.firebase.firestore.c.zzag;
import com.google.firebase.firestore.c.zzai;
import com.google.firebase.firestore.c.zzau;
import com.google.firebase.firestore.c.zzav;
import com.google.firebase.firestore.c.zzba;
import com.google.firebase.firestore.c.zzbd;
import com.google.firebase.firestore.c.zzh;
import com.google.firebase.firestore.c.zzy;
import com.google.firebase.firestore.g.zzf;
import com.google.firebase.firestore.g.zzq;
import com.google.firebase.firestore.g.zzr;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nullable;

public final class zzat
extends zzaa {
    private final zza zzc;
    private final zzh zzd;
    private SQLiteDatabase zze;
    private boolean zzf;

    @VisibleForTesting
    private static String zza(String string, com.google.firebase.firestore.d.zzb zzb2) {
        try {
            return "firestore." + URLEncoder.encode(string, "utf-8") + "." + URLEncoder.encode(zzb2.zza(), "utf-8") + "." + URLEncoder.encode(zzb2.zzb(), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
    }

    public zzat(Context context, String string, com.google.firebase.firestore.d.zzb zzb2, zzh zzh2) {
        string = zzat.zza(string, zzb2);
        this.zzc = new zza(context, string);
        this.zzd = zzh2;
    }

    @Override
    public final void zza() {
        com.google.a.a.a.a.zza.zza(!this.zzf, "SQLitePersistence double-started!", new Object[0]);
        this.zzf = true;
        try {
            this.zze = this.zzc.getWritableDatabase();
            return;
        }
        catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
            throw new RuntimeException("Failed to gain exclusive lock to the Firestore client's offline persistence. This generally means you are using Firestore from multiple processes in your app. Keep in mind that multi-process Android apps execute the code in your Application class in all processes, so you may need to avoid initializing Firestore in your Application class. If you are intentionally using Firestore from multiple processes, you can only enable offline persistence (i.e. call setPersistenceEnabled(true)) in one of them.", sQLiteDatabaseLockedException);
        }
    }

    @Override
    final zzy zza(zze zze2) {
        zzat zzat2 = this;
        return new zzai(zzat2, zzat2.zzd, zze2);
    }

    @Override
    final zzab zzb() {
        zzat zzat2 = this;
        return new zzav(zzat2, zzat2.zzd);
    }

    @Override
    final zzag zzc() {
        zzat zzat2 = this;
        return new zzba(zzat2, zzat2.zzd);
    }

    @Override
    final void zza(String string, Runnable runnable) {
        try {
            zzq.zzb(zza, "Starting transaction: %s", string);
            this.zze.beginTransaction();
            runnable.run();
            this.zze.setTransactionSuccessful();
            return;
        }
        finally {
            this.zze.endTransaction();
        }
    }

    @Override
    final <T> T zza(String string, zzr<T> zzr2) {
        try {
            zzq.zzb(zza, "Starting transaction: %s", string);
            this.zze.beginTransaction();
            string = zzr2.zza();
            this.zze.setTransactionSuccessful();
            return (T)string;
        }
        finally {
            this.zze.endTransaction();
        }
    }

    final void zza(String string, Object ... objectArray) {
        this.zze.execSQL(string, objectArray);
    }

    final SQLiteStatement zza(String string) {
        return this.zze.compileStatement(string);
    }

    final int zza(SQLiteStatement sQLiteStatement, Object ... objectArray) {
        sQLiteStatement.clearBindings();
        zzat.zza((SQLiteProgram)sQLiteStatement, objectArray);
        return sQLiteStatement.executeUpdateDelete();
    }

    final zzb zzb(String string) {
        return new zzb(string, 0);
    }

    private static void zza(SQLiteProgram sQLiteProgram, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) {
                sQLiteProgram.bindNull(i + 1);
                continue;
            }
            if (object instanceof String) {
                sQLiteProgram.bindString(i + 1, (String)object);
                continue;
            }
            if (object instanceof Integer) {
                sQLiteProgram.bindLong(i + 1, (long)((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                sQLiteProgram.bindLong(i + 1, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Double) {
                sQLiteProgram.bindDouble(i + 1, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof byte[]) {
                sQLiteProgram.bindBlob(i + 1, (byte[])object);
                continue;
            }
            throw com.google.a.a.a.a.zza.zza("Unknown argument %s of type %s", object, object.getClass());
        }
    }

    static /* synthetic */ void zza(zzat zzat2, SQLiteProgram sQLiteProgram, Object[] objectArray) {
        zzat.zza(sQLiteProgram, objectArray);
    }

    final class zzb {
        private final String zzb;
        private SQLiteDatabase.CursorFactory zzc;

        private zzb(String string) {
            this.zzb = string;
        }

        final zzb zza(Object ... objectArray) {
            this.zzc = new zzau(this, objectArray);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void zza(zzf<Cursor> zzf2) {
            Cursor cursor = null;
            try {
                cursor = this.zzb();
                while (cursor.moveToNext()) {
                    zzf2.zza(cursor);
                }
                if (cursor == null) return;
            }
            catch (Throwable throwable) {
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
            cursor.close();
        }

        final int zzb(zzf<Cursor> zzf2) {
            try (Cursor cursor = null;){
                cursor = this.zzb();
                if (cursor.moveToFirst()) {
                    zzf2.zza(cursor);
                    return 1;
                }
                return 0;
            }
        }

        @Nullable
        final <T> T zza(Function<Cursor, T> object) {
            try (Cursor cursor = null;){
                cursor = this.zzb();
                if (cursor.moveToFirst()) {
                    object = object.apply((Object)cursor);
                    return (T)object;
                }
                return null;
            }
        }

        final boolean zza() {
            try (Cursor cursor = null;){
                cursor = this.zzb();
                boolean bl = !cursor.moveToFirst();
                return bl;
            }
        }

        private Cursor zzb() {
            if (this.zzc != null) {
                return zzat.this.zze.rawQueryWithFactory(this.zzc, this.zzb, null, null);
            }
            return zzat.this.zze.rawQuery(this.zzb, null);
        }

        /* synthetic */ zzb(String string, byte by) {
            this(string);
        }
    }

    static final class zza
    extends SQLiteOpenHelper {
        private boolean zza;

        zza(Context context, String string) {
            super(context, string, null, zzbd.zza);
        }

        public final void onConfigure(SQLiteDatabase db) {
            Cursor cursor;
            this.zza = true;
            cursor = cursor.rawQuery("PRAGMA locking_mode = EXCLUSIVE", new String[0]);
            cursor.close();
        }

        private void zza(SQLiteDatabase sQLiteDatabase) {
            if (!this.zza) {
                this.onConfigure(sQLiteDatabase);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void onCreate(SQLiteDatabase db) {
            void var1_1;
            this.zza(db);
            new zzbd((SQLiteDatabase)var1_1).zza(0);
        }

        /*
         * WARNING - void declaration
         */
        public final void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            void var2_2;
            void var1_1;
            this.zza(db);
            new zzbd((SQLiteDatabase)var1_1).zza((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            void var1_1;
            this.zza((SQLiteDatabase)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void onOpen(SQLiteDatabase db) {
            void var1_1;
            this.zza((SQLiteDatabase)var1_1);
        }
    }
}

