/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.util.SparseArray;
import com.google.common.base.Preconditions;
import com.google.firebase.FirebaseException;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.util.Assert;

@PublicApi
public class FirebaseFirestoreException
extends FirebaseException {
    @NonNull
    private final Code code;

    @PublicApi
    public FirebaseFirestoreException(@NonNull String detailMessage, @NonNull Code code) {
        super(detailMessage);
        Preconditions.checkNotNull((Object)detailMessage, (Object)"Provided message must not be null.");
        Assert.hardAssert(code != Code.OK, "A FirebaseFirestoreException should never be thrown for OK", new Object[0]);
        this.code = (Code)((Object)Preconditions.checkNotNull((Object)((Object)code), (Object)"Provided code must not be null."));
    }

    @PublicApi
    public FirebaseFirestoreException(@NonNull String detailMessage, @NonNull Code code, Throwable cause) {
        super(detailMessage, cause);
        Preconditions.checkNotNull((Object)detailMessage, (Object)"Provided message must not be null.");
        Assert.hardAssert(code != Code.OK, "A FirebaseFirestoreException should never be thrown for OK", new Object[0]);
        this.code = (Code)((Object)Preconditions.checkNotNull((Object)((Object)code), (Object)"Provided code must not be null."));
    }

    @NonNull
    @PublicApi
    public Code getCode() {
        return this.code;
    }

    @PublicApi
    public static enum Code {
        OK(0),
        CANCELLED(1),
        UNKNOWN(2),
        INVALID_ARGUMENT(3),
        DEADLINE_EXCEEDED(4),
        NOT_FOUND(5),
        ALREADY_EXISTS(6),
        PERMISSION_DENIED(7),
        RESOURCE_EXHAUSTED(8),
        FAILED_PRECONDITION(9),
        ABORTED(10),
        OUT_OF_RANGE(11),
        UNIMPLEMENTED(12),
        INTERNAL(13),
        UNAVAILABLE(14),
        DATA_LOSS(15),
        UNAUTHENTICATED(16);

        private final int value;
        private static final SparseArray<Code> STATUS_LIST;

        private Code(int value) {
            this.value = value;
        }

        @PublicApi
        public int value() {
            return this.value;
        }

        private static SparseArray<Code> buildStatusList() {
            SparseArray codes = new SparseArray();
            for (Code c : Code.values()) {
                Code existingValue = (Code)((Object)codes.get(c.value()));
                if (existingValue != null) {
                    throw new IllegalStateException("Code value duplication between " + (Object)((Object)existingValue) + "&" + c.name());
                }
                codes.put(c.value(), (Object)c);
            }
            return codes;
        }

        @NonNull
        @PublicApi
        public static Code fromValue(int value) {
            return (Code)((Object)STATUS_LIST.get(value, (Object)UNKNOWN));
        }

        static {
            STATUS_LIST = Code.buildStatusList();
        }
    }
}

