/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.util.Util;

@PublicApi
public class GeoPoint
implements Comparable<GeoPoint> {
    private final double latitude;
    private final double longitude;

    @PublicApi
    public GeoPoint(double latitude, double longitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("Latitude must be in the range of [-90, 90]");
        }
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("Longitude must be in the range of [-180, 180]");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @PublicApi
    public double getLatitude() {
        return this.latitude;
    }

    @PublicApi
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    @PublicApi
    public int compareTo(@NonNull GeoPoint other) {
        int comparison = Util.compareDoubles(this.latitude, other.latitude);
        if (comparison == 0) {
            return Util.compareDoubles(this.longitude, other.longitude);
        }
        return comparison;
    }

    @NonNull
    public String toString() {
        return "GeoPoint { latitude=" + this.latitude + ", longitude=" + this.longitude + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof GeoPoint)) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        return this.latitude == geoPoint.latitude && this.longitude == geoPoint.longitude;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

