/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.Bound;
import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.core.OrderBy;
import com.google.firebase.firestore.core.RelationFilter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public final class Query {
    public static final long NO_LIMIT = -1L;
    private static final OrderBy KEY_ORDERING_ASC = OrderBy.getInstance(OrderBy.Direction.ASCENDING, FieldPath.KEY_PATH);
    private static final OrderBy KEY_ORDERING_DESC = OrderBy.getInstance(OrderBy.Direction.DESCENDING, FieldPath.KEY_PATH);
    private final List<OrderBy> explicitSortOrder;
    private List<OrderBy> memoizedOrderBy;
    private final List<Filter> filters;
    private final ResourcePath path;
    private final long limit;
    @Nullable
    private final Bound startAt;
    @Nullable
    private final Bound endAt;

    public static Query atPath(ResourcePath path) {
        return new Query(path, Collections.<Filter>emptyList(), Collections.<OrderBy>emptyList(), -1L, null, null);
    }

    public Query(ResourcePath path, List<Filter> filters, List<OrderBy> explicitSortOrder, long limit, @Nullable Bound startAt, @Nullable Bound endAt) {
        this.path = path;
        this.explicitSortOrder = explicitSortOrder;
        this.filters = filters;
        this.limit = limit;
        this.startAt = startAt;
        this.endAt = endAt;
    }

    public ResourcePath getPath() {
        return this.path;
    }

    public boolean isDocumentQuery() {
        return DocumentKey.isDocumentKey(this.path) && this.filters.isEmpty();
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public long getLimit() {
        Assert.hardAssert(this.hasLimit(), "Called getLimit when no limit was set", new Object[0]);
        return this.limit;
    }

    public boolean hasLimit() {
        return this.limit != -1L;
    }

    @Nullable
    public Bound getStartAt() {
        return this.startAt;
    }

    @Nullable
    public Bound getEndAt() {
        return this.endAt;
    }

    public FieldPath getFirstOrderByField() {
        if (this.explicitSortOrder.isEmpty()) {
            return null;
        }
        return this.explicitSortOrder.get(0).getField();
    }

    @Nullable
    public FieldPath inequalityField() {
        for (Filter filter : this.filters) {
            RelationFilter relationFilter;
            if (!(filter instanceof RelationFilter) || !(relationFilter = (RelationFilter)filter).isInequality()) continue;
            return relationFilter.getField();
        }
        return null;
    }

    public boolean hasArrayContainsFilter() {
        for (Filter filter : this.filters) {
            RelationFilter relationFilter;
            if (!(filter instanceof RelationFilter) || (relationFilter = (RelationFilter)filter).getOperator() != Filter.Operator.ARRAY_CONTAINS) continue;
            return true;
        }
        return false;
    }

    public Query filter(Filter filter) {
        FieldPath queryInequalityField;
        Assert.hardAssert(!DocumentKey.isDocumentKey(this.path), "No filter is allowed for document query", new Object[0]);
        FieldPath newInequalityField = null;
        if (filter instanceof RelationFilter && ((RelationFilter)filter).isInequality()) {
            newInequalityField = filter.getField();
        }
        Assert.hardAssert((queryInequalityField = this.inequalityField()) == null || newInequalityField == null || queryInequalityField.equals(newInequalityField), "Query must only have one inequality field", new Object[0]);
        Assert.hardAssert(this.explicitSortOrder.isEmpty() || newInequalityField == null || this.explicitSortOrder.get((int)0).field.equals(newInequalityField), "First orderBy must match inequality field", new Object[0]);
        ArrayList<Filter> updatedFilter = new ArrayList<Filter>(this.filters);
        updatedFilter.add(filter);
        return new Query(this.path, updatedFilter, this.explicitSortOrder, this.limit, this.startAt, this.endAt);
    }

    public Query orderBy(OrderBy order) {
        FieldPath inequality;
        if (DocumentKey.isDocumentKey(this.path)) {
            throw Assert.fail("No ordering is allowed for document query", new Object[0]);
        }
        if (this.explicitSortOrder.isEmpty() && (inequality = this.inequalityField()) != null && !inequality.equals(order.field)) {
            throw Assert.fail("First orderBy must match inequality field", new Object[0]);
        }
        ArrayList<OrderBy> updatedSortOrder = new ArrayList<OrderBy>(this.explicitSortOrder);
        updatedSortOrder.add(order);
        return new Query(this.path, this.filters, updatedSortOrder, this.limit, this.startAt, this.endAt);
    }

    public Query limit(long limit) {
        return new Query(this.path, this.filters, this.explicitSortOrder, limit, this.startAt, this.endAt);
    }

    public Query startAt(Bound bound) {
        return new Query(this.path, this.filters, this.explicitSortOrder, this.limit, bound, this.endAt);
    }

    public Query endAt(Bound bound) {
        return new Query(this.path, this.filters, this.explicitSortOrder, this.limit, this.startAt, bound);
    }

    public List<OrderBy> getExplicitOrderBy() {
        return this.explicitSortOrder;
    }

    public List<OrderBy> getOrderBy() {
        if (this.memoizedOrderBy == null) {
            FieldPath inequalityField = this.inequalityField();
            FieldPath firstOrderByField = this.getFirstOrderByField();
            if (inequalityField != null && firstOrderByField == null) {
                this.memoizedOrderBy = inequalityField.isKeyField() ? Collections.singletonList(KEY_ORDERING_ASC) : Arrays.asList(OrderBy.getInstance(OrderBy.Direction.ASCENDING, inequalityField), KEY_ORDERING_ASC);
            } else {
                ArrayList<OrderBy> res = new ArrayList<OrderBy>();
                boolean foundKeyOrdering = false;
                for (OrderBy explicit : this.explicitSortOrder) {
                    res.add(explicit);
                    if (!explicit.getField().equals(FieldPath.KEY_PATH)) continue;
                    foundKeyOrdering = true;
                }
                if (!foundKeyOrdering) {
                    OrderBy.Direction lastDirection = this.explicitSortOrder.size() > 0 ? this.explicitSortOrder.get(this.explicitSortOrder.size() - 1).getDirection() : OrderBy.Direction.ASCENDING;
                    res.add(lastDirection.equals((Object)OrderBy.Direction.ASCENDING) ? KEY_ORDERING_ASC : KEY_ORDERING_DESC);
                }
                this.memoizedOrderBy = res;
            }
        }
        return this.memoizedOrderBy;
    }

    private boolean matchesPath(Document doc) {
        ResourcePath docPath = doc.getKey().getPath();
        if (DocumentKey.isDocumentKey(this.path)) {
            return this.path.equals(docPath);
        }
        return this.path.isPrefixOf(docPath) && this.path.length() == docPath.length() - 1;
    }

    private boolean matchesFilters(Document doc) {
        for (Filter filter : this.filters) {
            if (filter.matches(doc)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesOrderBy(Document doc) {
        for (OrderBy order : this.explicitSortOrder) {
            if (order.getField().equals(FieldPath.KEY_PATH) || doc.getField(order.field) != null) continue;
            return false;
        }
        return true;
    }

    private boolean matchesBounds(Document doc) {
        if (this.startAt != null && !this.startAt.sortsBeforeDocument(this.getOrderBy(), doc)) {
            return false;
        }
        return this.endAt == null || !this.endAt.sortsBeforeDocument(this.getOrderBy(), doc);
    }

    public boolean matches(Document doc) {
        return this.matchesPath(doc) && this.matchesOrderBy(doc) && this.matchesFilters(doc) && this.matchesBounds(doc);
    }

    public Comparator<Document> comparator() {
        return new QueryComparator(this.getOrderBy());
    }

    public String getCanonicalId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getPath().canonicalString());
        builder.append("|f:");
        for (Filter filter : this.getFilters()) {
            builder.append(filter.getCanonicalId());
        }
        builder.append("|ob:");
        for (OrderBy orderBy : this.getOrderBy()) {
            builder.append(orderBy.getField().canonicalString());
            builder.append(orderBy.getDirection().equals((Object)OrderBy.Direction.ASCENDING) ? "asc" : "desc");
        }
        if (this.hasLimit()) {
            builder.append("|l:");
            builder.append(this.getLimit());
        }
        if (this.startAt != null) {
            builder.append("|lb:");
            builder.append(this.startAt.canonicalString());
        }
        if (this.endAt != null) {
            builder.append("|ub:");
            builder.append(this.endAt.canonicalString());
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        if (this.limit != query.limit) {
            return false;
        }
        if (!this.getOrderBy().equals(query.getOrderBy())) {
            return false;
        }
        if (!this.filters.equals(query.filters)) {
            return false;
        }
        if (!this.path.equals(query.path)) {
            return false;
        }
        if (this.startAt != null ? !this.startAt.equals(query.startAt) : query.startAt != null) {
            return false;
        }
        return this.endAt != null ? this.endAt.equals(query.endAt) : query.endAt == null;
    }

    public int hashCode() {
        int result = this.getOrderBy().hashCode();
        result = 31 * result + this.filters.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
        result = 31 * result + (this.startAt != null ? this.startAt.hashCode() : 0);
        result = 31 * result + (this.endAt != null ? this.endAt.hashCode() : 0);
        return result;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("Query(");
        builder.append(this.path.canonicalString());
        if (!this.filters.isEmpty()) {
            builder.append(" where ");
            for (i = 0; i < this.filters.size(); ++i) {
                if (i > 0) {
                    builder.append(" and ");
                }
                builder.append(this.filters.get(i).toString());
            }
        }
        if (!this.explicitSortOrder.isEmpty()) {
            builder.append(" order by ");
            for (i = 0; i < this.explicitSortOrder.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.explicitSortOrder.get(i));
            }
        }
        builder.append(")");
        return builder.toString();
    }

    private static class QueryComparator
    implements Comparator<Document> {
        private final List<OrderBy> sortOrder;

        QueryComparator(List<OrderBy> order) {
            boolean hasKeyOrdering = false;
            for (OrderBy orderBy : order) {
                hasKeyOrdering = hasKeyOrdering || orderBy.getField().equals(FieldPath.KEY_PATH);
            }
            if (!hasKeyOrdering) {
                throw new IllegalArgumentException("QueryComparator needs to have a key ordering");
            }
            this.sortOrder = order;
        }

        @Override
        public int compare(Document doc1, Document doc2) {
            for (OrderBy order : this.sortOrder) {
                int comp = order.compare(doc1, doc2);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    }
}

