/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.core.DocumentViewChange;
import com.google.firebase.firestore.core.EventManager;
import com.google.firebase.firestore.core.OnlineState;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentSet;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class QueryListener {
    private final Query query;
    private final EventManager.ListenOptions options;
    private final EventListener<ViewSnapshot> listener;
    private boolean raisedInitialEvent = false;
    private OnlineState onlineState = OnlineState.UNKNOWN;
    @Nullable
    private ViewSnapshot snapshot;

    public QueryListener(Query query, EventManager.ListenOptions options, EventListener<ViewSnapshot> listener) {
        this.query = query;
        this.listener = listener;
        this.options = options;
    }

    public Query getQuery() {
        return this.query;
    }

    public void onViewSnapshot(ViewSnapshot newSnapshot) {
        Assert.hardAssert(!newSnapshot.getChanges().isEmpty() || newSnapshot.didSyncStateChange(), "We got a new snapshot with no changes?", new Object[0]);
        if (!this.options.includeDocumentMetadataChanges) {
            ArrayList<DocumentViewChange> documentChanges = new ArrayList<DocumentViewChange>();
            for (DocumentViewChange change : newSnapshot.getChanges()) {
                if (change.getType() == DocumentViewChange.Type.METADATA) continue;
                documentChanges.add(change);
            }
            newSnapshot = new ViewSnapshot(newSnapshot.getQuery(), newSnapshot.getDocuments(), newSnapshot.getOldDocuments(), documentChanges, newSnapshot.isFromCache(), newSnapshot.getMutatedKeys(), newSnapshot.didSyncStateChange());
        }
        if (!this.raisedInitialEvent) {
            if (this.shouldRaiseInitialEvent(newSnapshot, this.onlineState)) {
                this.raiseInitialEvent(newSnapshot);
            }
        } else if (this.shouldRaiseEvent(newSnapshot)) {
            this.listener.onEvent(newSnapshot, null);
        }
        this.snapshot = newSnapshot;
    }

    public void onError(FirebaseFirestoreException error) {
        this.listener.onEvent(null, error);
    }

    public void onOnlineStateChanged(OnlineState onlineState) {
        this.onlineState = onlineState;
        if (this.snapshot != null && !this.raisedInitialEvent && this.shouldRaiseInitialEvent(this.snapshot, onlineState)) {
            this.raiseInitialEvent(this.snapshot);
        }
    }

    private boolean shouldRaiseInitialEvent(ViewSnapshot snapshot, OnlineState onlineState) {
        boolean maybeOnline;
        Assert.hardAssert(!this.raisedInitialEvent, "Determining whether to raise first event but already had first event.", new Object[0]);
        if (!snapshot.isFromCache()) {
            return true;
        }
        boolean bl = maybeOnline = !onlineState.equals((Object)OnlineState.OFFLINE);
        if (this.options.waitForSyncWhenOnline && maybeOnline) {
            Assert.hardAssert(snapshot.isFromCache(), "Waiting for sync, but snapshot is not from cache", new Object[0]);
            return false;
        }
        return !snapshot.getDocuments().isEmpty() || onlineState.equals((Object)OnlineState.OFFLINE);
    }

    private boolean shouldRaiseEvent(ViewSnapshot snapshot) {
        boolean hasPendingWritesChanged;
        if (!snapshot.getChanges().isEmpty()) {
            return true;
        }
        boolean bl = hasPendingWritesChanged = this.snapshot != null && this.snapshot.hasPendingWrites() != snapshot.hasPendingWrites();
        if (snapshot.didSyncStateChange() || hasPendingWritesChanged) {
            return this.options.includeQueryMetadataChanges;
        }
        return false;
    }

    private void raiseInitialEvent(ViewSnapshot snapshot) {
        Assert.hardAssert(!this.raisedInitialEvent, "Trying to raise initial event for second time", new Object[0]);
        snapshot = new ViewSnapshot(snapshot.getQuery(), snapshot.getDocuments(), DocumentSet.emptySet(snapshot.getQuery().comparator()), QueryListener.getInitialViewChanges(snapshot), snapshot.isFromCache(), snapshot.getMutatedKeys(), true);
        this.raisedInitialEvent = true;
        this.listener.onEvent(snapshot, null);
    }

    private static List<DocumentViewChange> getInitialViewChanges(ViewSnapshot snapshot) {
        ArrayList<DocumentViewChange> res = new ArrayList<DocumentViewChange>();
        for (Document doc : snapshot.getDocuments()) {
            res.add(DocumentViewChange.create(DocumentViewChange.Type.ADDED, doc));
        }
        return res;
    }
}

