/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.core.Transaction$$Lambda$1;
import com.google.firebase.firestore.core.Transaction$$Lambda$2;
import com.google.firebase.firestore.core.UserData;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.NoDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.DeleteMutation;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Executors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Transaction {
    private final Datastore datastore;
    private final HashMap<DocumentKey, SnapshotVersion> readVersions = new HashMap();
    private final ArrayList<Mutation> mutations = new ArrayList();
    private boolean committed;
    private static final Executor defaultExecutor = Transaction.createDefaultExecutor();

    public Transaction(Datastore d) {
        this.datastore = d;
    }

    private void recordVersion(MaybeDocument doc) throws FirebaseFirestoreException {
        SnapshotVersion docVersion;
        if (doc instanceof Document) {
            docVersion = doc.getVersion();
        } else if (doc instanceof NoDocument) {
            docVersion = SnapshotVersion.NONE;
        } else {
            throw Assert.fail("Unexpected document type in transaction: " + doc.getClass().getCanonicalName(), new Object[0]);
        }
        if (this.readVersions.containsKey(doc.getKey())) {
            SnapshotVersion existingVersion = this.readVersions.get(doc.getKey());
            if (!existingVersion.equals(doc.getVersion())) {
                throw new FirebaseFirestoreException("Document version changed between two reads.", FirebaseFirestoreException.Code.FAILED_PRECONDITION);
            }
        } else {
            this.readVersions.put(doc.getKey(), docVersion);
        }
    }

    public Task<List<MaybeDocument>> lookup(List<DocumentKey> keys) {
        if (this.committed) {
            return Tasks.forException((Exception)((Object)new FirebaseFirestoreException("Transaction has already completed.", FirebaseFirestoreException.Code.FAILED_PRECONDITION)));
        }
        if (this.mutations.size() != 0) {
            return Tasks.forException((Exception)((Object)new FirebaseFirestoreException("Transactions lookups are invalid after writes.", FirebaseFirestoreException.Code.FAILED_PRECONDITION)));
        }
        return this.datastore.lookup(keys).continueWithTask(Executors.DIRECT_EXECUTOR, Transaction$$Lambda$1.lambdaFactory$(this));
    }

    private void write(List<Mutation> mutations) {
        if (this.committed) {
            throw new IllegalStateException("Transaction has already completed.");
        }
        this.mutations.addAll(mutations);
    }

    private Precondition precondition(DocumentKey key) {
        SnapshotVersion version = this.readVersions.get(key);
        if (version != null) {
            return Precondition.updateTime(version);
        }
        return Precondition.NONE;
    }

    private Precondition preconditionForUpdate(DocumentKey key) {
        SnapshotVersion version = this.readVersions.get(key);
        if (version != null && version.equals(SnapshotVersion.NONE)) {
            throw new IllegalStateException("Can't update a document that doesn't exist.");
        }
        if (version != null) {
            return Precondition.updateTime(version);
        }
        return Precondition.exists(true);
    }

    public void set(DocumentKey key, UserData.ParsedSetData data) {
        this.write(data.toMutationList(key, this.precondition(key)));
    }

    public void update(DocumentKey key, UserData.ParsedUpdateData data) {
        this.write(data.toMutationList(key, this.preconditionForUpdate(key)));
    }

    public void delete(DocumentKey key) {
        this.write(Collections.singletonList(new DeleteMutation(key, this.precondition(key))));
        this.readVersions.put(key, SnapshotVersion.NONE);
    }

    public Task<Void> commit() {
        if (this.committed) {
            return Tasks.forException((Exception)((Object)new FirebaseFirestoreException("Transaction has already completed.", FirebaseFirestoreException.Code.FAILED_PRECONDITION)));
        }
        HashSet<DocumentKey> unwritten = new HashSet<DocumentKey>(this.readVersions.keySet());
        for (Mutation mutation : this.mutations) {
            unwritten.remove(mutation.getKey());
        }
        if (unwritten.size() > 0) {
            return Tasks.forException((Exception)((Object)new FirebaseFirestoreException("Every document read in a transaction must also be written.", FirebaseFirestoreException.Code.FAILED_PRECONDITION)));
        }
        this.committed = true;
        return this.datastore.commit(this.mutations).continueWithTask(Executors.DIRECT_EXECUTOR, Transaction$$Lambda$2.lambdaFactory$());
    }

    private static Executor createDefaultExecutor() {
        int corePoolSize;
        int maxPoolSize = corePoolSize = 5;
        int keepAliveSeconds = 1;
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveSeconds, TimeUnit.SECONDS, queue);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static Executor getDefaultExecutor() {
        return defaultExecutor;
    }

    static /* synthetic */ Task lambda$commit$1(Task task) throws Exception {
        if (task.isSuccessful()) {
            return Tasks.forResult(null);
        }
        return Tasks.forException((Exception)task.getException());
    }

    static /* synthetic */ Task lambda$lookup$0(Transaction this_, Task task) throws Exception {
        if (task.isSuccessful()) {
            for (MaybeDocument doc : (List)task.getResult()) {
                this_.recordVersion(doc);
            }
        }
        return task;
    }
}

