/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.NoDocument;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class LocalDocumentsView {
    private final RemoteDocumentCache remoteDocumentCache;
    private final MutationQueue mutationQueue;

    LocalDocumentsView(RemoteDocumentCache remoteDocumentCache, MutationQueue mutationQueue) {
        this.remoteDocumentCache = remoteDocumentCache;
        this.mutationQueue = mutationQueue;
    }

    @Nullable
    MaybeDocument getDocument(DocumentKey key) {
        List<MutationBatch> batches = this.mutationQueue.getAllMutationBatchesAffectingDocumentKey(key);
        return this.getDocument(key, batches);
    }

    @Nullable
    private MaybeDocument getDocument(DocumentKey key, List<MutationBatch> inBatches) {
        MaybeDocument document = this.remoteDocumentCache.get(key);
        for (MutationBatch batch : inBatches) {
            document = batch.applyToLocalView(key, document);
        }
        return document;
    }

    ImmutableSortedMap<DocumentKey, MaybeDocument> getDocuments(Iterable<DocumentKey> keys) {
        ImmutableSortedMap results = DocumentCollections.emptyMaybeDocumentMap();
        List<MutationBatch> batches = this.mutationQueue.getAllMutationBatchesAffectingDocumentKeys(keys);
        for (DocumentKey key : keys) {
            MaybeDocument maybeDoc = this.getDocument(key, batches);
            if (maybeDoc == null) {
                maybeDoc = new NoDocument(key, SnapshotVersion.NONE, false);
            }
            results = results.insert((Object)key, (Object)maybeDoc);
        }
        return results;
    }

    ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingQuery(Query query) {
        ResourcePath path = query.getPath();
        if (DocumentKey.isDocumentKey(path)) {
            return this.getDocumentsMatchingDocumentQuery(path);
        }
        return this.getDocumentsMatchingCollectionQuery(query);
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingDocumentQuery(ResourcePath path) {
        ImmutableSortedMap result = DocumentCollections.emptyDocumentMap();
        MaybeDocument doc = this.getDocument(DocumentKey.fromPath(path));
        if (doc instanceof Document) {
            result = result.insert((Object)doc.getKey(), (Object)((Document)doc));
        }
        return result;
    }

    private ImmutableSortedMap<DocumentKey, Document> getDocumentsMatchingCollectionQuery(Query query) {
        ImmutableSortedMap results = this.remoteDocumentCache.getAllDocumentsMatchingQuery(query);
        List<MutationBatch> matchingBatches = this.mutationQueue.getAllMutationBatchesAffectingQuery(query);
        for (MutationBatch batch : matchingBatches) {
            for (Mutation mutation : batch.getMutations()) {
                if (!query.getPath().isImmediateParentOf(mutation.getKey().getPath())) continue;
                DocumentKey key = mutation.getKey();
                MaybeDocument baseDoc = (MaybeDocument)results.get((Object)key);
                MaybeDocument mutatedDoc = mutation.applyToLocalView(baseDoc, baseDoc, batch.getLocalWriteTime());
                if (mutatedDoc instanceof Document) {
                    results = results.insert((Object)key, (Object)((Document)mutatedDoc));
                    continue;
                }
                results = results.remove((Object)key);
            }
        }
        for (Map.Entry docEntry : results) {
            if (query.matches((Document)docEntry.getValue())) continue;
            results = results.remove((Object)((DocumentKey)docEntry.getKey()));
        }
        return results;
    }
}

