/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.google.common.base.Preconditions;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$1;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$2;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$3;
import com.google.firebase.firestore.local.SQLiteSchema$$Lambda$4;
import com.google.firebase.firestore.util.Assert;

class SQLiteSchema {
    static final int VERSION = 7;
    static final int INDEXING_SUPPORT_VERSION = 8;
    private final SQLiteDatabase db;

    SQLiteSchema(SQLiteDatabase db) {
        this.db = db;
    }

    void runMigrations() {
        this.runMigrations(0, 7);
    }

    void runMigrations(int fromVersion) {
        this.runMigrations(fromVersion, 7);
    }

    void runMigrations(int fromVersion, int toVersion) {
        if (fromVersion < 1 && toVersion >= 1) {
            this.createMutationQueue();
            this.createQueryCache();
            this.createRemoteDocumentCache();
        }
        if (fromVersion < 3 && toVersion >= 3 && fromVersion != 0) {
            this.dropQueryCache();
            this.createQueryCache();
        }
        if (fromVersion < 4 && toVersion >= 4) {
            this.ensureTargetGlobal();
            this.addTargetCount();
        }
        if (fromVersion < 5 && toVersion >= 5) {
            this.addSequenceNumber();
        }
        if (fromVersion < 6 && toVersion >= 6) {
            this.removeAcknowledgedMutations();
        }
        if (fromVersion < 7 && toVersion >= 7) {
            this.ensureSequenceNumbers();
        }
        if (fromVersion < 8 && toVersion >= 8) {
            Preconditions.checkState((boolean)Persistence.INDEXING_SUPPORT_ENABLED);
            this.createLocalDocumentsCollectionIndex();
        }
    }

    private void createMutationQueue() {
        this.db.execSQL("CREATE TABLE mutation_queues (uid TEXT PRIMARY KEY, last_acknowledged_batch_id INTEGER, last_stream_token BLOB)");
        this.db.execSQL("CREATE TABLE mutations (uid TEXT, batch_id INTEGER, mutations BLOB, PRIMARY KEY (uid, batch_id))");
        this.db.execSQL("CREATE TABLE document_mutations (uid TEXT, path TEXT, batch_id INTEGER, PRIMARY KEY (uid, path, batch_id))");
    }

    private void removeAcknowledgedMutations() {
        SQLitePersistence.Query mutationQueuesQuery = new SQLitePersistence.Query(this.db, "SELECT uid, last_acknowledged_batch_id FROM mutation_queues");
        mutationQueuesQuery.forEach(SQLiteSchema$$Lambda$1.lambdaFactory$(this));
    }

    private void removeMutationBatch(String uid, int batchId) {
        SQLiteStatement mutationDeleter = this.db.compileStatement("DELETE FROM mutations WHERE uid = ? AND batch_id = ?");
        mutationDeleter.bindString(1, uid);
        mutationDeleter.bindLong(2, (long)batchId);
        int deleted = mutationDeleter.executeUpdateDelete();
        Assert.hardAssert(deleted != 0, "Mutatiohn batch (%s, %d) did not exist", uid, batchId);
        this.db.execSQL("DELETE FROM document_mutations WHERE uid = ? AND batch_id = ?", new Object[]{uid, batchId});
    }

    private void createQueryCache() {
        this.db.execSQL("CREATE TABLE targets (target_id INTEGER PRIMARY KEY, canonical_id TEXT, snapshot_version_seconds INTEGER, snapshot_version_nanos INTEGER, resume_token BLOB, last_listen_sequence_number INTEGER,target_proto BLOB)");
        this.db.execSQL("CREATE INDEX query_targets ON targets (canonical_id, target_id)");
        this.db.execSQL("CREATE TABLE target_globals (highest_target_id INTEGER, highest_listen_sequence_number INTEGER, last_remote_snapshot_version_seconds INTEGER, last_remote_snapshot_version_nanos INTEGER)");
        this.db.execSQL("CREATE TABLE target_documents (target_id INTEGER, path TEXT, PRIMARY KEY (target_id, path))");
        this.db.execSQL("CREATE INDEX document_targets ON target_documents (path, target_id)");
    }

    private void dropQueryCache() {
        this.db.execSQL("DROP TABLE targets");
        this.db.execSQL("DROP TABLE target_globals");
        this.db.execSQL("DROP TABLE target_documents");
    }

    private void createRemoteDocumentCache() {
        this.db.execSQL("CREATE TABLE remote_documents (path TEXT PRIMARY KEY, contents BLOB)");
    }

    private void createLocalDocumentsCollectionIndex() {
        this.db.execSQL("CREATE TABLE collection_index (uid TEXT, collection_path TEXT, field_path TEXT, field_value_type INTEGER, field_value_1, field_value_2, document_id TEXT, PRIMARY KEY (uid, collection_path, field_path, field_value_type, field_value_1, field_value_2, document_id))");
    }

    private void ensureTargetGlobal() {
        boolean targetGlobalExists;
        boolean bl = targetGlobalExists = DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db, (String)"target_globals") == 1L;
        if (!targetGlobalExists) {
            this.db.execSQL("INSERT INTO target_globals (highest_target_id, highest_listen_sequence_number, last_remote_snapshot_version_seconds, last_remote_snapshot_version_nanos) VALUES (?, ?, ?, ?)", (Object[])new String[]{"0", "0", "0", "0"});
        }
    }

    private void addTargetCount() {
        long count = DatabaseUtils.queryNumEntries((SQLiteDatabase)this.db, (String)"targets");
        this.db.execSQL("ALTER TABLE target_globals ADD COLUMN target_count INTEGER");
        ContentValues cv = new ContentValues();
        cv.put("target_count", Long.valueOf(count));
        this.db.update("target_globals", cv, null, null);
    }

    private void addSequenceNumber() {
        this.db.execSQL("ALTER TABLE target_documents ADD COLUMN sequence_number INTEGER");
    }

    private void ensureSequenceNumbers() {
        SQLitePersistence.Query sequenceNumberQuery = new SQLitePersistence.Query(this.db, "SELECT highest_listen_sequence_number FROM target_globals LIMIT 1");
        Long boxedSequenceNumber = (Long)sequenceNumberQuery.firstValue(SQLiteSchema$$Lambda$2.lambdaFactory$());
        Assert.hardAssert(boxedSequenceNumber != null, "Missing highest sequence number", new Object[0]);
        long sequenceNumber = boxedSequenceNumber;
        SQLiteStatement tagDocument = this.db.compileStatement("INSERT INTO target_documents (target_id, path, sequence_number) VALUES (0, ?, ?)");
        SQLitePersistence.Query untaggedDocumentsQuery = new SQLitePersistence.Query(this.db, "SELECT RD.path FROM remote_documents AS RD WHERE NOT EXISTS (SELECT TD.path FROM target_documents AS TD WHERE RD.path = TD.path AND TD.target_id = 0)");
        untaggedDocumentsQuery.forEach(SQLiteSchema$$Lambda$3.lambdaFactory$(tagDocument, sequenceNumber));
    }

    static /* synthetic */ void lambda$ensureSequenceNumbers$3(SQLiteStatement tagDocument, long sequenceNumber, Cursor row) {
        tagDocument.clearBindings();
        tagDocument.bindString(1, row.getString(0));
        tagDocument.bindLong(2, sequenceNumber);
        Assert.hardAssert(tagDocument.executeInsert() != -1L, "Failed to insert a sentinel row", new Object[0]);
    }

    static /* synthetic */ Long lambda$ensureSequenceNumbers$2(Cursor c) {
        return c.getLong(0);
    }

    static /* synthetic */ void lambda$removeAcknowledgedMutations$1(SQLiteSchema this_, Cursor mutationQueueEntry) {
        String uid = mutationQueueEntry.getString(0);
        long lastAcknowledgedBatchId = mutationQueueEntry.getLong(1);
        SQLitePersistence.Query mutationsQuery = new SQLitePersistence.Query(this_.db, "SELECT batch_id FROM mutations WHERE uid = ? AND batch_id <= ?").binding(uid, lastAcknowledgedBatchId);
        mutationsQuery.forEach(SQLiteSchema$$Lambda$4.lambdaFactory$(this_, uid));
    }

    static /* synthetic */ void lambda$removeAcknowledgedMutations$0(SQLiteSchema this_, String uid, Cursor value) {
        this_.removeMutationBatch(uid, value.getInt(0));
    }
}

