/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model;

import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.SnapshotVersion;

public class NoDocument
extends MaybeDocument {
    private boolean hasCommittedMutations;

    public NoDocument(DocumentKey key, SnapshotVersion version, boolean hasCommittedMutations) {
        super(key, version);
        this.hasCommittedMutations = hasCommittedMutations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NoDocument that = (NoDocument)o;
        return this.hasCommittedMutations == that.hasCommittedMutations && this.getVersion().equals(that.getVersion()) && this.getKey().equals(that.getKey());
    }

    @Override
    public boolean hasPendingWrites() {
        return this.hasCommittedMutations();
    }

    public boolean hasCommittedMutations() {
        return this.hasCommittedMutations;
    }

    public int hashCode() {
        int result = this.getKey().hashCode();
        result = 31 * result + (this.hasCommittedMutations ? 1 : 0);
        result = 31 * result + this.getVersion().hashCode();
        return result;
    }

    public String toString() {
        return "NoDocument{key=" + this.getKey() + ", version=" + this.getVersion() + ", hasCommittedMutations=" + this.hasCommittedMutations() + "}";
    }
}

