/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import android.support.annotation.Nullable;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.mutation.TransformOperation;
import com.google.firebase.firestore.model.value.ArrayValue;
import com.google.firebase.firestore.model.value.FieldValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ArrayTransformOperation
implements TransformOperation {
    private final List<FieldValue> elements;

    ArrayTransformOperation(List<FieldValue> elements) {
        this.elements = Collections.unmodifiableList(elements);
    }

    public List<FieldValue> getElements() {
        return this.elements;
    }

    @Override
    public FieldValue applyToLocalView(FieldValue previousValue, Timestamp localWriteTime) {
        return this.apply(previousValue);
    }

    @Override
    public FieldValue applyToRemoteDocument(FieldValue previousValue, FieldValue transformResult) {
        return this.apply(previousValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayTransformOperation that = (ArrayTransformOperation)o;
        return this.elements.equals(that.elements);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        result = 31 * result + this.elements.hashCode();
        return result;
    }

    protected abstract ArrayValue apply(FieldValue var1);

    static ArrayList<FieldValue> coercedFieldValuesArray(@Nullable FieldValue value) {
        if (value instanceof ArrayValue) {
            return new ArrayList<FieldValue>(((ArrayValue)value).getInternalValue());
        }
        return new ArrayList<FieldValue>();
    }

    public static class Remove
    extends ArrayTransformOperation {
        public Remove(List<FieldValue> elements) {
            super(elements);
        }

        @Override
        protected ArrayValue apply(FieldValue previousValue) {
            ArrayList<FieldValue> result = Remove.coercedFieldValuesArray(previousValue);
            for (FieldValue element : this.getElements()) {
                result.removeAll(Collections.singleton(element));
            }
            return ArrayValue.fromList(result);
        }
    }

    public static class Union
    extends ArrayTransformOperation {
        public Union(List<FieldValue> elements) {
            super(elements);
        }

        @Override
        protected ArrayValue apply(FieldValue previousValue) {
            ArrayList<FieldValue> result = Union.coercedFieldValuesArray(previousValue);
            for (FieldValue element : this.getElements()) {
                if (result.contains(element)) continue;
                result.add(element);
            }
            return ArrayValue.fromList(result);
        }
    }
}

