/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.mutation;

import com.google.firebase.firestore.model.FieldPath;
import java.util.Collection;

public class FieldMask {
    private final Collection<FieldPath> mask;

    public static FieldMask fromCollection(Collection<FieldPath> mask) {
        return new FieldMask(mask);
    }

    private FieldMask(Collection<FieldPath> mask) {
        this.mask = mask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMask fieldMask = (FieldMask)o;
        return this.mask.equals(fieldMask.mask);
    }

    public boolean covers(FieldPath fieldPath) {
        for (FieldPath fieldMaskPath : this.mask) {
            if (!fieldMaskPath.isPrefixOf(fieldPath)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.mask.hashCode();
    }

    public Collection<FieldPath> getMask() {
        return this.mask;
    }
}

