/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.value;

import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.util.Assert;

public class FieldValueOptions {
    private final ServerTimestampBehavior serverTimestampBehavior;
    private final boolean timestampsInSnapshotsEnabled;

    private FieldValueOptions(ServerTimestampBehavior serverTimestampBehavior, boolean timestampsInSnapshotsEnabled) {
        this.serverTimestampBehavior = serverTimestampBehavior;
        this.timestampsInSnapshotsEnabled = timestampsInSnapshotsEnabled;
    }

    ServerTimestampBehavior getServerTimestampBehavior() {
        return this.serverTimestampBehavior;
    }

    boolean areTimestampsInSnapshotsEnabled() {
        return this.timestampsInSnapshotsEnabled;
    }

    public static FieldValueOptions create(DocumentSnapshot.ServerTimestampBehavior serverTimestampBehavior, boolean timestampsInSnapshotsEnabled) {
        ServerTimestampBehavior internalServerTimestampBehavior;
        switch (serverTimestampBehavior) {
            case ESTIMATE: {
                internalServerTimestampBehavior = ServerTimestampBehavior.ESTIMATE;
                break;
            }
            case PREVIOUS: {
                internalServerTimestampBehavior = ServerTimestampBehavior.PREVIOUS;
                break;
            }
            case NONE: {
                internalServerTimestampBehavior = ServerTimestampBehavior.NONE;
                break;
            }
            default: {
                throw Assert.fail("Unexpected case for ServerTimestampBehavior: %s", serverTimestampBehavior.name());
            }
        }
        return new FieldValueOptions(internalServerTimestampBehavior, timestampsInSnapshotsEnabled);
    }

    static enum ServerTimestampBehavior {
        NONE,
        PREVIOUS,
        ESTIMATE;

    }
}

