/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.model.value;

import com.google.firebase.Timestamp;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.FieldValueOptions;
import com.google.firebase.firestore.model.value.TimestampValue;
import com.google.firebase.firestore.util.Assert;
import javax.annotation.Nullable;

public final class ServerTimestampValue
extends FieldValue {
    private final Timestamp localWriteTime;
    @Nullable
    private final FieldValue previousValue;

    public ServerTimestampValue(Timestamp localWriteTime, @Nullable FieldValue previousValue) {
        this.localWriteTime = localWriteTime;
        this.previousValue = previousValue;
    }

    @Override
    public int typeOrder() {
        return 3;
    }

    @Override
    @Nullable
    public Object value() {
        return null;
    }

    @Override
    @Nullable
    public Object value(FieldValueOptions options) {
        switch (options.getServerTimestampBehavior()) {
            case PREVIOUS: {
                return this.previousValue != null ? this.previousValue.value(options) : null;
            }
            case ESTIMATE: {
                return new TimestampValue(this.localWriteTime).value(options);
            }
            case NONE: {
                return null;
            }
        }
        throw Assert.fail("Unexpected case for ServerTimestampBehavior: %s", options.getServerTimestampBehavior().name());
    }

    @Override
    public String toString() {
        return "<ServerTimestamp localTime=" + this.localWriteTime.toString() + ">";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ServerTimestampValue && this.localWriteTime.equals(((ServerTimestampValue)o).localWriteTime);
    }

    @Override
    public int hashCode() {
        return this.localWriteTime.hashCode();
    }

    @Override
    public int compareTo(FieldValue o) {
        if (o instanceof ServerTimestampValue) {
            return this.localWriteTime.compareTo(((ServerTimestampValue)o).localWriteTime);
        }
        if (o instanceof TimestampValue) {
            return 1;
        }
        return this.defaultCompareTo(o);
    }
}

