/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.remote;

import android.support.annotation.Nullable;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.core.OnlineState;
import com.google.firebase.firestore.core.Transaction;
import com.google.firebase.firestore.local.LocalStore;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import com.google.firebase.firestore.model.mutation.MutationBatchResult;
import com.google.firebase.firestore.model.mutation.MutationResult;
import com.google.firebase.firestore.remote.Datastore;
import com.google.firebase.firestore.remote.OnlineStateTracker;
import com.google.firebase.firestore.remote.RemoteEvent;
import com.google.firebase.firestore.remote.RemoteStore$$Lambda$1;
import com.google.firebase.firestore.remote.TargetChange;
import com.google.firebase.firestore.remote.WatchChange;
import com.google.firebase.firestore.remote.WatchChangeAggregator;
import com.google.firebase.firestore.remote.WatchStream;
import com.google.firebase.firestore.remote.WriteStream;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Logger;
import com.google.firebase.firestore.util.Util;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RemoteStore
implements WatchChangeAggregator.TargetMetadataProvider {
    private static final int MAX_PENDING_WRITES = 10;
    private static final String LOG_TAG = "RemoteStore";
    private final RemoteStoreCallback remoteStoreCallback;
    private final LocalStore localStore;
    private final Datastore datastore;
    private final Map<Integer, QueryData> listenTargets;
    private final OnlineStateTracker onlineStateTracker;
    private boolean networkEnabled = false;
    private final WatchStream watchStream;
    private final WriteStream writeStream;
    @Nullable
    private WatchChangeAggregator watchChangeAggregator;
    private final Deque<MutationBatch> writePipeline;

    public RemoteStore(RemoteStoreCallback remoteStoreCallback, LocalStore localStore, Datastore datastore, AsyncQueue workerQueue) {
        this.remoteStoreCallback = remoteStoreCallback;
        this.localStore = localStore;
        this.datastore = datastore;
        this.listenTargets = new HashMap<Integer, QueryData>();
        this.writePipeline = new ArrayDeque<MutationBatch>();
        RemoteStoreCallback remoteStoreCallback2 = remoteStoreCallback;
        remoteStoreCallback2.getClass();
        this.onlineStateTracker = new OnlineStateTracker(workerQueue, RemoteStore$$Lambda$1.lambdaFactory$(remoteStoreCallback2));
        this.watchStream = datastore.createWatchStream(new WatchStream.Callback(){

            @Override
            public void onOpen() {
                RemoteStore.this.handleWatchStreamOpen();
            }

            @Override
            public void onWatchChange(SnapshotVersion snapshotVersion, WatchChange watchChange) {
                RemoteStore.this.handleWatchChange(snapshotVersion, watchChange);
            }

            @Override
            public void onClose(Status status) {
                RemoteStore.this.handleWatchStreamClose(status);
            }
        });
        this.writeStream = datastore.createWriteStream(new WriteStream.Callback(){

            @Override
            public void onOpen() {
                RemoteStore.this.writeStream.writeHandshake();
            }

            @Override
            public void onHandshakeComplete() {
                RemoteStore.this.handleWriteStreamHandshakeComplete();
            }

            @Override
            public void onWriteResponse(SnapshotVersion commitVersion, List<MutationResult> mutationResults) {
                RemoteStore.this.handleWriteStreamMutationResults(commitVersion, mutationResults);
            }

            @Override
            public void onClose(Status status) {
                RemoteStore.this.handleWriteStreamClose(status);
            }
        });
    }

    public void enableNetwork() {
        this.networkEnabled = true;
        if (this.canUseNetwork()) {
            this.writeStream.setLastStreamToken(this.localStore.getLastStreamToken());
            if (this.shouldStartWatchStream()) {
                this.startWatchStream();
            } else {
                this.onlineStateTracker.updateState(OnlineState.UNKNOWN);
            }
            this.fillWritePipeline();
        }
    }

    public void disableNetwork() {
        this.networkEnabled = false;
        this.disableNetworkInternal();
        this.onlineStateTracker.updateState(OnlineState.OFFLINE);
    }

    private void disableNetworkInternal() {
        this.watchStream.stop();
        this.writeStream.stop();
        if (!this.writePipeline.isEmpty()) {
            Logger.debug(LOG_TAG, "Stopping write stream with %d pending writes", this.writePipeline.size());
            this.writePipeline.clear();
        }
        this.cleanUpWatchStreamState();
    }

    public void start() {
        this.enableNetwork();
    }

    public void shutdown() {
        Logger.debug(LOG_TAG, "Shutting down", new Object[0]);
        this.networkEnabled = false;
        this.disableNetworkInternal();
        this.datastore.shutdown();
        this.onlineStateTracker.updateState(OnlineState.UNKNOWN);
    }

    public void handleCredentialChange() {
        if (this.canUseNetwork()) {
            Logger.debug(LOG_TAG, "Restarting streams for new credential.", new Object[0]);
            this.networkEnabled = false;
            this.disableNetworkInternal();
            this.onlineStateTracker.updateState(OnlineState.UNKNOWN);
            this.enableNetwork();
        }
    }

    public void listen(QueryData queryData) {
        Integer targetId = queryData.getTargetId();
        Assert.hardAssert(!this.listenTargets.containsKey(targetId), "listen called with duplicate target ID: %d", targetId);
        this.listenTargets.put(targetId, queryData);
        if (this.shouldStartWatchStream()) {
            this.startWatchStream();
        } else if (this.watchStream.isOpen()) {
            this.sendWatchRequest(queryData);
        }
    }

    private void sendWatchRequest(QueryData queryData) {
        this.watchChangeAggregator.recordPendingTargetRequest(queryData.getTargetId());
        this.watchStream.watchQuery(queryData);
    }

    public void stopListening(int targetId) {
        QueryData queryData = this.listenTargets.remove(targetId);
        Assert.hardAssert(queryData != null, "stopListening called on target no currently watched: %d", targetId);
        if (this.watchStream.isOpen()) {
            this.sendUnwatchRequest(targetId);
        }
        if (this.listenTargets.isEmpty()) {
            if (this.watchStream.isOpen()) {
                this.watchStream.markIdle();
            } else if (this.canUseNetwork()) {
                this.onlineStateTracker.updateState(OnlineState.UNKNOWN);
            }
        }
    }

    private void sendUnwatchRequest(int targetId) {
        this.watchChangeAggregator.recordPendingTargetRequest(targetId);
        this.watchStream.unwatchTarget(targetId);
    }

    private boolean shouldStartWriteStream() {
        return this.canUseNetwork() && !this.writeStream.isStarted() && !this.writePipeline.isEmpty();
    }

    private boolean shouldStartWatchStream() {
        return this.canUseNetwork() && !this.watchStream.isStarted() && !this.listenTargets.isEmpty();
    }

    private void cleanUpWatchStreamState() {
        this.watchChangeAggregator = null;
    }

    private void startWatchStream() {
        Assert.hardAssert(this.shouldStartWatchStream(), "startWatchStream() called when shouldStartWatchStream() is false.", new Object[0]);
        this.watchChangeAggregator = new WatchChangeAggregator(this);
        this.watchStream.start();
        this.onlineStateTracker.handleWatchStreamStart();
    }

    private void handleWatchStreamOpen() {
        for (QueryData queryData : this.listenTargets.values()) {
            this.sendWatchRequest(queryData);
        }
    }

    private void handleWatchChange(SnapshotVersion snapshotVersion, WatchChange watchChange) {
        WatchChange.WatchTargetChange watchTargetChange;
        this.onlineStateTracker.updateState(OnlineState.ONLINE);
        Assert.hardAssert(this.watchStream != null && this.watchChangeAggregator != null, "WatchStream and WatchStreamAggregator should both be non-null", new Object[0]);
        WatchChange.WatchTargetChange watchTargetChange2 = watchTargetChange = watchChange instanceof WatchChange.WatchTargetChange ? (WatchChange.WatchTargetChange)watchChange : null;
        if (watchTargetChange != null && watchTargetChange.getChangeType().equals((Object)WatchChange.WatchTargetChangeType.Removed) && watchTargetChange.getCause() != null) {
            this.processTargetError(watchTargetChange);
        } else {
            SnapshotVersion lastRemoteSnapshotVersion;
            if (watchChange instanceof WatchChange.DocumentChange) {
                this.watchChangeAggregator.handleDocumentChange((WatchChange.DocumentChange)watchChange);
            } else if (watchChange instanceof WatchChange.ExistenceFilterWatchChange) {
                this.watchChangeAggregator.handleExistenceFilter((WatchChange.ExistenceFilterWatchChange)watchChange);
            } else {
                Assert.hardAssert(watchChange instanceof WatchChange.WatchTargetChange, "Expected watchChange to be an instance of WatchTargetChange", new Object[0]);
                this.watchChangeAggregator.handleTargetChange((WatchChange.WatchTargetChange)watchChange);
            }
            if (!snapshotVersion.equals(SnapshotVersion.NONE) && snapshotVersion.compareTo(lastRemoteSnapshotVersion = this.localStore.getLastRemoteSnapshotVersion()) >= 0) {
                this.raiseWatchSnapshot(snapshotVersion);
            }
        }
    }

    private void handleWatchStreamClose(Status status) {
        if (Status.OK.equals((Object)status)) {
            Assert.hardAssert(!this.shouldStartWatchStream(), "Watch stream was stopped gracefully while still needed.", new Object[0]);
        }
        this.cleanUpWatchStreamState();
        if (this.shouldStartWatchStream()) {
            this.onlineStateTracker.handleWatchStreamFailure(status);
            this.startWatchStream();
        } else {
            this.onlineStateTracker.updateState(OnlineState.UNKNOWN);
        }
    }

    private boolean canUseNetwork() {
        return this.networkEnabled;
    }

    private void raiseWatchSnapshot(SnapshotVersion snapshotVersion) {
        Assert.hardAssert(!snapshotVersion.equals(SnapshotVersion.NONE), "Can't raise event for unknown SnapshotVersion", new Object[0]);
        RemoteEvent remoteEvent = this.watchChangeAggregator.createRemoteEvent(snapshotVersion);
        for (Map.Entry<Integer, TargetChange> entry : remoteEvent.getTargetChanges().entrySet()) {
            int targetId;
            QueryData queryData;
            TargetChange targetChange = entry.getValue();
            if (targetChange.getResumeToken().isEmpty() || (queryData = this.listenTargets.get(targetId = entry.getKey().intValue())) == null) continue;
            this.listenTargets.put(targetId, queryData.copy(snapshotVersion, targetChange.getResumeToken(), queryData.getSequenceNumber()));
        }
        Iterator<Object> iterator = remoteEvent.getTargetMismatches().iterator();
        while (iterator.hasNext()) {
            int targetId = (Integer)iterator.next();
            QueryData queryData = this.listenTargets.get(targetId);
            if (queryData == null) continue;
            this.listenTargets.put(targetId, queryData.copy(queryData.getSnapshotVersion(), ByteString.EMPTY, queryData.getSequenceNumber()));
            this.sendUnwatchRequest(targetId);
            QueryData requestQueryData = new QueryData(queryData.getQuery(), targetId, queryData.getSequenceNumber(), QueryPurpose.EXISTENCE_FILTER_MISMATCH);
            this.sendWatchRequest(requestQueryData);
        }
        this.remoteStoreCallback.handleRemoteEvent(remoteEvent);
    }

    private void processTargetError(WatchChange.WatchTargetChange targetChange) {
        Assert.hardAssert(targetChange.getCause() != null, "Processing target error without a cause", new Object[0]);
        for (Integer targetId : targetChange.getTargetIds()) {
            if (!this.listenTargets.containsKey(targetId)) continue;
            this.listenTargets.remove(targetId);
            this.watchChangeAggregator.removeTarget(targetId);
            this.remoteStoreCallback.handleRejectedListen(targetId, targetChange.getCause());
        }
    }

    public void fillWritePipeline() {
        int lastBatchIdRetrieved;
        int n = lastBatchIdRetrieved = this.writePipeline.isEmpty() ? -1 : this.writePipeline.getLast().getBatchId();
        while (this.canAddToWritePipeline()) {
            MutationBatch batch = this.localStore.getNextMutationBatch(lastBatchIdRetrieved);
            if (batch == null) {
                if (this.writePipeline.size() != 0) break;
                this.writeStream.markIdle();
                break;
            }
            this.addToWritePipeline(batch);
            lastBatchIdRetrieved = batch.getBatchId();
        }
        if (this.shouldStartWriteStream()) {
            this.startWriteStream();
        }
    }

    private boolean canAddToWritePipeline() {
        return this.canUseNetwork() && this.writePipeline.size() < 10;
    }

    private void addToWritePipeline(MutationBatch mutationBatch) {
        Assert.hardAssert(this.canAddToWritePipeline(), "addToWritePipeline called when pipeline is full", new Object[0]);
        this.writePipeline.add(mutationBatch);
        if (this.writeStream.isOpen() && this.writeStream.isHandshakeComplete()) {
            this.writeStream.writeMutations(mutationBatch.getMutations());
        }
    }

    private void startWriteStream() {
        Assert.hardAssert(this.shouldStartWriteStream(), "startWriteStream() called when shouldStartWriteStream() is false.", new Object[0]);
        this.writeStream.start();
    }

    private void handleWriteStreamHandshakeComplete() {
        this.localStore.setLastStreamToken(this.writeStream.getLastStreamToken());
        for (MutationBatch batch : this.writePipeline) {
            this.writeStream.writeMutations(batch.getMutations());
        }
    }

    private void handleWriteStreamMutationResults(SnapshotVersion commitVersion, List<MutationResult> results) {
        MutationBatch batch = this.writePipeline.poll();
        MutationBatchResult mutationBatchResult = MutationBatchResult.create(batch, commitVersion, results, this.writeStream.getLastStreamToken());
        this.remoteStoreCallback.handleSuccessfulWrite(mutationBatchResult);
        this.fillWritePipeline();
    }

    private void handleWriteStreamClose(Status status) {
        if (Status.OK.equals((Object)status)) {
            Assert.hardAssert(!this.shouldStartWriteStream(), "Write stream was stopped gracefully while still needed.", new Object[0]);
        }
        if (!status.isOk() && !this.writePipeline.isEmpty()) {
            if (this.writeStream.isHandshakeComplete()) {
                this.handleWriteError(status);
            } else {
                this.handleWriteHandshakeError(status);
            }
        }
        if (this.shouldStartWriteStream()) {
            this.startWriteStream();
        }
    }

    private void handleWriteHandshakeError(Status status) {
        Assert.hardAssert(!status.isOk(), "Handling write error with status OK.", new Object[0]);
        if (Datastore.isPermanentError(status)) {
            String token = Util.toDebugString(this.writeStream.getLastStreamToken());
            Logger.debug(LOG_TAG, "RemoteStore error before completed handshake; resetting stream token %s: %s", token, status);
            this.writeStream.setLastStreamToken(WriteStream.EMPTY_STREAM_TOKEN);
            this.localStore.setLastStreamToken(WriteStream.EMPTY_STREAM_TOKEN);
        }
    }

    private void handleWriteError(Status status) {
        Assert.hardAssert(!status.isOk(), "Handling write error with status OK.", new Object[0]);
        if (Datastore.isPermanentWriteError(status)) {
            MutationBatch batch = this.writePipeline.poll();
            this.writeStream.inhibitBackoff();
            this.remoteStoreCallback.handleRejectedWrite(batch.getBatchId(), status);
            this.fillWritePipeline();
        }
    }

    public Transaction createTransaction() {
        return new Transaction(this.datastore);
    }

    @Override
    public ImmutableSortedSet<DocumentKey> getRemoteKeysForTarget(int targetId) {
        return this.remoteStoreCallback.getRemoteKeysForTarget(targetId);
    }

    @Override
    @Nullable
    public QueryData getQueryDataForTarget(int targetId) {
        return this.listenTargets.get(targetId);
    }

    public static interface RemoteStoreCallback {
        public void handleRemoteEvent(RemoteEvent var1);

        public void handleRejectedListen(int var1, Status var2);

        public void handleSuccessfulWrite(MutationBatchResult var1);

        public void handleRejectedWrite(int var1, Status var2);

        public void handleOnlineStateChange(OnlineState var1);

        public ImmutableSortedSet<DocumentKey> getRemoteKeysForTarget(int var1);
    }
}

