/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.util;

import android.app.Activity;
import android.app.Fragment;
import android.support.v4.app.FragmentActivity;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.core.FirestoreClient;
import com.google.firebase.firestore.core.QueryListener;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.ExecutorEventListener;
import com.google.firebase.firestore.util.ListenerRegistrationImpl$$Lambda$1;
import com.google.firebase.firestore.util.ListenerRegistrationImpl$$Lambda$2;
import com.google.firebase.firestore.util.ListenerRegistrationImpl$$Lambda$3;
import com.google.firebase.firestore.util.ListenerRegistrationImpl$$Lambda$4;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ListenerRegistrationImpl
implements ListenerRegistration {
    private final FirestoreClient client;
    private final QueryListener queryListener;
    private final ExecutorEventListener<ViewSnapshot> asyncEventListener;
    private static final String SUPPORT_FRAGMENT_TAG = "FirestoreOnStopObserverSupportFragment";
    private static final String FRAGMENT_TAG = "FirestoreOnStopObserverFragment";

    @Nullable
    private static <T> T castFragment(Class<T> fragmentClass, @Nullable Object fragment, String tag) {
        try {
            return fragmentClass.cast(fragment);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Fragment with tag '" + tag + "' is a " + fragment.getClass().getName() + " but should be a " + fragmentClass.getName());
        }
    }

    private void onActivityStopCallOnce(Activity activity, Runnable callback) {
        Assert.hardAssert(!(activity instanceof FragmentActivity), "onActivityStopCallOnce must be called with a *non*-FragmentActivity Activity.", new Object[0]);
        activity.runOnUiThread(ListenerRegistrationImpl$$Lambda$1.lambdaFactory$(activity, callback));
    }

    private void onFragmentActivityStopCallOnce(FragmentActivity activity, Runnable callback) {
        activity.runOnUiThread(ListenerRegistrationImpl$$Lambda$2.lambdaFactory$(activity, callback));
    }

    public ListenerRegistrationImpl(FirestoreClient client, QueryListener queryListener, @Nullable Activity activity, ExecutorEventListener<ViewSnapshot> asyncEventListener) {
        this.client = client;
        this.queryListener = queryListener;
        this.asyncEventListener = asyncEventListener;
        if (activity != null) {
            if (activity instanceof FragmentActivity) {
                this.onFragmentActivityStopCallOnce((FragmentActivity)activity, ListenerRegistrationImpl$$Lambda$3.lambdaFactory$(this));
            } else {
                this.onActivityStopCallOnce(activity, ListenerRegistrationImpl$$Lambda$4.lambdaFactory$(this));
            }
        }
    }

    @Override
    public void remove() {
        this.asyncEventListener.mute();
        this.client.stopListening(this.queryListener);
    }

    static /* synthetic */ void lambda$onFragmentActivityStopCallOnce$1(FragmentActivity activity, Runnable callback) {
        StopListenerSupportFragment fragment = ListenerRegistrationImpl.castFragment(StopListenerSupportFragment.class, activity.getSupportFragmentManager().findFragmentByTag(SUPPORT_FRAGMENT_TAG), SUPPORT_FRAGMENT_TAG);
        if (fragment == null || fragment.isRemoving()) {
            fragment = new StopListenerSupportFragment();
            activity.getSupportFragmentManager().beginTransaction().add((android.support.v4.app.Fragment)fragment, SUPPORT_FRAGMENT_TAG).commitAllowingStateLoss();
            activity.getSupportFragmentManager().executePendingTransactions();
        }
        fragment.callbacks.add(callback);
    }

    static /* synthetic */ void lambda$onActivityStopCallOnce$0(Activity activity, Runnable callback) {
        StopListenerFragment fragment = ListenerRegistrationImpl.castFragment(StopListenerFragment.class, activity.getFragmentManager().findFragmentByTag(FRAGMENT_TAG), FRAGMENT_TAG);
        if (fragment == null || fragment.isRemoving()) {
            fragment = new StopListenerFragment();
            activity.getFragmentManager().beginTransaction().add((Fragment)fragment, FRAGMENT_TAG).commitAllowingStateLoss();
            activity.getFragmentManager().executePendingTransactions();
        }
        fragment.callbacks.add(callback);
    }

    public static class StopListenerFragment
    extends Fragment {
        CallbackList callbacks = new CallbackList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStop() {
            CallbackList callbacksCopy;
            super.onStop();
            CallbackList callbackList = this.callbacks;
            synchronized (callbackList) {
                callbacksCopy = this.callbacks;
                this.callbacks = new CallbackList();
            }
            callbacksCopy.run();
        }
    }

    public static class StopListenerSupportFragment
    extends android.support.v4.app.Fragment {
        CallbackList callbacks = new CallbackList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStop() {
            CallbackList callbacksCopy;
            super.onStop();
            CallbackList callbackList = this.callbacks;
            synchronized (callbackList) {
                callbacksCopy = this.callbacks;
                this.callbacks = new CallbackList();
            }
            callbacksCopy.run();
        }
    }

    static class CallbackList {
        private final List<Runnable> callbacks = new ArrayList<Runnable>();

        CallbackList() {
        }

        void run() {
            for (Runnable callback : this.callbacks) {
                if (callback == null) continue;
                callback.run();
            }
        }

        synchronized void add(Runnable callback) {
            this.callbacks.add(callback);
        }
    }
}

