/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.NaNFilter;
import com.google.firebase.firestore.core.NullFilter;
import com.google.firebase.firestore.core.RelationFilter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.value.DoubleValue;
import com.google.firebase.firestore.model.value.FieldValue;
import com.google.firebase.firestore.model.value.NullValue;

public abstract class Filter {
    public static Filter create(FieldPath path, Operator operator, FieldValue value) {
        if (value.equals(NullValue.nullValue())) {
            if (operator != Operator.EQUAL) {
                throw new IllegalArgumentException("Invalid Query. You can only perform equality comparisons on null (via whereEqualTo()).");
            }
            return new NullFilter(path);
        }
        if (value.equals(DoubleValue.NaN)) {
            if (operator != Operator.EQUAL) {
                throw new IllegalArgumentException("Invalid Query. You can only perform equality comparisons on NaN (via whereEqualTo()).");
            }
            return new NaNFilter(path);
        }
        return new RelationFilter(path, operator, value);
    }

    public abstract FieldPath getField();

    public abstract boolean matches(Document var1);

    public abstract String getCanonicalId();

    public static enum Operator {
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        EQUAL("=="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        ARRAY_CONTAINS("array_contains");

        private final String text;

        private Operator(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

