/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.util.SparseArray;
import com.google.firebase.Timestamp;
import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.TargetIdGenerator;
import com.google.firebase.firestore.local.LocalDocumentsView;
import com.google.firebase.firestore.local.LocalStore$$Lambda$1;
import com.google.firebase.firestore.local.LocalStore$$Lambda$10;
import com.google.firebase.firestore.local.LocalStore$$Lambda$2;
import com.google.firebase.firestore.local.LocalStore$$Lambda$3;
import com.google.firebase.firestore.local.LocalStore$$Lambda$4;
import com.google.firebase.firestore.local.LocalStore$$Lambda$5;
import com.google.firebase.firestore.local.LocalStore$$Lambda$6;
import com.google.firebase.firestore.local.LocalStore$$Lambda$7;
import com.google.firebase.firestore.local.LocalStore$$Lambda$8;
import com.google.firebase.firestore.local.LocalStore$$Lambda$9;
import com.google.firebase.firestore.local.LocalViewChanges;
import com.google.firebase.firestore.local.LocalWriteResult;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.QueryCache;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.local.QueryEngine;
import com.google.firebase.firestore.local.QueryPurpose;
import com.google.firebase.firestore.local.ReferenceSet;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.local.SimpleQueryEngine;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.SnapshotVersion;
import com.google.firebase.firestore.model.mutation.Mutation;
import com.google.firebase.firestore.model.mutation.MutationBatch;
import com.google.firebase.firestore.model.mutation.MutationBatchResult;
import com.google.firebase.firestore.remote.RemoteEvent;
import com.google.firebase.firestore.remote.TargetChange;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Logger;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class LocalStore {
    private static final long RESUME_TOKEN_MAX_AGE_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    private final Persistence persistence;
    private MutationQueue mutationQueue;
    private final RemoteDocumentCache remoteDocuments;
    private LocalDocumentsView localDocuments;
    private QueryEngine queryEngine;
    private final ReferenceSet localViewReferences;
    private final QueryCache queryCache;
    private final SparseArray<QueryData> targetIds;
    private final TargetIdGenerator targetIdGenerator;

    public LocalStore(Persistence persistence, User initialUser) {
        Assert.hardAssert(persistence.isStarted(), "LocalStore was passed an unstarted persistence implementation", new Object[0]);
        this.persistence = persistence;
        this.queryCache = persistence.getQueryCache();
        this.targetIdGenerator = TargetIdGenerator.forQueryCache(this.queryCache.getHighestTargetId());
        this.mutationQueue = persistence.getMutationQueue(initialUser);
        this.remoteDocuments = persistence.getRemoteDocumentCache();
        this.localDocuments = new LocalDocumentsView(this.remoteDocuments, this.mutationQueue);
        this.queryEngine = new SimpleQueryEngine(this.localDocuments);
        this.localViewReferences = new ReferenceSet();
        persistence.getReferenceDelegate().setInMemoryPins(this.localViewReferences);
        this.targetIds = new SparseArray();
    }

    public void start() {
        this.startMutationQueue();
    }

    private void startMutationQueue() {
        this.persistence.runTransaction("Start MutationQueue", LocalStore$$Lambda$1.lambdaFactory$(this));
    }

    public ImmutableSortedMap<DocumentKey, MaybeDocument> handleUserChange(User user) {
        List<MutationBatch> oldBatches = this.mutationQueue.getAllMutationBatches();
        this.mutationQueue = this.persistence.getMutationQueue(user);
        this.startMutationQueue();
        List<MutationBatch> newBatches = this.mutationQueue.getAllMutationBatches();
        this.localDocuments = new LocalDocumentsView(this.remoteDocuments, this.mutationQueue);
        this.queryEngine = new SimpleQueryEngine(this.localDocuments);
        ImmutableSortedSet changedKeys = DocumentKey.emptyKeySet();
        for (List batches : Arrays.asList(oldBatches, newBatches)) {
            for (MutationBatch batch : batches) {
                for (Mutation mutation : batch.getMutations()) {
                    changedKeys = changedKeys.insert((Object)mutation.getKey());
                }
            }
        }
        return this.localDocuments.getDocuments((Iterable<DocumentKey>)changedKeys);
    }

    public LocalWriteResult writeLocally(List<Mutation> mutations) {
        Timestamp localWriteTime = Timestamp.now();
        MutationBatch batch = (MutationBatch)this.persistence.runTransaction("Locally write mutations", LocalStore$$Lambda$2.lambdaFactory$(this, localWriteTime, mutations));
        Set<DocumentKey> keys = batch.getKeys();
        ImmutableSortedMap<DocumentKey, MaybeDocument> changedDocuments = this.localDocuments.getDocuments(keys);
        return new LocalWriteResult(batch.getBatchId(), changedDocuments);
    }

    public ImmutableSortedMap<DocumentKey, MaybeDocument> acknowledgeBatch(MutationBatchResult batchResult) {
        return (ImmutableSortedMap)this.persistence.runTransaction("Acknowledge batch", LocalStore$$Lambda$3.lambdaFactory$(this, batchResult));
    }

    public ImmutableSortedMap<DocumentKey, MaybeDocument> rejectBatch(int batchId) {
        return (ImmutableSortedMap)this.persistence.runTransaction("Reject batch", LocalStore$$Lambda$4.lambdaFactory$(this, batchId));
    }

    public ByteString getLastStreamToken() {
        return this.mutationQueue.getLastStreamToken();
    }

    public void setLastStreamToken(ByteString streamToken) {
        this.persistence.runTransaction("Set stream token", LocalStore$$Lambda$5.lambdaFactory$(this, streamToken));
    }

    public SnapshotVersion getLastRemoteSnapshotVersion() {
        return this.queryCache.getLastRemoteSnapshotVersion();
    }

    public ImmutableSortedMap<DocumentKey, MaybeDocument> applyRemoteEvent(RemoteEvent remoteEvent) {
        return (ImmutableSortedMap)this.persistence.runTransaction("Apply remote event", LocalStore$$Lambda$6.lambdaFactory$(this, remoteEvent));
    }

    private static boolean shouldPersistQueryData(QueryData oldQueryData, QueryData newQueryData, TargetChange change) {
        long oldSeconds;
        if (newQueryData.getResumeToken().isEmpty()) {
            return false;
        }
        if (oldQueryData.getResumeToken().isEmpty()) {
            return true;
        }
        long newSeconds = newQueryData.getSnapshotVersion().getTimestamp().getSeconds();
        long timeDelta = newSeconds - (oldSeconds = oldQueryData.getSnapshotVersion().getTimestamp().getSeconds());
        if (timeDelta >= RESUME_TOKEN_MAX_AGE_SECONDS) {
            return true;
        }
        int changes = change.getAddedDocuments().size() + change.getModifiedDocuments().size() + change.getRemovedDocuments().size();
        return changes > 0;
    }

    public void notifyLocalViewChanges(List<LocalViewChanges> viewChanges) {
        this.persistence.runTransaction("notifyLocalViewChanges", LocalStore$$Lambda$7.lambdaFactory$(this, viewChanges));
    }

    @Nullable
    public MutationBatch getNextMutationBatch(int afterBatchId) {
        return this.mutationQueue.getNextMutationBatchAfterBatchId(afterBatchId);
    }

    @Nullable
    public MaybeDocument readDocument(DocumentKey key) {
        return this.localDocuments.getDocument(key);
    }

    public QueryData allocateQuery(Query query) {
        int targetId;
        QueryData cached = this.queryCache.getQueryData(query);
        if (cached != null) {
            targetId = cached.getTargetId();
        } else {
            AllocateQueryHolder holder = new AllocateQueryHolder();
            this.persistence.runTransaction("Allocate query", LocalStore$$Lambda$8.lambdaFactory$(this, holder, query));
            targetId = holder.targetId;
            cached = holder.cached;
        }
        Assert.hardAssert(this.targetIds.get(targetId) == null, "Tried to allocate an already allocated query: %s", query);
        this.targetIds.put(targetId, (Object)cached);
        return cached;
    }

    public void releaseQuery(Query query) {
        this.persistence.runTransaction("Release query", LocalStore$$Lambda$9.lambdaFactory$(this, query));
    }

    public ImmutableSortedMap<DocumentKey, Document> executeQuery(Query query) {
        return this.queryEngine.getDocumentsMatchingQuery(query);
    }

    public ImmutableSortedSet<DocumentKey> getRemoteDocumentKeys(int targetId) {
        return this.queryCache.getMatchingKeysForTargetId(targetId);
    }

    private void applyWriteToRemoteDocuments(MutationBatchResult batchResult) {
        MutationBatch batch = batchResult.getBatch();
        Set<DocumentKey> docKeys = batch.getKeys();
        for (DocumentKey docKey : docKeys) {
            MaybeDocument remoteDoc;
            MaybeDocument doc = remoteDoc = this.remoteDocuments.get(docKey);
            SnapshotVersion ackVersion = (SnapshotVersion)batchResult.getDocVersions().get((Object)docKey);
            Assert.hardAssert(ackVersion != null, "docVersions should contain every doc in the write.", new Object[0]);
            if (doc != null && doc.getVersion().compareTo(ackVersion) >= 0) continue;
            if ((doc = batch.applyToRemoteDocument(docKey, doc, batchResult)) == null) {
                Assert.hardAssert(remoteDoc == null, "Mutation batch %s applied to document %s resulted in null.", batch, remoteDoc);
                continue;
            }
            this.remoteDocuments.add(doc);
        }
        this.mutationQueue.removeMutationBatch(batch);
    }

    public LruGarbageCollector.Results collectGarbage(LruGarbageCollector garbageCollector) {
        return (LruGarbageCollector.Results)this.persistence.runTransaction("Collect garbage", LocalStore$$Lambda$10.lambdaFactory$(this, garbageCollector));
    }

    static /* synthetic */ LruGarbageCollector.Results lambda$collectGarbage$9(LocalStore this_, LruGarbageCollector garbageCollector) {
        return garbageCollector.collect(this_.targetIds);
    }

    static /* synthetic */ void lambda$releaseQuery$8(LocalStore this_, Query query) {
        QueryData queryData = this_.queryCache.getQueryData(query);
        Assert.hardAssert(queryData != null, "Tried to release nonexistent query: %s", query);
        int targetId = queryData.getTargetId();
        QueryData cachedQueryData = (QueryData)this_.targetIds.get(targetId);
        if (cachedQueryData.getSnapshotVersion().compareTo(queryData.getSnapshotVersion()) > 0) {
            queryData = cachedQueryData;
            this_.queryCache.updateQueryData(queryData);
        }
        ImmutableSortedSet<DocumentKey> removedReferences = this_.localViewReferences.removeReferencesForId(queryData.getTargetId());
        for (DocumentKey key : removedReferences) {
            this_.persistence.getReferenceDelegate().removeReference(key);
        }
        this_.persistence.getReferenceDelegate().removeTarget(queryData);
        this_.targetIds.remove(queryData.getTargetId());
    }

    static /* synthetic */ void lambda$allocateQuery$7(LocalStore this_, AllocateQueryHolder holder, Query query) {
        holder.targetId = this_.targetIdGenerator.nextId();
        holder.cached = new QueryData(query, holder.targetId, this_.persistence.getReferenceDelegate().getCurrentSequenceNumber(), QueryPurpose.LISTEN);
        this_.queryCache.addQueryData(holder.cached);
    }

    static /* synthetic */ void lambda$notifyLocalViewChanges$6(LocalStore this_, List viewChanges) {
        for (LocalViewChanges viewChange : viewChanges) {
            this_.localViewReferences.addReferences(viewChange.getAdded(), viewChange.getTargetId());
            ImmutableSortedSet<DocumentKey> removed = viewChange.getRemoved();
            for (DocumentKey key : removed) {
                this_.persistence.getReferenceDelegate().removeReference(key);
            }
            this_.localViewReferences.removeReferences(removed, viewChange.getTargetId());
        }
    }

    static /* synthetic */ ImmutableSortedMap lambda$applyRemoteEvent$5(LocalStore this_, RemoteEvent remoteEvent) {
        long sequenceNumber = this_.persistence.getReferenceDelegate().getCurrentSequenceNumber();
        HashSet<DocumentKey> authoritativeUpdates = new HashSet<DocumentKey>();
        Map<Integer, TargetChange> targetChanges = remoteEvent.getTargetChanges();
        for (Map.Entry<Integer, TargetChange> entry : targetChanges.entrySet()) {
            Integer boxedTargetId = entry.getKey();
            int targetId = boxedTargetId;
            TargetChange change = entry.getValue();
            QueryData queryData = (QueryData)this_.targetIds.get(targetId);
            if (queryData == null) continue;
            for (DocumentKey key : change.getAddedDocuments()) {
                authoritativeUpdates.add(key);
            }
            for (DocumentKey key : change.getModifiedDocuments()) {
                authoritativeUpdates.add(key);
            }
            this_.queryCache.removeMatchingKeys(change.getRemovedDocuments(), targetId);
            this_.queryCache.addMatchingKeys(change.getAddedDocuments(), targetId);
            ByteString resumeToken = change.getResumeToken();
            if (resumeToken.isEmpty()) continue;
            QueryData oldQueryData = queryData;
            queryData = queryData.copy(remoteEvent.getSnapshotVersion(), resumeToken, sequenceNumber);
            this_.targetIds.put(boxedTargetId.intValue(), (Object)queryData);
            if (!LocalStore.shouldPersistQueryData(oldQueryData, queryData, change)) continue;
            this_.queryCache.updateQueryData(queryData);
        }
        HashMap<DocumentKey, MaybeDocument> changedDocs = new HashMap<DocumentKey, MaybeDocument>();
        Map<DocumentKey, MaybeDocument> documentUpdates = remoteEvent.getDocumentUpdates();
        Set<DocumentKey> limboDocuments = remoteEvent.getResolvedLimboDocuments();
        Map<DocumentKey, MaybeDocument> existingDocs = this_.remoteDocuments.getAll(documentUpdates.keySet());
        for (Map.Entry entry : documentUpdates.entrySet()) {
            DocumentKey key = (DocumentKey)entry.getKey();
            MaybeDocument doc = (MaybeDocument)entry.getValue();
            MaybeDocument existingDoc = existingDocs.get(key);
            if (existingDoc == null || doc.getVersion().equals(SnapshotVersion.NONE) || authoritativeUpdates.contains(doc.getKey()) && !existingDoc.hasPendingWrites() || doc.getVersion().compareTo(existingDoc.getVersion()) >= 0) {
                this_.remoteDocuments.add(doc);
                changedDocs.put(key, doc);
            } else {
                Logger.debug("LocalStore", "Ignoring outdated watch update for %s.Current version: %s  Watch version: %s", key, existingDoc.getVersion(), doc.getVersion());
            }
            if (!limboDocuments.contains(key)) continue;
            this_.persistence.getReferenceDelegate().updateLimboDocument(key);
        }
        SnapshotVersion lastRemoteVersion = this_.queryCache.getLastRemoteSnapshotVersion();
        SnapshotVersion remoteVersion = remoteEvent.getSnapshotVersion();
        if (!remoteVersion.equals(SnapshotVersion.NONE)) {
            Assert.hardAssert(remoteVersion.compareTo(lastRemoteVersion) >= 0, "Watch stream reverted to previous snapshot?? (%s < %s)", remoteVersion, lastRemoteVersion);
            this_.queryCache.setLastRemoteSnapshotVersion(remoteVersion);
        }
        return this_.localDocuments.getLocalViewOfDocuments(changedDocs);
    }

    static /* synthetic */ void lambda$setLastStreamToken$4(LocalStore this_, ByteString streamToken) {
        this_.mutationQueue.setLastStreamToken(streamToken);
    }

    static /* synthetic */ ImmutableSortedMap lambda$rejectBatch$3(LocalStore this_, int batchId) {
        MutationBatch toReject = this_.mutationQueue.lookupMutationBatch(batchId);
        Assert.hardAssert(toReject != null, "Attempt to reject nonexistent batch!", new Object[0]);
        this_.mutationQueue.removeMutationBatch(toReject);
        this_.mutationQueue.performConsistencyCheck();
        return this_.localDocuments.getDocuments(toReject.getKeys());
    }

    static /* synthetic */ ImmutableSortedMap lambda$acknowledgeBatch$2(LocalStore this_, MutationBatchResult batchResult) {
        MutationBatch batch = batchResult.getBatch();
        this_.mutationQueue.acknowledgeBatch(batch, batchResult.getStreamToken());
        this_.applyWriteToRemoteDocuments(batchResult);
        this_.mutationQueue.performConsistencyCheck();
        return this_.localDocuments.getDocuments(batch.getKeys());
    }

    static /* synthetic */ MutationBatch lambda$writeLocally$1(LocalStore this_, Timestamp localWriteTime, List mutations) {
        return this_.mutationQueue.addMutationBatch(localWriteTime, mutations);
    }

    static /* synthetic */ void lambda$startMutationQueue$0(LocalStore this_) {
        this_.mutationQueue.start();
    }

    private static class AllocateQueryHolder {
        QueryData cached;
        int targetId;

        private AllocateQueryHolder() {
        }
    }
}

