/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.MemoryEagerReferenceDelegate;
import com.google.firebase.firestore.local.MemoryLruReferenceDelegate;
import com.google.firebase.firestore.local.MemoryMutationQueue;
import com.google.firebase.firestore.local.MemoryQueryCache;
import com.google.firebase.firestore.local.MemoryRemoteDocumentCache;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.ReferenceDelegate;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Supplier;
import java.util.HashMap;
import java.util.Map;

public final class MemoryPersistence
extends Persistence {
    private final Map<User, MemoryMutationQueue> mutationQueues = new HashMap<User, MemoryMutationQueue>();
    private final MemoryQueryCache queryCache = new MemoryQueryCache(this);
    private final MemoryRemoteDocumentCache remoteDocumentCache = new MemoryRemoteDocumentCache();
    private ReferenceDelegate referenceDelegate;
    private boolean started;

    public static MemoryPersistence createEagerGcMemoryPersistence() {
        MemoryPersistence persistence = new MemoryPersistence();
        persistence.setReferenceDelegate(new MemoryEagerReferenceDelegate(persistence));
        return persistence;
    }

    public static MemoryPersistence createLruGcMemoryPersistence(LruGarbageCollector.Params params, LocalSerializer serializer) {
        MemoryPersistence persistence = new MemoryPersistence();
        persistence.setReferenceDelegate(new MemoryLruReferenceDelegate(persistence, params, serializer));
        return persistence;
    }

    private MemoryPersistence() {
    }

    @Override
    public void start() {
        Assert.hardAssert(!this.started, "MemoryPersistence double-started!", new Object[0]);
        this.started = true;
    }

    @Override
    public void shutdown() {
        Assert.hardAssert(this.started, "MemoryPersistence shutdown without start", new Object[0]);
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    ReferenceDelegate getReferenceDelegate() {
        return this.referenceDelegate;
    }

    private void setReferenceDelegate(ReferenceDelegate delegate) {
        this.referenceDelegate = delegate;
    }

    @Override
    MutationQueue getMutationQueue(User user) {
        MemoryMutationQueue queue = this.mutationQueues.get(user);
        if (queue == null) {
            queue = new MemoryMutationQueue(this);
            this.mutationQueues.put(user, queue);
        }
        return queue;
    }

    Iterable<MemoryMutationQueue> getMutationQueues() {
        return this.mutationQueues.values();
    }

    @Override
    MemoryQueryCache getQueryCache() {
        return this.queryCache;
    }

    @Override
    MemoryRemoteDocumentCache getRemoteDocumentCache() {
        return this.remoteDocumentCache;
    }

    @Override
    void runTransaction(String action, Runnable operation) {
        this.referenceDelegate.onTransactionStarted();
        try {
            operation.run();
        }
        finally {
            this.referenceDelegate.onTransactionCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> T runTransaction(String action, Supplier<T> operation) {
        T result;
        this.referenceDelegate.onTransactionStarted();
        try {
            result = operation.get();
        }
        finally {
            this.referenceDelegate.onTransactionCommitted();
        }
        return result;
    }
}

