/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.database.collection.ImmutableSortedMap;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.RemoteDocumentCache;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentCollections;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.MaybeDocument;
import com.google.firebase.firestore.model.ResourcePath;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

final class MemoryRemoteDocumentCache
implements RemoteDocumentCache {
    private ImmutableSortedMap<DocumentKey, MaybeDocument> docs = DocumentCollections.emptyMaybeDocumentMap();

    MemoryRemoteDocumentCache() {
    }

    @Override
    public void add(MaybeDocument document) {
        this.docs = this.docs.insert((Object)document.getKey(), (Object)document);
    }

    @Override
    public void remove(DocumentKey key) {
        this.docs = this.docs.remove((Object)key);
    }

    @Override
    @Nullable
    public MaybeDocument get(DocumentKey key) {
        return (MaybeDocument)this.docs.get((Object)key);
    }

    @Override
    public Map<DocumentKey, MaybeDocument> getAll(Iterable<DocumentKey> keys) {
        HashMap<DocumentKey, MaybeDocument> result = new HashMap<DocumentKey, MaybeDocument>();
        for (DocumentKey key : keys) {
            result.put(key, this.get(key));
        }
        return result;
    }

    @Override
    public ImmutableSortedMap<DocumentKey, Document> getAllDocumentsMatchingQuery(Query query) {
        Map.Entry entry;
        DocumentKey key;
        ImmutableSortedMap result = DocumentCollections.emptyDocumentMap();
        ResourcePath queryPath = query.getPath();
        DocumentKey prefix = DocumentKey.fromPath((ResourcePath)((Object)queryPath.append("")));
        Iterator iterator = this.docs.iteratorFrom((Object)prefix);
        while (iterator.hasNext() && queryPath.isPrefixOf((key = (DocumentKey)(entry = (Map.Entry)iterator.next()).getKey()).getPath())) {
            Document doc;
            MaybeDocument maybeDoc = (MaybeDocument)entry.getValue();
            if (!(maybeDoc instanceof Document) || !query.matches(doc = (Document)maybeDoc)) continue;
            result = result.insert((Object)doc.getKey(), (Object)doc);
        }
        return result;
    }

    ImmutableSortedMap<DocumentKey, MaybeDocument> getDocuments() {
        return this.docs;
    }

    private static long getKeySize(DocumentKey key) {
        ResourcePath path = key.getPath();
        long count = 0L;
        for (int i = 0; i < path.length(); ++i) {
            count += (long)(path.getSegment(i).length() * 2);
        }
        return count;
    }

    long getByteSize(LocalSerializer serializer) {
        long count = 0L;
        for (Map.Entry entry : this.docs) {
            count += MemoryRemoteDocumentCache.getKeySize((DocumentKey)entry.getKey());
            count += (long)serializer.encodeMaybeDocument((MaybeDocument)entry.getValue()).getSerializedSize();
        }
        return count;
    }
}

