/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.database.Cursor;
import android.util.SparseArray;
import com.google.firebase.firestore.core.ListenSequence;
import com.google.firebase.firestore.local.EncodedPath;
import com.google.firebase.firestore.local.LruDelegate;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.local.ReferenceDelegate;
import com.google.firebase.firestore.local.ReferenceSet;
import com.google.firebase.firestore.local.SQLiteLruReferenceDelegate$$Lambda$1;
import com.google.firebase.firestore.local.SQLiteLruReferenceDelegate$$Lambda$2;
import com.google.firebase.firestore.local.SQLiteLruReferenceDelegate$$Lambda$3;
import com.google.firebase.firestore.local.SQLitePersistence;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Consumer;

class SQLiteLruReferenceDelegate
implements ReferenceDelegate,
LruDelegate {
    private final SQLitePersistence persistence;
    private ListenSequence listenSequence;
    private long currentSequenceNumber = -1L;
    private final LruGarbageCollector garbageCollector;
    private ReferenceSet inMemoryPins;

    SQLiteLruReferenceDelegate(SQLitePersistence persistence, LruGarbageCollector.Params params) {
        this.persistence = persistence;
        this.garbageCollector = new LruGarbageCollector(this, params);
    }

    void start(long highestSequenceNumber) {
        this.listenSequence = new ListenSequence(highestSequenceNumber);
    }

    @Override
    public void onTransactionStarted() {
        Assert.hardAssert(this.currentSequenceNumber == -1L, "Starting a transaction without committing the previous one", new Object[0]);
        this.currentSequenceNumber = this.listenSequence.next();
    }

    @Override
    public void onTransactionCommitted() {
        Assert.hardAssert(this.currentSequenceNumber != -1L, "Committing a transaction without having started one", new Object[0]);
        this.currentSequenceNumber = -1L;
    }

    @Override
    public long getCurrentSequenceNumber() {
        Assert.hardAssert(this.currentSequenceNumber != -1L, "Attempting to get a sequence number outside of a transaction", new Object[0]);
        return this.currentSequenceNumber;
    }

    @Override
    public LruGarbageCollector getGarbageCollector() {
        return this.garbageCollector;
    }

    @Override
    public long getSequenceNumberCount() {
        long targetCount = this.persistence.getQueryCache().getTargetCount();
        long orphanedDocumentCount = (Long)this.persistence.query("SELECT COUNT(*) FROM (SELECT sequence_number FROM target_documents GROUP BY path HAVING COUNT(*) = 1 AND target_id = 0)").firstValue(SQLiteLruReferenceDelegate$$Lambda$1.lambdaFactory$());
        return targetCount + orphanedDocumentCount;
    }

    @Override
    public void forEachTarget(Consumer<QueryData> consumer) {
        this.persistence.getQueryCache().forEachTarget(consumer);
    }

    @Override
    public void forEachOrphanedDocumentSequenceNumber(Consumer<Long> consumer) {
        this.persistence.query("select sequence_number from target_documents group by path having COUNT(*) = 1 AND target_id = 0").forEach(SQLiteLruReferenceDelegate$$Lambda$2.lambdaFactory$(consumer));
    }

    @Override
    public void setInMemoryPins(ReferenceSet inMemoryPins) {
        this.inMemoryPins = inMemoryPins;
    }

    @Override
    public void addReference(DocumentKey key) {
        this.writeSentinel(key);
    }

    @Override
    public void removeReference(DocumentKey key) {
        this.writeSentinel(key);
    }

    @Override
    public int removeTargets(long upperBound, SparseArray<?> activeTargetIds) {
        return this.persistence.getQueryCache().removeQueries(upperBound, activeTargetIds);
    }

    @Override
    public void removeMutationReference(DocumentKey key) {
        this.writeSentinel(key);
    }

    private boolean mutationQueuesContainKey(DocumentKey key) {
        return !this.persistence.query("SELECT 1 FROM document_mutations WHERE path = ?").binding(EncodedPath.encode(key.getPath())).isEmpty();
    }

    private boolean isPinned(DocumentKey key) {
        if (this.inMemoryPins.containsKey(key)) {
            return true;
        }
        return this.mutationQueuesContainKey(key);
    }

    private void removeSentinel(DocumentKey key) {
        this.persistence.execute("DELETE FROM target_documents WHERE path = ? AND target_id = 0", EncodedPath.encode(key.getPath()));
    }

    @Override
    public int removeOrphanedDocuments(long upperBound) {
        int[] count = new int[1];
        this.persistence.query("select path from target_documents group by path having COUNT(*) = 1 AND target_id = 0 AND sequence_number <= ?").binding(upperBound).forEach(SQLiteLruReferenceDelegate$$Lambda$3.lambdaFactory$(this, count));
        return count[0];
    }

    @Override
    public void removeTarget(QueryData queryData) {
        QueryData updated = queryData.copy(queryData.getSnapshotVersion(), queryData.getResumeToken(), this.getCurrentSequenceNumber());
        this.persistence.getQueryCache().updateQueryData(updated);
    }

    @Override
    public void updateLimboDocument(DocumentKey key) {
        this.writeSentinel(key);
    }

    private void writeSentinel(DocumentKey key) {
        String path = EncodedPath.encode(key.getPath());
        this.persistence.execute("INSERT OR REPLACE INTO target_documents (target_id, path, sequence_number) VALUES (0, ?, ?)", path, this.getCurrentSequenceNumber());
    }

    @Override
    public long getByteSize() {
        return this.persistence.getByteSize();
    }

    static /* synthetic */ void lambda$removeOrphanedDocuments$2(SQLiteLruReferenceDelegate this_, int[] count, Cursor row) {
        ResourcePath path = EncodedPath.decodeResourcePath(row.getString(0));
        DocumentKey key = DocumentKey.fromPath(path);
        if (!this_.isPinned(key)) {
            count[0] = count[0] + 1;
            this_.persistence.getRemoteDocumentCache().remove(key);
            this_.removeSentinel(key);
        }
    }

    static /* synthetic */ void lambda$forEachOrphanedDocumentSequenceNumber$1(Consumer consumer, Cursor row) {
        consumer.accept(row.getLong(0));
    }

    static /* synthetic */ Long lambda$getSequenceNumberCount$0(Cursor row) {
        return row.getLong(0);
    }
}

