/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import com.google.firebase.firestore.core.Filter;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.FieldPath;
import com.google.firebase.firestore.model.value.DoubleValue;
import com.google.firebase.firestore.model.value.FieldValue;

public class NaNFilter
extends Filter {
    private final FieldPath fieldPath;

    public NaNFilter(FieldPath fieldPath) {
        this.fieldPath = fieldPath;
    }

    @Override
    public FieldPath getField() {
        return this.fieldPath;
    }

    @Override
    public boolean matches(Document doc) {
        FieldValue fieldValue = doc.getField(this.fieldPath);
        return fieldValue != null && fieldValue.equals(DoubleValue.NaN);
    }

    @Override
    public String getCanonicalId() {
        return this.fieldPath.canonicalString() + " IS NaN";
    }

    public String toString() {
        return this.getCanonicalId();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof NaNFilter)) {
            return false;
        }
        NaNFilter other = (NaNFilter)o;
        return this.fieldPath.equals(other.fieldPath);
    }

    public int hashCode() {
        int result = 41;
        result = 31 * result + this.fieldPath.hashCode();
        return result;
    }
}

