/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import android.support.annotation.Nullable;
import android.util.SparseArray;
import com.google.firebase.firestore.local.LocalStore;
import com.google.firebase.firestore.local.LruDelegate;
import com.google.firebase.firestore.local.LruGarbageCollector$$Lambda$1;
import com.google.firebase.firestore.local.LruGarbageCollector$$Lambda$2;
import com.google.firebase.firestore.local.LruGarbageCollector$RollingSequenceNumberBuffer$$Lambda$1;
import com.google.firebase.firestore.local.LruGarbageCollector$Scheduler$$Lambda$1;
import com.google.firebase.firestore.local.QueryData;
import com.google.firebase.firestore.util.AsyncQueue;
import com.google.firebase.firestore.util.Logger;
import java.util.Comparator;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;

public class LruGarbageCollector {
    private static final long INITIAL_GC_DELAY_MS = TimeUnit.MINUTES.toMillis(1L);
    private static final long REGULAR_GC_DELAY_MS = TimeUnit.MINUTES.toMillis(5L);
    private final LruDelegate delegate;
    private final Params params;

    LruGarbageCollector(LruDelegate delegate, Params params) {
        this.delegate = delegate;
        this.params = params;
    }

    public Scheduler newScheduler(AsyncQueue asyncQueue, LocalStore localStore) {
        return new Scheduler(asyncQueue, localStore);
    }

    int calculateQueryCount(int percentile) {
        long targetCount = this.delegate.getSequenceNumberCount();
        return (int)((float)percentile / 100.0f * (float)targetCount);
    }

    long getNthSequenceNumber(int count) {
        if (count == 0) {
            return -1L;
        }
        RollingSequenceNumberBuffer buffer = new RollingSequenceNumberBuffer(count);
        this.delegate.forEachTarget(LruGarbageCollector$$Lambda$1.lambdaFactory$(buffer));
        RollingSequenceNumberBuffer rollingSequenceNumberBuffer = buffer;
        rollingSequenceNumberBuffer.getClass();
        this.delegate.forEachOrphanedDocumentSequenceNumber(LruGarbageCollector$$Lambda$2.lambdaFactory$(rollingSequenceNumberBuffer));
        return buffer.getMaxValue();
    }

    int removeTargets(long upperBound, SparseArray<?> activeTargetIds) {
        return this.delegate.removeTargets(upperBound, activeTargetIds);
    }

    int removeOrphanedDocuments(long upperBound) {
        return this.delegate.removeOrphanedDocuments(upperBound);
    }

    Results collect(SparseArray<?> activeTargetIds) {
        if (this.params.minBytesThreshold == -1L) {
            Logger.debug("LruGarbageCollector", "Garbage collection skipped; disabled", new Object[0]);
            return Results.DidNotRun();
        }
        long cacheSize = this.getByteSize();
        if (cacheSize < this.params.minBytesThreshold) {
            Logger.debug("LruGarbageCollector", "Garbage collection skipped; Cache size " + cacheSize + " is lower than threshold " + this.params.minBytesThreshold, new Object[0]);
            return Results.DidNotRun();
        }
        return this.runGarbageCollection(activeTargetIds);
    }

    private Results runGarbageCollection(SparseArray<?> liveTargetIds) {
        long startTs = System.currentTimeMillis();
        int sequenceNumbers = this.calculateQueryCount(this.params.percentileToCollect);
        if (sequenceNumbers > this.params.maximumSequenceNumbersToCollect) {
            Logger.debug("LruGarbageCollector", "Capping sequence numbers to collect down to the maximum of " + this.params.maximumSequenceNumbersToCollect + " from " + sequenceNumbers, new Object[0]);
            sequenceNumbers = this.params.maximumSequenceNumbersToCollect;
        }
        long countedTargetsTs = System.currentTimeMillis();
        long upperBound = this.getNthSequenceNumber(sequenceNumbers);
        long foundUpperBoundTs = System.currentTimeMillis();
        int numTargetsRemoved = this.removeTargets(upperBound, liveTargetIds);
        long removedTargetsTs = System.currentTimeMillis();
        int numDocumentsRemoved = this.removeOrphanedDocuments(upperBound);
        long removedDocumentsTs = System.currentTimeMillis();
        if (Logger.isDebugEnabled()) {
            String desc = "LRU Garbage Collection:\n";
            desc = desc + "\tCounted targets in " + (countedTargetsTs - startTs) + "ms\n";
            desc = desc + String.format(Locale.ROOT, "\tDetermined least recently used %d sequence numbers in %dms\n", sequenceNumbers, foundUpperBoundTs - countedTargetsTs);
            desc = desc + String.format(Locale.ROOT, "\tRemoved %d targets in %dms\n", numTargetsRemoved, removedTargetsTs - foundUpperBoundTs);
            desc = desc + String.format(Locale.ROOT, "\tRemoved %d documents in %dms\n", numDocumentsRemoved, removedDocumentsTs - removedTargetsTs);
            desc = desc + String.format(Locale.ROOT, "Total Duration: %dms", removedDocumentsTs - startTs);
            Logger.debug("LruGarbageCollector", desc, new Object[0]);
        }
        return new Results(true, sequenceNumbers, numTargetsRemoved, numDocumentsRemoved);
    }

    long getByteSize() {
        return this.delegate.getByteSize();
    }

    static /* synthetic */ void lambda$getNthSequenceNumber$0(RollingSequenceNumberBuffer buffer, QueryData queryData) {
        buffer.addElement(queryData.getSequenceNumber());
    }

    private static class RollingSequenceNumberBuffer {
        private static final Comparator<Long> COMPARATOR = LruGarbageCollector$RollingSequenceNumberBuffer$$Lambda$1.lambdaFactory$();
        private final PriorityQueue<Long> queue;
        private final int maxElements;

        RollingSequenceNumberBuffer(int count) {
            this.maxElements = count;
            this.queue = new PriorityQueue<Long>(count, COMPARATOR);
        }

        void addElement(Long sequenceNumber) {
            if (this.queue.size() < this.maxElements) {
                this.queue.add(sequenceNumber);
            } else {
                Long highestValue = this.queue.peek();
                if (sequenceNumber < highestValue) {
                    this.queue.poll();
                    this.queue.add(sequenceNumber);
                }
            }
        }

        long getMaxValue() {
            return this.queue.peek();
        }

        static /* synthetic */ int lambda$static$0(Long a, Long b) {
            return b.compareTo(a);
        }
    }

    public class Scheduler {
        private final AsyncQueue asyncQueue;
        private final LocalStore localStore;
        private boolean hasRun = false;
        @Nullable
        private AsyncQueue.DelayedTask gcTask;

        public Scheduler(AsyncQueue asyncQueue, LocalStore localStore) {
            this.asyncQueue = asyncQueue;
            this.localStore = localStore;
        }

        public void start() {
            if (((LruGarbageCollector)LruGarbageCollector.this).params.minBytesThreshold != -1L) {
                this.scheduleGC();
            }
        }

        public void stop() {
            if (this.gcTask != null) {
                this.gcTask.cancel();
            }
        }

        private void scheduleGC() {
            long delay = this.hasRun ? REGULAR_GC_DELAY_MS : INITIAL_GC_DELAY_MS;
            this.gcTask = this.asyncQueue.enqueueAfterDelay(AsyncQueue.TimerId.GARBAGE_COLLECTION, delay, LruGarbageCollector$Scheduler$$Lambda$1.lambdaFactory$(this));
        }

        static /* synthetic */ void lambda$scheduleGC$0(Scheduler this_) {
            this_.localStore.collectGarbage(this_.LruGarbageCollector.this);
            this_.hasRun = true;
            this_.scheduleGC();
        }
    }

    public static class Results {
        private final boolean hasRun;
        private final int sequenceNumbersCollected;
        private final int targetsRemoved;
        private final int documentsRemoved;

        static Results DidNotRun() {
            return new Results(false, 0, 0, 0);
        }

        Results(boolean hasRun, int sequenceNumbersCollected, int targetsRemoved, int documentsRemoved) {
            this.hasRun = hasRun;
            this.sequenceNumbersCollected = sequenceNumbersCollected;
            this.targetsRemoved = targetsRemoved;
            this.documentsRemoved = documentsRemoved;
        }

        public boolean hasRun() {
            return this.hasRun;
        }

        public int getSequenceNumbersCollected() {
            return this.sequenceNumbersCollected;
        }

        public int getTargetsRemoved() {
            return this.targetsRemoved;
        }

        public int getDocumentsRemoved() {
            return this.documentsRemoved;
        }
    }

    public static class Params {
        private static final long COLLECTION_DISABLED = -1L;
        private static final long DEFAULT_CACHE_SIZE_BYTES = 0x6400000L;
        private static final int DEFAULT_COLLECTION_PERCENTILE = 10;
        private static final int DEFAULT_MAX_SEQUENCE_NUMBERS_TO_COLLECT = 1000;
        final long minBytesThreshold;
        final int percentileToCollect;
        final int maximumSequenceNumbersToCollect;

        public static Params Default() {
            return new Params(0x6400000L, 10, 1000);
        }

        public static Params Disabled() {
            return new Params(-1L, 0, 0);
        }

        public static Params WithCacheSizeBytes(long cacheSizeBytes) {
            return new Params(cacheSizeBytes, 10, 1000);
        }

        Params(long minBytesThreshold, int percentileToCollect, int maximumSequenceNumbersToCollect) {
            this.minBytesThreshold = minBytesThreshold;
            this.percentileToCollect = percentileToCollect;
            this.maximumSequenceNumbersToCollect = maximumSequenceNumbersToCollect;
        }
    }
}

