/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import android.app.Activity;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.common.base.Preconditions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.firestore.CollectionReference;
import com.google.firebase.firestore.DocumentReference$$Lambda$1;
import com.google.firebase.firestore.DocumentReference$$Lambda$2;
import com.google.firebase.firestore.DocumentReference$$Lambda$3;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.EventListener;
import com.google.firebase.firestore.FieldPath;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.MetadataChanges;
import com.google.firebase.firestore.SetOptions;
import com.google.firebase.firestore.Source;
import com.google.firebase.firestore.core.ActivityScope;
import com.google.firebase.firestore.core.AsyncEventListener;
import com.google.firebase.firestore.core.EventManager;
import com.google.firebase.firestore.core.ListenerRegistrationImpl;
import com.google.firebase.firestore.core.Query;
import com.google.firebase.firestore.core.QueryListener;
import com.google.firebase.firestore.core.UserData;
import com.google.firebase.firestore.core.ViewSnapshot;
import com.google.firebase.firestore.model.Document;
import com.google.firebase.firestore.model.DocumentKey;
import com.google.firebase.firestore.model.ResourcePath;
import com.google.firebase.firestore.model.mutation.DeleteMutation;
import com.google.firebase.firestore.model.mutation.Precondition;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Executors;
import com.google.firebase.firestore.util.Util;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@PublicApi
public class DocumentReference {
    private final DocumentKey key;
    private final FirebaseFirestore firestore;

    DocumentReference(DocumentKey key, FirebaseFirestore firestore) {
        this.key = (DocumentKey)Preconditions.checkNotNull((Object)key);
        this.firestore = firestore;
    }

    static DocumentReference forPath(ResourcePath path, FirebaseFirestore firestore) {
        if (path.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid document reference. Document references must have an even number of segments, but " + path.canonicalString() + " has " + path.length());
        }
        return new DocumentReference(DocumentKey.fromPath(path), firestore);
    }

    DocumentKey getKey() {
        return this.key;
    }

    @NonNull
    @PublicApi
    public FirebaseFirestore getFirestore() {
        return this.firestore;
    }

    @NonNull
    @PublicApi
    public String getId() {
        return this.key.getPath().getLastSegment();
    }

    @NonNull
    @PublicApi
    public CollectionReference getParent() {
        return new CollectionReference((ResourcePath)this.key.getPath().popLast(), this.firestore);
    }

    @NonNull
    @PublicApi
    public String getPath() {
        return this.key.getPath().canonicalString();
    }

    @NonNull
    @PublicApi
    public CollectionReference collection(@NonNull String collectionPath) {
        Preconditions.checkNotNull((Object)collectionPath, (Object)"Provided collection path must not be null.");
        return new CollectionReference(this.key.getPath().append(ResourcePath.fromString(collectionPath)), this.firestore);
    }

    @NonNull
    @PublicApi
    public Task<Void> set(@NonNull Object data) {
        return this.set(data, SetOptions.OVERWRITE);
    }

    @NonNull
    @PublicApi
    public Task<Void> set(@NonNull Object data, @NonNull SetOptions options) {
        Preconditions.checkNotNull((Object)data, (Object)"Provided data must not be null.");
        Preconditions.checkNotNull((Object)options, (Object)"Provided options must not be null.");
        UserData.ParsedSetData parsed = options.isMerge() ? this.firestore.getDataConverter().parseMergeData(data, options.getFieldMask()) : this.firestore.getDataConverter().parseSetData(data);
        return this.firestore.getClient().write(parsed.toMutationList(this.key, Precondition.NONE)).continueWith(Executors.DIRECT_EXECUTOR, Util.voidErrorTransformer());
    }

    @NonNull
    @PublicApi
    public Task<Void> update(@NonNull Map<String, Object> data) {
        UserData.ParsedUpdateData parsedData = this.firestore.getDataConverter().parseUpdateData(data);
        return this.update(parsedData);
    }

    @NonNull
    @PublicApi
    public Task<Void> update(@NonNull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        UserData.ParsedUpdateData parsedData = this.firestore.getDataConverter().parseUpdateData(Util.collectUpdateArguments(1, field, value, moreFieldsAndValues));
        return this.update(parsedData);
    }

    @NonNull
    @PublicApi
    public Task<Void> update(@NonNull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        UserData.ParsedUpdateData parsedData = this.firestore.getDataConverter().parseUpdateData(Util.collectUpdateArguments(1, fieldPath, value, moreFieldsAndValues));
        return this.update(parsedData);
    }

    private Task<Void> update(@NonNull UserData.ParsedUpdateData parsedData) {
        return this.firestore.getClient().write(parsedData.toMutationList(this.key, Precondition.exists(true))).continueWith(Executors.DIRECT_EXECUTOR, Util.voidErrorTransformer());
    }

    @NonNull
    @PublicApi
    public Task<Void> delete() {
        return this.firestore.getClient().write(Collections.singletonList(new DeleteMutation(this.key, Precondition.NONE))).continueWith(Executors.DIRECT_EXECUTOR, Util.voidErrorTransformer());
    }

    @NonNull
    @PublicApi
    public Task<DocumentSnapshot> get() {
        return this.get(Source.DEFAULT);
    }

    @NonNull
    @PublicApi
    public Task<DocumentSnapshot> get(@NonNull Source source) {
        if (source == Source.CACHE) {
            return this.firestore.getClient().getDocumentFromLocalCache(this.key).continueWith(Executors.DIRECT_EXECUTOR, DocumentReference$$Lambda$1.lambdaFactory$(this));
        }
        return this.getViaSnapshotListener(source);
    }

    @NonNull
    private Task<DocumentSnapshot> getViaSnapshotListener(Source source) {
        TaskCompletionSource res = new TaskCompletionSource();
        TaskCompletionSource registration = new TaskCompletionSource();
        EventManager.ListenOptions options = new EventManager.ListenOptions();
        options.includeDocumentMetadataChanges = true;
        options.includeQueryMetadataChanges = true;
        options.waitForSyncWhenOnline = true;
        ListenerRegistration listenerRegistration = this.addSnapshotListenerInternal(Executors.DIRECT_EXECUTOR, options, null, DocumentReference$$Lambda$2.lambdaFactory$(res, registration, source));
        registration.setResult((Object)listenerRegistration);
        return res.getTask();
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull EventListener<DocumentSnapshot> listener) {
        return this.addSnapshotListener(MetadataChanges.EXCLUDE, listener);
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull EventListener<DocumentSnapshot> listener) {
        return this.addSnapshotListener(executor, MetadataChanges.EXCLUDE, listener);
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull EventListener<DocumentSnapshot> listener) {
        return this.addSnapshotListener(activity, MetadataChanges.EXCLUDE, listener);
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull MetadataChanges metadataChanges, @NonNull EventListener<DocumentSnapshot> listener) {
        return this.addSnapshotListener(Executors.DEFAULT_CALLBACK_EXECUTOR, metadataChanges, listener);
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Executor executor, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<DocumentSnapshot> listener) {
        Preconditions.checkNotNull((Object)executor, (Object)"Provided executor must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.addSnapshotListenerInternal(executor, DocumentReference.internalOptions(metadataChanges), null, listener);
    }

    @NonNull
    @PublicApi
    public ListenerRegistration addSnapshotListener(@NonNull Activity activity, @NonNull MetadataChanges metadataChanges, @NonNull EventListener<DocumentSnapshot> listener) {
        Preconditions.checkNotNull((Object)activity, (Object)"Provided activity must not be null.");
        Preconditions.checkNotNull((Object)((Object)metadataChanges), (Object)"Provided MetadataChanges value must not be null.");
        Preconditions.checkNotNull(listener, (Object)"Provided EventListener must not be null.");
        return this.addSnapshotListenerInternal(Executors.DEFAULT_CALLBACK_EXECUTOR, DocumentReference.internalOptions(metadataChanges), activity, listener);
    }

    private ListenerRegistration addSnapshotListenerInternal(Executor userExecutor, EventManager.ListenOptions options, @Nullable Activity activity, EventListener<DocumentSnapshot> userListener) {
        EventListener viewListener = DocumentReference$$Lambda$3.lambdaFactory$(this, userListener);
        AsyncEventListener<ViewSnapshot> asyncListener = new AsyncEventListener<ViewSnapshot>(userExecutor, viewListener);
        Query query = this.asQuery();
        QueryListener queryListener = this.firestore.getClient().listen(query, options, asyncListener);
        return ActivityScope.bind(activity, new ListenerRegistrationImpl(this.firestore.getClient(), queryListener, asyncListener));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentReference)) {
            return false;
        }
        DocumentReference that = (DocumentReference)o;
        return this.key.equals(that.key) && this.firestore.equals(that.firestore);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.firestore.hashCode();
        return result;
    }

    private Query asQuery() {
        return Query.atPath(this.key.getPath());
    }

    private static EventManager.ListenOptions internalOptions(MetadataChanges metadataChanges) {
        EventManager.ListenOptions internalOptions = new EventManager.ListenOptions();
        internalOptions.includeDocumentMetadataChanges = metadataChanges == MetadataChanges.INCLUDE;
        internalOptions.includeQueryMetadataChanges = metadataChanges == MetadataChanges.INCLUDE;
        internalOptions.waitForSyncWhenOnline = false;
        return internalOptions;
    }

    static /* synthetic */ void lambda$addSnapshotListenerInternal$2(DocumentReference this_, EventListener userListener, ViewSnapshot snapshot, FirebaseFirestoreException error) {
        DocumentSnapshot documentSnapshot;
        if (error != null) {
            userListener.onEvent(null, error);
            return;
        }
        Assert.hardAssert(snapshot != null, "Got event without value or error set", new Object[0]);
        Assert.hardAssert(snapshot.getDocuments().size() <= 1, "Too many documents returned on a document query", new Object[0]);
        Document document = snapshot.getDocuments().getDocument(this_.key);
        if (document != null) {
            boolean hasPendingWrites = snapshot.getMutatedKeys().contains((Object)document.getKey());
            documentSnapshot = DocumentSnapshot.fromDocument(this_.firestore, document, snapshot.isFromCache(), hasPendingWrites);
        } else {
            documentSnapshot = DocumentSnapshot.fromNoDocument(this_.firestore, this_.key, snapshot.isFromCache(), false);
        }
        userListener.onEvent(documentSnapshot, null);
    }

    static /* synthetic */ void lambda$getViaSnapshotListener$1(TaskCompletionSource res, TaskCompletionSource registration, Source source, DocumentSnapshot snapshot, FirebaseFirestoreException error) {
        if (error != null) {
            res.setException((Exception)((Object)error));
            return;
        }
        try {
            ListenerRegistration actualRegistration = (ListenerRegistration)Tasks.await((Task)registration.getTask());
            actualRegistration.remove();
            if (!snapshot.exists() && snapshot.getMetadata().isFromCache()) {
                res.setException((Exception)((Object)new FirebaseFirestoreException("Failed to get document because the client is offline.", FirebaseFirestoreException.Code.UNAVAILABLE)));
            } else if (snapshot.exists() && snapshot.getMetadata().isFromCache() && source == Source.SERVER) {
                res.setException((Exception)((Object)new FirebaseFirestoreException("Failed to get document from server. (However, this document does exist in the local cache. Run again without setting source to SERVER to retrieve the cached document.)", FirebaseFirestoreException.Code.UNAVAILABLE)));
            } else {
                res.setResult((Object)snapshot);
            }
        }
        catch (ExecutionException e) {
            throw Assert.fail(e, "Failed to register a listener for a single document", new Object[0]);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Assert.fail(e, "Failed to register a listener for a single document", new Object[0]);
        }
    }

    static /* synthetic */ DocumentSnapshot lambda$get$0(DocumentReference this_, Task task) throws Exception {
        Document doc = (Document)task.getResult();
        boolean hasPendingWrites = doc != null && doc.hasLocalMutations();
        return new DocumentSnapshot(this_.firestore, this_.key, doc, true, hasPendingWrites);
    }
}

